/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.get;

import io.lucenia.action.get.TransportShardMultiGetAction;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.RoutingMissingException;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.get.MultiGetAction;
import io.skylite.core.action.get.MultiGetItemResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.get.MultiGetShardRequest;
import io.skylite.core.action.get.MultiGetShardResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.routing.Preference;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.concurrent.AtomicArray;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class TransportMultiGetAction
extends HandledTransportAction<MultiGetRequest, MultiGetResponse> {
    private final ClusterService clusterService;
    private final TransportShardMultiGetAction shardAction;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportMultiGetAction(TransportService transportService, ClusterService clusterService, TransportShardMultiGetAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver resolver) {
        super("indices:data/read/mget", transportService, actionFilters, MultiGetRequest::new);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
        this.indexNameExpressionResolver = resolver;
    }

    protected static boolean shouldForcePrimaryRouting(Metadata metadata, boolean realtime, String preference, String indexName) {
        return metadata.isSegmentReplicationEnabled(indexName) && realtime && preference == null;
    }

    protected void doExecute(Task task, MultiGetRequest request, ActionListener<MultiGetResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        AtomicArray responses = new AtomicArray(request.getItems().size());
        HashMap<ShardId, MultiGetShardRequest> shardRequests = new HashMap<ShardId, MultiGetShardRequest>();
        for (int i = 0; i < request.getItems().size(); ++i) {
            String concreteSingleIndex;
            MultiGetRequest.Item item;
            block7: {
                item = (MultiGetRequest.Item)request.getItems().get(i);
                try {
                    concreteSingleIndex = this.indexNameExpressionResolver.concreteSingleIndex(clusterState, (IndicesRequest)item).getName();
                    item.routing(clusterState.metadata().resolveIndexRouting(item.routing(), item.index()));
                    if (item.routing() == null && clusterState.getMetadata().routingRequired(concreteSingleIndex)) {
                        responses.set(i, (Object)TransportMultiGetAction.newItemFailure(concreteSingleIndex, item.id(), (Exception)((Object)new RoutingMissingException(concreteSingleIndex, item.id()))));
                    }
                    break block7;
                }
                catch (Exception e) {
                    responses.set(i, (Object)TransportMultiGetAction.newItemFailure(item.index(), item.id(), e));
                }
                continue;
            }
            ShardId shardId = this.clusterService.operationRouting().getShards(clusterState, concreteSingleIndex, item.id(), item.routing(), null).shardId();
            MultiGetShardRequest shardRequest = (MultiGetShardRequest)shardRequests.get(shardId);
            if (shardRequest == null) {
                if (TransportMultiGetAction.shouldForcePrimaryRouting(clusterState.getMetadata(), request.realtime(), request.preference(), concreteSingleIndex)) {
                    request.preference(Preference.PRIMARY.type());
                }
                shardRequest = new MultiGetShardRequest(request, shardId.getIndexName(), shardId.getId());
                shardRequests.put(shardId, shardRequest);
            }
            shardRequest.add(i, item);
        }
        if (shardRequests.isEmpty()) {
            listener.onResponse((Object)new MultiGetResponse((MultiGetItemResponse[])responses.toArray((Object[])new MultiGetItemResponse[responses.length()])));
        }
        this.executeShardAction(listener, (AtomicArray<MultiGetItemResponse>)responses, shardRequests);
    }

    protected void executeShardAction(final ActionListener<MultiGetResponse> listener, final AtomicArray<MultiGetItemResponse> responses, Map<ShardId, MultiGetShardRequest> shardRequests) {
        final AtomicInteger counter = new AtomicInteger(shardRequests.size());
        for (final MultiGetShardRequest shardRequest : shardRequests.values()) {
            this.shardAction.execute((ActionRequest)shardRequest, (ActionListener)new ActionListener<MultiGetShardResponse>(){

                public void onResponse(MultiGetShardResponse response) {
                    for (int i = 0; i < response.getLocations().size(); ++i) {
                        MultiGetItemResponse itemResponse = new MultiGetItemResponse((GetResponse)response.getResponses().get(i), (MultiGetResponse.Failure)response.getFailures().get(i));
                        responses.set(((Integer)response.getLocations().get(i)).intValue(), (Object)itemResponse);
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                public void onFailure(Exception e) {
                    for (int i = 0; i < shardRequest.locations().size(); ++i) {
                        MultiGetRequest.Item item = (MultiGetRequest.Item)shardRequest.items().get(i);
                        responses.set(((Integer)shardRequest.locations().get(i)).intValue(), (Object)TransportMultiGetAction.newItemFailure(shardRequest.index(), item.id(), e));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse((Object)new MultiGetResponse((MultiGetItemResponse[])responses.toArray((Object[])new MultiGetItemResponse[responses.length()])));
                }
            });
        }
    }

    private static MultiGetItemResponse newItemFailure(String index, String id, Exception exception) {
        return new MultiGetItemResponse(null, new MultiGetResponse.Failure(index, id, exception));
    }

    public static class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return MultiGetAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportMultiGetAction.class;
        }
    }
}

