/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.get;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.get.MultiGetShardRequest;
import io.skylite.core.action.get.MultiGetShardResponse;
import io.skylite.core.action.support.TransportActions;
import io.skylite.core.action.support.single.shard.SingleShardRequest;
import io.skylite.core.action.support.single.shard.TransportSingleShardAction;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.get.GetResult;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class TransportShardMultiGetAction
extends TransportSingleShardAction<MultiGetShardRequest, MultiGetShardResponse> {
    private static final String ACTION_NAME = "indices:data/read/mget[shard]";
    private final IndicesService indicesService;

    @Inject
    public TransportShardMultiGetAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, MultiGetShardRequest::new, "get");
        this.indicesService = indicesService;
    }

    protected boolean isSubAction() {
        return true;
    }

    protected Writeable.Reader<MultiGetShardResponse> getResponseReader() {
        return MultiGetShardResponse::new;
    }

    protected boolean resolveIndex(MultiGetShardRequest request) {
        return true;
    }

    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(state, ((MultiGetShardRequest)request.request()).index(), ((MultiGetShardRequest)request.request()).shardId(), ((MultiGetShardRequest)request.request()).preference());
    }

    protected void asyncShardOperation(MultiGetShardRequest request, ShardId shardId, ActionListener<MultiGetShardResponse> listener) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.realtime()) {
            super.asyncShardOperation((SingleShardRequest)request, shardId, listener);
        } else {
            indexShard.awaitShardSearchActive(b -> {
                try {
                    super.asyncShardOperation((SingleShardRequest)request, shardId, listener);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
    }

    protected MultiGetShardResponse shardOperation(MultiGetShardRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.refresh() && !request.realtime()) {
            indexShard.refresh("refresh_flag_mget");
        }
        MultiGetShardResponse response = new MultiGetShardResponse();
        for (int i = 0; i < request.locations().size(); ++i) {
            MultiGetRequest.Item item = (MultiGetRequest.Item)request.items().get(i);
            try {
                GetResult getResult = indexShard.getService().get(item.id(), item.storedFields(), request.realtime(), item.version(), item.versionType(), item.fetchSourceContext());
                response.add(((Integer)request.locations().get(i)).intValue(), new GetResponse(getResult));
                continue;
            }
            catch (RuntimeException e) {
                if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                    throw e;
                }
                this.logger.debug(() -> new ParameterizedMessage("{} failed to execute multi_get for [{}]", (Object)shardId, (Object)item.id()), (Throwable)e);
                response.add(((Integer)request.locations().get(i)).intValue(), new MultiGetResponse.Failure(request.index(), item.id(), (Exception)e));
            }
        }
        return response;
    }

    protected String getExecutor(MultiGetShardRequest request, ShardId shardId) {
        ClusterState clusterState = this.clusterService.state();
        if (clusterState.metadata().index(shardId.getIndex()).isSystem()) {
            return "system_read";
        }
        if (this.indicesService.indexServiceSafe(shardId.getIndex()).getIndexSettings().isSearchThrottled()) {
            return "search_throttled";
        }
        return super.getExecutor((SingleShardRequest)request, shardId);
    }
}

