/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.ingest;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.node.info.NodeInfo;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.ingest.PutPipelineAction;
import io.skylite.core.action.ingest.PutPipelineRequest;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.OriginSettingClient;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.ingest.IngestInfo;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;
import org.opensearch.ingest.IngestService;

public class PutPipelineTransportAction
extends TransportClusterManagerNodeAction<PutPipelineRequest, AcknowledgedResponse> {
    private final IngestService ingestService;
    private final OriginSettingClient client;

    @Inject
    public PutPipelineTransportAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IngestService ingestService, NodeClient client) {
        super("cluster:admin/ingest/pipeline/put", transportService, ingestService.getClusterService(), threadPool, actionFilters, PutPipelineRequest::new, indexNameExpressionResolver);
        this.client = new OriginSettingClient((Client)client, "ingest");
        this.ingestService = ingestService;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void clusterManagerOperation(PutPipelineRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[0]);
        nodesInfoRequest.clear().addMetric(NodesInfoRequest.Metric.INGEST.metricName());
        this.client.admin().cluster().nodesInfo(nodesInfoRequest, ActionListenerHelper.wrap(nodeInfos -> {
            HashMap<DiscoveryNode, IngestInfo> ingestInfos = new HashMap<DiscoveryNode, IngestInfo>();
            for (NodeInfo nodeInfo : nodeInfos.getNodes()) {
                ingestInfos.put(nodeInfo.getNode(), (IngestInfo)nodeInfo.getInfo(IngestInfo.class));
            }
            this.ingestService.putPipeline(ingestInfos, request, listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(PutPipelineRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return PutPipelineAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return PutPipelineTransportAction.class;
        }
    }
}

