/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.pagination;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;
import java.util.Objects;

public class PageToken
implements Writeable {
    public static final String PAGINATED_RESPONSE_NEXT_TOKEN_KEY = "next_token";
    private final String nextToken;
    private final String paginatedEntity;

    public PageToken(String nextToken, String paginatedElement) {
        assert (paginatedElement != null) : "paginatedElement must be specified for a paginated response";
        this.nextToken = nextToken;
        this.paginatedEntity = paginatedElement;
    }

    public PageToken(StreamInput in) throws IOException {
        this.nextToken = in.readOptionalString();
        this.paginatedEntity = in.readString();
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public String getPaginatedEntity() {
        return this.paginatedEntity;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.nextToken);
        out.writeString(this.paginatedEntity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageToken that = (PageToken)o;
        return Objects.equals(this.nextToken, that.nextToken) && Objects.equals(this.paginatedEntity, that.paginatedEntity);
    }

    public int hashCode() {
        return Objects.hash(this.nextToken, this.paginatedEntity);
    }
}

