/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.resync;

import io.skylite.common.action.ActionListener;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.resync.ResyncReplicationRequest;
import io.skylite.core.action.resync.ResyncReplicationResponse;
import io.skylite.core.action.support.replication.ReplicatedWriteRequest;
import io.skylite.core.action.support.replication.ReplicationOperation;
import io.skylite.core.action.support.replication.TransportReplicationAction;
import io.skylite.core.action.support.replication.TransportWriteAction;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.pressure.IndexingPressureService;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.PrimaryReplicaSyncer;
import io.skylite.core.index.translog.TranslogLocation;
import io.skylite.core.index.translog.TranslogOperation;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class TransportResyncReplicationAction
extends TransportWriteAction<ResyncReplicationRequest, ResyncReplicationRequest, ResyncReplicationResponse>
implements PrimaryReplicaSyncer.SyncAction {
    private static String ACTION_NAME = "internal:index/seq_no/resync";
    private static final Function<BaseIndexShard, String> EXECUTOR_NAME_FUNCTION = shard -> {
        if (shard.indexSettings().getIndexMetadata().isSystem()) {
            return "system_write";
        }
        return "write";
    };

    @Inject
    public TransportResyncReplicationAction(Settings settings, TransportService transportService, ClusterService clusterService, TransportReplicationAction.IndexServiceProvider indexServiceProvider, ThreadPool threadPool, TransportReplicationAction.RemoteShardFailedAction remoteShardFailedAction, ActionFilters actionFilters, IndexingPressureService indexingPressureService, SystemIndices systemIndices, Tracer tracer) {
        super(settings, ACTION_NAME, transportService, clusterService, indexServiceProvider, threadPool, remoteShardFailedAction, actionFilters, ResyncReplicationRequest::new, ResyncReplicationRequest::new, EXECUTOR_NAME_FUNCTION, true, indexingPressureService, systemIndices, tracer);
    }

    protected void doExecute(Task parentTask, ResyncReplicationRequest request, ActionListener<ResyncReplicationResponse> listener) {
        assert (false) : "use TransportResyncReplicationAction#sync";
    }

    protected ResyncReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ResyncReplicationResponse(in);
    }

    public ReplicationOperation.Replicas newReplicasProxy() {
        return new ResyncActionReplicasProxy();
    }

    protected ClusterBlockLevel globalBlockLevel() {
        return null;
    }

    public ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    protected void dispatchedShardOperationOnPrimary(ResyncReplicationRequest request, BaseIndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ResyncReplicationRequest, ResyncReplicationResponse>> listener) {
        ActionListenerHelper.completeWith(listener, () -> new TransportWriteAction.WritePrimaryResult((ReplicatedWriteRequest)TransportResyncReplicationAction.performOnPrimary(request), (ReplicationResponse)new ResyncReplicationResponse(), null, null, primary, this.logger));
    }

    protected long primaryOperationSize(ResyncReplicationRequest request) {
        return Stream.of(request.getOperations()).mapToLong(TranslogOperation::estimateSize).sum();
    }

    public static ResyncReplicationRequest performOnPrimary(ResyncReplicationRequest request) {
        return request;
    }

    protected void dispatchedShardOperationOnReplica(ResyncReplicationRequest request, BaseIndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            TranslogLocation location = TransportResyncReplicationAction.performOnReplica(request, replica);
            return new TransportWriteAction.WriteReplicaResult((ReplicatedWriteRequest)request, location, null, replica, this.logger);
        });
    }

    protected long replicaOperationSize(ResyncReplicationRequest request) {
        return Stream.of(request.getOperations()).mapToLong(TranslogOperation::estimateSize).sum();
    }

    public static TranslogLocation performOnReplica(ResyncReplicationRequest request, BaseIndexShard replica) throws Exception {
        TranslogLocation location = null;
        replica.updateMaxUnsafeAutoIdTimestamp(request.getMaxSeenAutoIdTimestampOnPrimary());
        for (TranslogOperation operation : request.getOperations()) {
            EngineResult operationResult = replica.applyTranslogOperation(operation, EngineOperation.Origin.REPLICA);
            if (operationResult.getResultType() == EngineResult.Type.MAPPING_UPDATE_REQUIRED) {
                throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + operationResult.getRequiredMappingUpdate());
            }
            location = TransportResyncReplicationAction.syncOperationResultOrThrow((EngineResult)operationResult, location);
        }
        if (request.getTrimAboveSeqNo() != -2L) {
            replica.trimOperationOfPreviousPrimaryTerms(request.getTrimAboveSeqNo());
        }
        return location;
    }

    public void sync(ResyncReplicationRequest request, Task parentTask, String primaryAllocationId, long primaryTerm, final ActionListener<ResyncReplicationResponse> listener) {
        this.transportService.sendChildRequest(this.clusterService.localNode(), this.transportPrimaryAction, (TransportRequest)new TransportReplicationAction.ConcreteShardRequest((TransportRequest)request, primaryAllocationId, primaryTerm), parentTask, this.transportOptions, (TransportResponseHandler)new TransportResponseHandler<ResyncReplicationResponse>(){

            public ResyncReplicationResponse read(StreamInput in) throws IOException {
                return TransportResyncReplicationAction.this.newResponseInstance(in);
            }

            public String executor() {
                return "same";
            }

            public void handleResponse(ResyncReplicationResponse response) {
                ReplicationResponse.ShardInfo.Failure[] failures = response.getShardInfo().getFailures();
                for (int i = 0; i < failures.length; ++i) {
                    ReplicationResponse.ShardInfo.Failure f = failures[i];
                    TransportResyncReplicationAction.this.logger.info((Message)new ParameterizedMessage("{} primary-replica resync to replica on node [{}] failed", (Object)f.fullShardId(), (Object)f.nodeId()), f.getCause());
                }
                listener.onResponse((Object)response);
            }

            public void handleException(TransportException exp) {
                listener.onFailure((Exception)exp);
            }
        });
    }

    class ResyncActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        ResyncActionReplicasProxy() {
            super((TransportReplicationAction)TransportResyncReplicationAction.this);
        }

        public void failShardIfNeeded(ShardRouting replica, long primaryTerm, String message, Exception exception, ActionListener<Void> listener) {
            TransportResyncReplicationAction.this.remoteShardFailedAction.execute(replica.shardId(), replica.allocationId().getId(), primaryTerm, false, message, exception, listener);
        }
    }
}

