/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.search;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.node.info.NodeInfo;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.search.PutSearchPipelineAction;
import io.skylite.core.action.search.PutSearchPipelineRequest;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.OriginSettingClient;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.search.pipeline.SearchPipelineInfo;
import io.skylite.core.search.pipeline.SearchPipelineService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;

public class PutSearchPipelineTransportAction
extends TransportClusterManagerNodeAction<PutSearchPipelineRequest, AcknowledgedResponse> {
    private final SearchPipelineService searchPipelineService;
    private final OriginSettingClient client;

    @Inject
    public PutSearchPipelineTransportAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SearchPipelineService searchPipelineService, NodeClient client) {
        super("cluster:admin/search/pipeline/put", transportService, searchPipelineService.getClusterService(), threadPool, actionFilters, PutSearchPipelineRequest::new, indexNameExpressionResolver);
        this.client = new OriginSettingClient((Client)client, "search_pipeline");
        this.searchPipelineService = searchPipelineService;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void clusterManagerOperation(PutSearchPipelineRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[0]);
        this.client.admin().cluster().nodesInfo(nodesInfoRequest, ActionListenerHelper.wrap(nodeInfos -> {
            HashMap<DiscoveryNode, SearchPipelineInfo> searchPipelineInfos = new HashMap<DiscoveryNode, SearchPipelineInfo>();
            for (NodeInfo nodeInfo : nodeInfos.getNodes()) {
                searchPipelineInfos.put(nodeInfo.getNode(), (SearchPipelineInfo)nodeInfo.getInfo(SearchPipelineInfo.class));
            }
            this.searchPipelineService.putPipeline(searchPipelineInfos, request, listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(PutSearchPipelineRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return PutSearchPipelineAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return PutSearchPipelineTransportAction.class;
        }
    }
}

