/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.search;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.search.SearchActionListener;
import io.skylite.core.node.ResponseCollectorService;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.fetch.QueryFetchSearchResult;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.transport.TransportConnection;
import java.util.Objects;
import java.util.function.BiFunction;

public final class SearchExecutionStatsCollector
implements ActionListener<SearchPhaseResult> {
    private final ActionListener<SearchPhaseResult> listener;
    private final String nodeId;
    private final ResponseCollectorService collector;
    private final long startNanos;

    SearchExecutionStatsCollector(ActionListener<SearchPhaseResult> listener, ResponseCollectorService collector, String nodeId) {
        this.listener = Objects.requireNonNull(listener, "listener cannot be null");
        this.collector = Objects.requireNonNull(collector, "response collector cannot be null");
        this.startNanos = System.nanoTime();
        this.nodeId = nodeId;
    }

    public static BiFunction<TransportConnection, SearchActionListener, ActionListener> makeWrapper(ResponseCollectorService service) {
        return (connection, originalListener) -> new SearchExecutionStatsCollector((ActionListener<SearchPhaseResult>)originalListener, service, connection.getNode().getId());
    }

    public void onResponse(SearchPhaseResult response) {
        if (response instanceof QueryFetchSearchResult) {
            response.queryResult().getShardSearchRequest().setOutboundNetworkTime(0L);
            response.queryResult().getShardSearchRequest().setInboundNetworkTime(0L);
        }
        QuerySearchResult queryResult = response.queryResult();
        if (response.getShardSearchRequest() != null) {
            if (response.remoteAddress() != null) {
                response.getShardSearchRequest().setOutboundNetworkTime(Math.max(0L, System.currentTimeMillis() - response.getShardSearchRequest().getOutboundNetworkTime()));
            } else {
                response.getShardSearchRequest().setOutboundNetworkTime(0L);
                response.getShardSearchRequest().setInboundNetworkTime(0L);
            }
        }
        if (this.nodeId != null && queryResult != null) {
            long serviceTimeEWMA = queryResult.serviceTimeEWMA();
            int queueSize = queryResult.nodeQueueSize();
            long responseDuration = System.nanoTime() - this.startNanos;
            if (serviceTimeEWMA > 0L && queueSize >= 0) {
                this.collector.addNodeStatistics(this.nodeId, queueSize, responseDuration, serviceTimeEWMA);
            }
        }
        this.listener.onResponse((Object)response);
    }

    public void onFailure(Exception e) {
        this.listener.onFailure(e);
    }
}

