/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.search;

import io.lucenia.action.search.SearchScrollAsyncAction;
import io.skylite.common.action.ActionListener;
import io.skylite.common.util.concurrent.CountDown;
import io.skylite.core.action.search.ParsedScrollId;
import io.skylite.core.action.search.SearchActionListener;
import io.skylite.core.action.search.SearchPhase;
import io.skylite.core.action.search.SearchPhaseName;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchScrollRequest;
import io.skylite.core.action.search.SearchTask;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.action.search.phase.SearchPhaseController;
import io.skylite.core.action.search.query.ScrollQuerySearchResult;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.AtomicArray;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.fetch.FetchSearchResult;
import io.skylite.core.search.fetch.ShardFetchRequest;
import io.skylite.core.search.internal.InternalScrollSearchRequest;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.transport.TransportConnection;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.ScoreDoc;

final class SearchScrollQueryThenFetchAsyncAction
extends SearchScrollAsyncAction<ScrollQuerySearchResult> {
    private final SearchTask task;
    private final AtomicArray<FetchSearchResult> fetchResults;
    private final AtomicArray<QuerySearchResult> queryResults;

    SearchScrollQueryThenFetchAsyncAction(Logger logger, ClusterService clusterService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, SearchScrollRequest request, SearchTask task, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        super(scrollId, logger, clusterService.state().nodes(), listener, searchPhaseController, request, searchTransportService);
        this.task = task;
        this.fetchResults = new AtomicArray(scrollId.getContext().length);
        this.queryResults = new AtomicArray(scrollId.getContext().length);
    }

    @Override
    protected void onFirstPhaseResult(int shardId, ScrollQuerySearchResult result) {
        this.queryResults.setOnce(shardId, (Object)result.queryResult());
    }

    @Override
    protected void executeInitialPhase(TransportConnection connection, InternalScrollSearchRequest internalRequest, SearchActionListener<ScrollQuerySearchResult> searchActionListener) {
        this.searchTransportService.sendExecuteScrollQuery(connection, internalRequest, this.task, searchActionListener);
    }

    @Override
    protected SearchPhase moveToNextPhase(final BiFunction<String, String, DiscoveryNode> clusterNodeLookup) {
        return new SearchPhase(SearchPhaseName.FETCH.getName()){

            public void run() {
                final SearchPhaseController.ReducedQueryPhase reducedQueryPhase = SearchScrollQueryThenFetchAsyncAction.this.searchPhaseController.reducedScrollQueryPhase((Collection)SearchScrollQueryThenFetchAsyncAction.this.queryResults.asList());
                ScoreDoc[] scoreDocs = reducedQueryPhase.getSortedTopDocs().getScoreDocs();
                if (scoreDocs.length == 0) {
                    SearchScrollQueryThenFetchAsyncAction.this.sendResponse(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults);
                    return;
                }
                List[] docIdsToLoad = SearchScrollQueryThenFetchAsyncAction.this.searchPhaseController.fillDocIdsToLoad(SearchScrollQueryThenFetchAsyncAction.this.queryResults.length(), scoreDocs);
                ScoreDoc[] lastEmittedDocPerShard = SearchScrollQueryThenFetchAsyncAction.this.searchPhaseController.getLastEmittedDocPerShard(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.queryResults.length());
                final CountDown counter = new CountDown(docIdsToLoad.length);
                for (int i = 0; i < docIdsToLoad.length; ++i) {
                    int index = i;
                    List docIds = docIdsToLoad[index];
                    if (docIds != null) {
                        final QuerySearchResult querySearchResult = (QuerySearchResult)SearchScrollQueryThenFetchAsyncAction.this.queryResults.get(index);
                        ScoreDoc lastEmittedDoc = lastEmittedDocPerShard[index];
                        ShardFetchRequest shardFetchRequest = new ShardFetchRequest(querySearchResult.getContextId(), (Collection)docIds, lastEmittedDoc);
                        SearchShardTarget searchShardTarget = querySearchResult.getSearchShardTarget();
                        DiscoveryNode node = (DiscoveryNode)clusterNodeLookup.apply(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                        assert (node != null) : "target node is null in secondary phase";
                        TransportConnection connection = SearchScrollQueryThenFetchAsyncAction.this.getConnection(searchShardTarget.getClusterAlias(), node);
                        SearchScrollQueryThenFetchAsyncAction.this.searchTransportService.sendExecuteFetchScroll(connection, shardFetchRequest, SearchScrollQueryThenFetchAsyncAction.this.task, (SearchActionListener)new SearchActionListener<FetchSearchResult>(querySearchResult.getSearchShardTarget(), index){

                            protected void innerOnResponse(FetchSearchResult response) {
                                SearchScrollQueryThenFetchAsyncAction.this.fetchResults.setOnce(response.getShardIndex(), (Object)response);
                                if (counter.countDown()) {
                                    SearchScrollQueryThenFetchAsyncAction.this.sendResponse(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults);
                                }
                            }

                            public void onFailure(Exception t) {
                                SearchScrollQueryThenFetchAsyncAction.this.onShardFailure(this.getName(), counter, querySearchResult.getContextId(), t, querySearchResult.getSearchShardTarget(), () -> SearchScrollQueryThenFetchAsyncAction.this.sendResponsePhase(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults));
                            }
                        });
                        continue;
                    }
                    if (!counter.countDown()) continue;
                    SearchScrollQueryThenFetchAsyncAction.this.sendResponse(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults);
                }
            }
        };
    }
}

