/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.support.broadcast;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.NoShardAvailableActionException;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportActions;
import io.skylite.core.action.support.broadcast.BroadcastRequest;
import io.skylite.core.action.support.broadcast.BroadcastResponse;
import io.skylite.core.action.support.broadcast.BroadcastShardOperationFailedException;
import io.skylite.core.action.support.broadcast.BroadcastShardRequest;
import io.skylite.core.action.support.broadcast.BroadcastShardResponse;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.FailAwareWeightedRouting;
import io.skylite.core.cluster.routing.GroupShardsIterator;
import io.skylite.core.cluster.routing.ShardIterator;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequestHandler;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

public abstract class TransportBroadcastAction<Request extends BroadcastRequest<Request>, Response extends BroadcastResponse, ShardRequest extends BroadcastShardRequest, ShardResponse extends BroadcastShardResponse>
extends HandledTransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final IndexNameExpressionResolver indexNameExpressionResolver;
    final String transportShardAction;
    private final String shardExecutor;

    protected TransportBroadcastAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Request> request, Writeable.Reader<ShardRequest> shardRequest, String shardExecutor) {
        super(actionName, transportService, actionFilters, request);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.transportShardAction = actionName + "[s]";
        this.shardExecutor = shardExecutor;
        transportService.registerRequestHandler(this.transportShardAction, "same", shardRequest, (TransportRequestHandler)new ShardTransportHandler());
    }

    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        new AsyncBroadcastAction(this, task, request, listener).start();
    }

    protected abstract Response newResponse(Request var1, AtomicReferenceArray var2, ClusterState var3);

    protected abstract ShardRequest newShardRequest(int var1, ShardRouting var2, Request var3);

    protected abstract ShardResponse readShardResponse(StreamInput var1) throws IOException;

    protected abstract ShardResponse shardOperation(ShardRequest var1, Task var2) throws IOException;

    protected abstract GroupShardsIterator<ShardIterator> shards(ClusterState var1, Request var2, String[] var3);

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2, String[] var3);

    private void asyncShardOperation(ShardRequest request, Task task, ActionListener<ShardResponse> listener) {
        this.transportService.getThreadPool().executor(this.shardExecutor).execute((Runnable)ActionRunnable.supply(listener, () -> this.shardOperation(request, task)));
    }

    class ShardTransportHandler
    implements TransportRequestHandler<ShardRequest> {
        ShardTransportHandler() {
        }

        public void messageReceived(ShardRequest request, TransportChannel channel, Task task) throws Exception {
            TransportBroadcastAction.this.asyncShardOperation(request, task, ActionListenerHelper.wrap(arg_0 -> ((TransportChannel)channel).sendResponse(arg_0), e -> {
                try {
                    channel.sendResponse(e);
                }
                catch (Exception e1) {
                    TransportBroadcastAction.this.logger.warn(() -> new ParameterizedMessage("Failed to send error response for action [{}] and request [{}]", (Object)TransportBroadcastAction.this.actionName, request), (Throwable)e1);
                }
            }));
        }
    }

    protected static class AsyncBroadcastAction {
        private final Task task;
        private final Request request;
        private final ActionListener<Response> listener;
        private final ClusterState clusterState;
        private final DiscoveryNodes nodes;
        private final GroupShardsIterator<ShardIterator> shardsIts;
        private final int expectedOps;
        private final AtomicInteger counterOps = new AtomicInteger();
        private final AtomicReferenceArray shardsResponses;
        final /* synthetic */ TransportBroadcastAction this$0;

        protected AsyncBroadcastAction(Task task, Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.clusterState = this$0.clusterService.state();
            ClusterBlockException blockException = this$0.checkGlobalBlock(this.clusterState, request);
            if (blockException != null) {
                throw blockException;
            }
            String[] concreteIndices = this$0.indexNameExpressionResolver.concreteIndexNames(this.clusterState, request);
            blockException = this$0.checkRequestBlock(this.clusterState, request, concreteIndices);
            if (blockException != null) {
                throw blockException;
            }
            this.nodes = this.clusterState.nodes();
            ((TransportBroadcastAction)this$0).logger.trace("resolving shards based on cluster state version [{}]", (Object)this.clusterState.version());
            this.shardsIts = this$0.shards(this.clusterState, request, concreteIndices);
            this.expectedOps = this.shardsIts.size();
            this.shardsResponses = new AtomicReferenceArray(this.expectedOps);
        }

        public void start() {
            if (this.shardsIts.size() == 0) {
                try {
                    this.listener.onResponse(this.this$0.newResponse(this.request, new AtomicReferenceArray(0), this.clusterState));
                }
                catch (Exception e) {
                    this.listener.onFailure(e);
                }
                return;
            }
            int shardIndex = -1;
            for (ShardIterator shardIt : this.shardsIts) {
                ++shardIndex;
                ShardRouting shard = shardIt.nextOrNull();
                if (shard != null) {
                    this.performOperation(shardIt, shard, shardIndex);
                    continue;
                }
                this.onOperation(null, shardIt, shardIndex, (Exception)new NoShardAvailableActionException(shardIt.shardId()));
            }
        }

        protected void performOperation(final ShardIterator shardIt, final ShardRouting shard, final int shardIndex) {
            if (shard == null) {
                this.onOperation(null, shardIt, shardIndex, (Exception)new NoShardAvailableActionException(shardIt.shardId()));
            } else {
                try {
                    Object shardRequest = this.this$0.newShardRequest(shardIt.size(), shard, this.request);
                    shardRequest.setParentTask(this.this$0.clusterService.localNode().getId(), this.task.getId());
                    DiscoveryNode node = this.nodes.get(shard.currentNodeId());
                    if (node == null) {
                        this.onOperation(shard, shardIt, shardIndex, (Exception)new NoShardAvailableActionException(shardIt.shardId()));
                    } else {
                        this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, shardRequest, new TransportResponseHandler<ShardResponse>(){

                            public ShardResponse read(StreamInput in) throws IOException {
                                return AsyncBroadcastAction.this.this$0.readShardResponse(in);
                            }

                            public String executor() {
                                return "same";
                            }

                            public void handleResponse(ShardResponse response) {
                                AsyncBroadcastAction.this.onOperation(shard, shardIndex, response);
                            }

                            public void handleException(TransportException e) {
                                AsyncBroadcastAction.this.onOperation(shard, shardIt, shardIndex, (Exception)e);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    this.onOperation(shard, shardIt, shardIndex, e);
                }
            }
        }

        protected void onOperation(ShardRouting shard, int shardIndex, ShardResponse response) {
            this.this$0.logger.trace("received response for {}", (Object)shard);
            this.shardsResponses.set(shardIndex, response);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim();
            }
        }

        void onOperation(@Nullable ShardRouting shard, ShardIterator shardIt, int shardIndex, Exception e) {
            this.setFailure(shardIt, shardIndex, e);
            ShardRouting nextShard = FailAwareWeightedRouting.getInstance().findNext((ShardsIterator)shardIt, this.this$0.clusterService.state(), e, () -> this.counterOps.incrementAndGet());
            if (nextShard != null) {
                if (e != null && this.this$0.logger.isTraceEnabled() && !TransportActions.isShardNotAvailableException((Throwable)e)) {
                    this.this$0.logger.trace((Message)new ParameterizedMessage("{}: failed to execute [{}]", (Object)(shard != null ? shard.shortSummary() : shardIt.shardId()), this.request), (Throwable)e);
                }
                this.performOperation(shardIt, nextShard, shardIndex);
            } else {
                if (this.this$0.logger.isDebugEnabled() && e != null && !TransportActions.isShardNotAvailableException((Throwable)e)) {
                    this.this$0.logger.debug((Message)new ParameterizedMessage("{}: failed to execute [{}]", (Object)(shard != null ? shard.shortSummary() : shardIt.shardId()), this.request), (Throwable)e);
                }
                if (this.expectedOps == this.counterOps.incrementAndGet()) {
                    this.finishHim();
                }
            }
        }

        protected void finishHim() {
            try {
                this.listener.onResponse(this.this$0.newResponse(this.request, this.shardsResponses, this.clusterState));
            }
            catch (Exception e) {
                this.listener.onFailure(e);
            }
        }

        void setFailure(ShardIterator shardIt, int shardIndex, Exception e) {
            Object response;
            if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                return;
            }
            if (!(e instanceof BroadcastShardOperationFailedException)) {
                e = new BroadcastShardOperationFailedException(shardIt.shardId(), (Throwable)e);
            }
            if ((response = this.shardsResponses.get(shardIndex)) == null) {
                this.shardsResponses.set(shardIndex, e);
            }
            if (!(response instanceof Throwable)) {
                return;
            }
            if (TransportActions.isReadOverrideException((Exception)e)) {
                this.shardsResponses.set(shardIndex, e);
            }
        }
    }
}

