/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.support.replication;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.util.concurrent.CountDown;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportActions;
import io.skylite.core.action.support.broadcast.BroadcastRequest;
import io.skylite.core.action.support.broadcast.BroadcastResponse;
import io.skylite.core.action.support.broadcast.BroadcastShardOperationFailedException;
import io.skylite.core.action.support.replication.ReplicationRequest;
import io.skylite.core.action.support.replication.TransportReplicationAction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.IndexRoutingTable;
import io.skylite.core.cluster.routing.IndexShardRoutingTable;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class TransportBroadcastReplicationAction<Request extends BroadcastRequest<Request>, Response extends BroadcastResponse, ShardRequest extends ReplicationRequest<ShardRequest>, ShardResponse extends ReplicationResponse>
extends HandledTransportAction<Request, Response> {
    private final TransportReplicationAction replicatedBroadcastShardAction;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public TransportBroadcastReplicationAction(String name, Writeable.Reader<Request> requestReader, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TransportReplicationAction replicatedBroadcastShardAction) {
        super(name, transportService, actionFilters, requestReader);
        this.replicatedBroadcastShardAction = replicatedBroadcastShardAction;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected void doExecute(Task task, Request request, final ActionListener<Response> listener) {
        final ClusterState clusterState = this.clusterService.state();
        List<ShardId> shards = this.shards(request, clusterState);
        final CopyOnWriteArrayList shardsResponses = new CopyOnWriteArrayList();
        if (shards.size() == 0) {
            this.finishAndNotifyListener(listener, shardsResponses);
        }
        final CountDown responsesCountDown = new CountDown(shards.size());
        for (final ShardId shardId : shards) {
            ActionListener shardActionListener = new ActionListener<ShardResponse>(){

                public void onResponse(ShardResponse shardResponse) {
                    shardsResponses.add(shardResponse);
                    TransportBroadcastReplicationAction.this.logger.trace("{}: got response from {}", (Object)TransportBroadcastReplicationAction.this.actionName, (Object)shardId);
                    if (responsesCountDown.countDown()) {
                        TransportBroadcastReplicationAction.this.finishAndNotifyListener(listener, shardsResponses);
                    }
                }

                public void onFailure(Exception e) {
                    Object[] failures;
                    TransportBroadcastReplicationAction.this.logger.trace("{}: got failure from {}", (Object)TransportBroadcastReplicationAction.this.actionName, (Object)shardId);
                    int totalNumCopies = clusterState.getMetadata().getIndexSafe(shardId.getIndex()).getNumberOfReplicas() + 1;
                    Object shardResponse = TransportBroadcastReplicationAction.this.newShardResponse();
                    if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                        failures = new ReplicationResponse.ShardInfo.Failure[]{};
                    } else {
                        ReplicationResponse.ShardInfo.Failure failure = new ReplicationResponse.ShardInfo.Failure(shardId, null, e, SkyliteExceptionsHelper.status((Throwable)e), true);
                        failures = new ReplicationResponse.ShardInfo.Failure[totalNumCopies];
                        Arrays.fill(failures, failure);
                    }
                    shardResponse.setShardInfo(new ReplicationResponse.ShardInfo(totalNumCopies, 0, (ReplicationResponse.ShardInfo.Failure[])failures));
                    shardsResponses.add(shardResponse);
                    if (responsesCountDown.countDown()) {
                        TransportBroadcastReplicationAction.this.finishAndNotifyListener(listener, shardsResponses);
                    }
                }
            };
            this.shardExecute(task, request, shardId, shardActionListener);
        }
    }

    protected void shardExecute(Task task, Request request, ShardId shardId, ActionListener<ShardResponse> shardActionListener) {
        ShardRequest shardRequest = this.newShardRequest(request, shardId);
        shardRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.replicatedBroadcastShardAction.execute(shardRequest, shardActionListener);
    }

    protected List<ShardId> shards(Request request, ClusterState clusterState) {
        String[] concreteIndices;
        ArrayList<ShardId> shardIds = new ArrayList<ShardId>();
        for (String index : concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, request)) {
            IndexMetadata indexMetadata = (IndexMetadata)clusterState.metadata().getIndices().get(index);
            if (indexMetadata == null) continue;
            for (IndexShardRoutingTable shardRouting : ((IndexRoutingTable)clusterState.getRoutingTable().indicesRouting().get(index)).getShards().values()) {
                shardIds.add(shardRouting.shardId());
            }
        }
        return shardIds;
    }

    protected abstract ShardResponse newShardResponse();

    protected abstract ShardRequest newShardRequest(Request var1, ShardId var2);

    private void finishAndNotifyListener(ActionListener listener, CopyOnWriteArrayList<ShardResponse> shardsResponses) {
        this.logger.trace("{}: got all shard responses", (Object)this.actionName);
        int successfulShards = 0;
        int failedShards = 0;
        int totalNumCopies = 0;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        for (int i = 0; i < shardsResponses.size(); ++i) {
            ReplicationResponse shardResponse = (ReplicationResponse)shardsResponses.get(i);
            if (shardResponse == null) continue;
            failedShards += shardResponse.getShardInfo().getFailed();
            successfulShards += shardResponse.getShardInfo().getSuccessful();
            totalNumCopies += shardResponse.getShardInfo().getTotal();
            if (shardFailures == null) {
                shardFailures = new ArrayList<DefaultShardOperationFailedException>();
            }
            for (ReplicationResponse.ShardInfo.Failure failure : shardResponse.getShardInfo().getFailures()) {
                shardFailures.add(new DefaultShardOperationFailedException((SkyliteException)new BroadcastShardOperationFailedException(failure.fullShardId(), failure.getCause())));
            }
        }
        listener.onResponse((Object)this.newResponse(successfulShards, failedShards, totalNumCopies, shardFailures));
    }

    protected abstract BroadcastResponse newResponse(int var1, int var2, int var3, List<DefaultShardOperationFailedException> var4);
}

