/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.support.single.instance;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.UnavailableShardsException;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.single.instance.InstanceShardOperationRequest;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.ShardIterator;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateObserver;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.node.NodeClosedException;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.ConnectTransportException;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequestHandler;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;

public abstract class TransportInstanceSingleOperationAction<Request extends InstanceShardOperationRequest<Request>, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    protected final ThreadPool threadPool;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final IndexNameExpressionResolver indexNameExpressionResolver;
    final String shardActionName;

    protected TransportInstanceSingleOperationAction(String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Request> request) {
        super(actionName, transportService, actionFilters, request);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.shardActionName = actionName + "[s]";
        transportService.registerRequestHandler(this.shardActionName, "same", request, (TransportRequestHandler)new ShardTransportHandler());
    }

    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, request, listener).start();
    }

    protected abstract String executor(ShardId var1);

    protected abstract void shardOperation(Request var1, ActionListener<Response> var2);

    protected abstract Response newResponse(StreamInput var1) throws IOException;

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, Request request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.concreteIndex());
    }

    protected abstract void resolveRequest(ClusterState var1, Request var2);

    protected boolean retryOnFailure(Exception e) {
        return false;
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    protected abstract ShardIterator shards(ClusterState var1, Request var2);

    private class ShardTransportHandler
    implements TransportRequestHandler<Request> {
        private ShardTransportHandler() {
        }

        public void messageReceived(Request request, final TransportChannel channel, Task task) throws Exception {
            TransportInstanceSingleOperationAction.this.threadPool.executor(TransportInstanceSingleOperationAction.this.executor(request.shardId())).execute((Runnable)new AbstractRunnable((InstanceShardOperationRequest)request){
                final /* synthetic */ InstanceShardOperationRequest val$request;
                {
                    this.val$request = instanceShardOperationRequest;
                }

                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        TransportInstanceSingleOperationAction.this.logger.warn("failed to send response for " + TransportInstanceSingleOperationAction.this.shardActionName, (Throwable)inner);
                    }
                }

                public void doRun() {
                    TransportInstanceSingleOperationAction.this.shardOperation(this.val$request, ActionListenerHelper.wrap(arg_0 -> ((TransportChannel)channel).sendResponse(arg_0), this::onFailure));
                }
            });
        }
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final Request request;
        private volatile ClusterStateObserver observer;
        private ShardIterator shardIt;
        final /* synthetic */ TransportInstanceSingleOperationAction this$0;

        AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.request = request;
            this.listener = listener;
        }

        public void start() {
            ClusterState state = this.this$0.clusterService.state();
            this.observer = new ClusterStateObserver(state, this.this$0.clusterService, this.request.timeout(), this.this$0.logger, this.this$0.threadPool.getThreadContext());
            this.doStart(state);
        }

        protected void doStart(ClusterState clusterState) {
            try {
                ClusterBlockException blockException = this.this$0.checkGlobalBlock(clusterState);
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.retry((Exception)blockException);
                        return;
                    }
                    throw blockException;
                }
                try {
                    this.request.concreteIndex(this.this$0.indexNameExpressionResolver.concreteWriteIndex(clusterState, this.request).getName());
                }
                catch (IndexNotFoundException e) {
                    if (!this.request.includeDataStreams() && e.getMetadataKeys().contains("skylite.excluded_ds")) {
                        throw new IllegalArgumentException("only write ops with an op_type of create are allowed in data streams");
                    }
                    throw e;
                }
                this.this$0.resolveRequest(clusterState, this.request);
                blockException = this.this$0.checkRequestBlock(clusterState, this.request);
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.retry((Exception)blockException);
                        return;
                    }
                    throw blockException;
                }
                this.shardIt = this.this$0.shards(clusterState, this.request);
            }
            catch (Exception e) {
                this.listener.onFailure(e);
                return;
            }
            if (this.shardIt.size() == 0) {
                this.retry(null);
                return;
            }
            assert (this.shardIt.size() == 1);
            ShardRouting shard = this.shardIt.nextOrNull();
            assert (shard != null);
            if (!shard.active()) {
                this.retry(null);
                return;
            }
            this.request.setShardId(this.shardIt.shardId());
            DiscoveryNode node = clusterState.nodes().get(shard.currentNodeId());
            this.this$0.transportService.sendRequest(node, this.this$0.shardActionName, this.request, this.this$0.transportOptions(), new TransportResponseHandler<Response>(){

                public Response read(StreamInput in) throws IOException {
                    return AsyncSingleAction.this.this$0.newResponse(in);
                }

                public String executor() {
                    return "same";
                }

                public void handleResponse(Response response) {
                    AsyncSingleAction.this.listener.onResponse(response);
                }

                public void handleException(TransportException exp) {
                    Throwable cause = exp.unwrapCause();
                    if (cause instanceof ConnectTransportException || cause instanceof NodeClosedException || AsyncSingleAction.this.this$0.retryOnFailure((Exception)exp)) {
                        AsyncSingleAction.this.retry((Exception)cause);
                    } else {
                        AsyncSingleAction.this.listener.onFailure((Exception)exp);
                    }
                }
            });
        }

        void retry(@Nullable Exception failure) {
            if (this.observer.isTimedOut()) {
                Exception listenFailure = failure;
                if (listenFailure == null) {
                    listenFailure = this.shardIt == null ? new UnavailableShardsException(this.request.concreteIndex(), -1, "Timeout waiting for [{}], request: {}", new Object[]{this.request.timeout(), this.this$0.actionName}) : new UnavailableShardsException(this.shardIt.shardId(), "[{}] shardIt, [{}] active : Timeout waiting for [{}], request: {}", new Object[]{this.shardIt.size(), this.shardIt.sizeActive(), this.request.timeout(), this.this$0.actionName});
                }
                this.listener.onFailure(listenFailure);
                return;
            }
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState state) {
                    AsyncSingleAction.this.doStart(state);
                }

                public void onClusterServiceClose() {
                    AsyncSingleAction.this.listener.onFailure((Exception)new NodeClosedException(AsyncSingleAction.this.this$0.clusterService.localNode()));
                }

                public void onTimeout(TimeValue timeout) {
                    AsyncSingleAction.this.doStart(AsyncSingleAction.this.observer.setAndGetObservedState());
                }
            }, this.request.timeout());
        }
    }
}

