/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.support.tasks;

import io.skylite.ResourceNotFoundException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.NoSuchNodeException;
import io.skylite.core.action.TaskOperationFailure;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.tasks.BaseTasksRequest;
import io.skylite.core.action.support.tasks.BaseTasksResponse;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.concurrent.AtomicArray;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.NodeShouldNotConnectException;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestHandler;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

public abstract class TransportTasksAction<OperationTask extends Task, TasksRequest extends BaseTasksRequest<TasksRequest>, TasksResponse extends BaseTasksResponse, TaskResponse extends Writeable>
extends HandledTransportAction<TasksRequest, TasksResponse> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final Writeable.Reader<TasksRequest> requestReader;
    protected final Writeable.Reader<TasksResponse> responsesReader;
    protected final Writeable.Reader<TaskResponse> responseReader;
    protected final String transportNodeAction;

    protected TransportTasksAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<TasksRequest> requestReader, Writeable.Reader<TasksResponse> responsesReader, Writeable.Reader<TaskResponse> responseReader, String nodeExecutor) {
        super(actionName, transportService, actionFilters, requestReader);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportNodeAction = actionName + "[n]";
        this.requestReader = requestReader;
        this.responsesReader = responsesReader;
        this.responseReader = responseReader;
        transportService.registerRequestHandler(this.transportNodeAction, nodeExecutor, x$0 -> new NodeTaskRequest(this, x$0), (TransportRequestHandler)new NodeTransportHandler());
    }

    protected void doExecute(Task task, TasksRequest request, ActionListener<TasksResponse> listener) {
        new AsyncAction(this, task, request, listener).start();
    }

    private void nodeOperation(NodeTaskRequest nodeTaskRequest, final ActionListener<NodeTasksResponse> listener) {
        Object request = nodeTaskRequest.tasksRequest;
        final ArrayList tasks = new ArrayList();
        this.processTasks(request, tasks::add);
        if (tasks.isEmpty()) {
            listener.onResponse((Object)new NodeTasksResponse(this, this.clusterService.localNode().getId(), Collections.emptyList(), Collections.emptyList()));
            return;
        }
        final AtomicArray responses = new AtomicArray(tasks.size());
        final AtomicInteger counter = new AtomicInteger(tasks.size());
        for (int i = 0; i < tasks.size(); ++i) {
            final int taskIndex = i;
            ActionListener taskListener = new ActionListener<TaskResponse>(){

                public void onResponse(TaskResponse response) {
                    responses.setOnce(taskIndex, (Object)(response == null ? null : new Tuple(response, null)));
                    this.respondIfFinished();
                }

                public void onFailure(Exception e) {
                    responses.setOnce(taskIndex, (Object)new Tuple(null, (Object)e));
                    this.respondIfFinished();
                }

                private void respondIfFinished() {
                    if (counter.decrementAndGet() != 0) {
                        return;
                    }
                    ArrayList<Writeable> results = new ArrayList<Writeable>();
                    ArrayList<TaskOperationFailure> exceptions = new ArrayList<TaskOperationFailure>();
                    for (Tuple response : responses.asList()) {
                        if (response.v1() == null) {
                            assert (response.v2() != null);
                            exceptions.add(new TaskOperationFailure(TransportTasksAction.this.clusterService.localNode().getId(), ((Task)tasks.get(taskIndex)).getId(), (Exception)response.v2()));
                            continue;
                        }
                        assert (response.v2() == null);
                        results.add((Writeable)response.v1());
                    }
                    listener.onResponse((Object)new NodeTasksResponse(TransportTasksAction.this, TransportTasksAction.this.clusterService.localNode().getId(), results, exceptions));
                }
            };
            try {
                this.taskOperation(request, (Task)tasks.get(taskIndex), taskListener);
                continue;
            }
            catch (Exception e) {
                taskListener.onFailure(e);
            }
        }
    }

    protected String[] filterNodeIds(DiscoveryNodes nodes, String[] nodesIds) {
        return nodesIds;
    }

    protected String[] resolveNodes(TasksRequest request, ClusterState clusterState) {
        if (request.getTaskId().isSet()) {
            return new String[]{request.getTaskId().getNodeId()};
        }
        return clusterState.nodes().resolveNodes(request.getNodes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processTasks(TasksRequest request, Consumer<OperationTask> operation) {
        if (request.getTaskId().isSet()) {
            Task task = this.taskManager.getTask(request.getTaskId().getId());
            if (task == null) throw new ResourceNotFoundException("task [{}] is missing", new Object[]{request.getTaskId()});
            if (!request.match(task)) throw new ResourceNotFoundException("task [{}] doesn't support this operation", new Object[]{request.getTaskId()});
            operation.accept(task);
            return;
        } else {
            for (Task task : this.taskManager.getTasks().values()) {
                if (!request.match(task)) continue;
                operation.accept(task);
            }
        }
    }

    protected abstract TasksResponse newResponse(TasksRequest var1, List<TaskResponse> var2, List<TaskOperationFailure> var3, List<FailedNodeException> var4);

    protected TasksResponse newResponse(TasksRequest request, AtomicReferenceArray responses) {
        ArrayList tasks = new ArrayList();
        ArrayList<FailedNodeException> failedNodeExceptions = new ArrayList<FailedNodeException>();
        ArrayList<TaskOperationFailure> taskOperationFailures = new ArrayList<TaskOperationFailure>();
        for (int i = 0; i < responses.length(); ++i) {
            Object response = responses.get(i);
            if (response instanceof FailedNodeException) {
                failedNodeExceptions.add((FailedNodeException)response);
                continue;
            }
            NodeTasksResponse tasksResponse = (NodeTasksResponse)((Object)response);
            if (tasksResponse.results != null) {
                tasks.addAll(tasksResponse.results);
            }
            if (tasksResponse.exceptions == null) continue;
            taskOperationFailures.addAll(tasksResponse.exceptions);
        }
        return this.newResponse(request, tasks, taskOperationFailures, failedNodeExceptions);
    }

    protected abstract void taskOperation(TasksRequest var1, OperationTask var2, ActionListener<TaskResponse> var3);

    class NodeTransportHandler
    implements TransportRequestHandler<NodeTaskRequest> {
        NodeTransportHandler() {
        }

        public void messageReceived(NodeTaskRequest request, TransportChannel channel, Task task) throws Exception {
            TransportTasksAction.this.nodeOperation(request, (ActionListener<NodeTasksResponse>)ActionListenerHelper.wrap(arg_0 -> ((TransportChannel)channel).sendResponse(arg_0), e -> {
                try {
                    channel.sendResponse(e);
                }
                catch (IOException e1) {
                    e1.addSuppressed((Throwable)e);
                    TransportTasksAction.this.logger.warn("Failed to send failure", (Throwable)e1);
                }
            }));
        }
    }

    private static class AsyncAction {
        private final TasksRequest request;
        private final String[] nodesIds;
        private final DiscoveryNode[] nodes;
        private final ActionListener<TasksResponse> listener;
        private final AtomicReferenceArray<Object> responses;
        private final AtomicInteger counter = new AtomicInteger();
        private final Task task;
        final /* synthetic */ TransportTasksAction this$0;

        private AsyncAction(Task task, TasksRequest request, ActionListener<TasksResponse> listener) {
            this.this$0 = var1_1;
            this.task = task;
            this.request = request;
            this.listener = listener;
            ClusterState clusterState = var1_1.clusterService.state();
            String[] nodesIds = var1_1.resolveNodes(request, clusterState);
            this.nodesIds = var1_1.filterNodeIds(clusterState.nodes(), nodesIds);
            Map nodes = clusterState.nodes().getNodes();
            this.nodes = new DiscoveryNode[nodesIds.length];
            for (int i = 0; i < this.nodesIds.length; ++i) {
                this.nodes[i] = (DiscoveryNode)nodes.get(this.nodesIds[i]);
            }
            this.responses = new AtomicReferenceArray(this.nodesIds.length);
        }

        private void start() {
            if (this.nodesIds.length == 0) {
                try {
                    this.listener.onResponse(this.this$0.newResponse(this.request, this.responses));
                }
                catch (Exception e) {
                    this.this$0.logger.debug("failed to generate empty response", (Throwable)e);
                    this.listener.onFailure(e);
                }
            } else {
                TransportRequestOptions.Builder builder = TransportRequestOptions.builder();
                if (this.request.getTimeout() != null) {
                    builder.withTimeout(this.request.getTimeout());
                }
                for (int i = 0; i < this.nodesIds.length; ++i) {
                    String nodeId = this.nodesIds[i];
                    final int idx = i;
                    final DiscoveryNode node = this.nodes[i];
                    try {
                        if (node == null) {
                            this.onFailure(idx, nodeId, (Throwable)new NoSuchNodeException(nodeId));
                            continue;
                        }
                        NodeTaskRequest nodeRequest = new NodeTaskRequest(this.this$0, this.request);
                        nodeRequest.setParentTask(this.this$0.clusterService.localNode().getId(), this.task.getId());
                        this.this$0.transportService.sendRequest(node, this.this$0.transportNodeAction, (TransportRequest)nodeRequest, builder.build(), (TransportResponseHandler)new TransportResponseHandler<NodeTasksResponse>(){

                            public NodeTasksResponse read(StreamInput in) throws IOException {
                                return new NodeTasksResponse(AsyncAction.this.this$0, in);
                            }

                            public void handleResponse(NodeTasksResponse response) {
                                AsyncAction.this.onOperation(idx, response);
                            }

                            public void handleException(TransportException exp) {
                                AsyncAction.this.onFailure(idx, node.getId(), (Throwable)exp);
                            }

                            public String executor() {
                                return "same";
                            }
                        });
                        continue;
                    }
                    catch (Exception e) {
                        this.onFailure(idx, nodeId, e);
                    }
                }
            }
        }

        private void onOperation(int idx, NodeTasksResponse nodeResponse) {
            this.responses.set(idx, (Object)nodeResponse);
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void onFailure(int idx, String nodeId, Throwable t) {
            if (this.this$0.logger.isDebugEnabled() && !(t instanceof NodeShouldNotConnectException)) {
                this.this$0.logger.debug((Message)new ParameterizedMessage("failed to execute on node [{}]", (Object)nodeId), t);
            }
            this.responses.set(idx, new FailedNodeException(nodeId, "Failed node [" + nodeId + "]", t));
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void finishHim() {
            Object finalResponse;
            try {
                finalResponse = this.this$0.newResponse(this.request, this.responses);
            }
            catch (Exception e) {
                this.this$0.logger.debug("failed to combine responses from nodes", (Throwable)e);
                this.listener.onFailure(e);
                return;
            }
            this.listener.onResponse(finalResponse);
        }
    }

    private class NodeTaskRequest
    extends TransportRequest {
        private TasksRequest tasksRequest;

        protected NodeTaskRequest(TransportTasksAction transportTasksAction, StreamInput in) throws IOException {
            super(in);
            this.tasksRequest = (BaseTasksRequest)transportTasksAction.requestReader.read(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.tasksRequest.writeTo(out);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        protected NodeTaskRequest(TasksRequest tasksRequest) {
            this.tasksRequest = tasksRequest;
        }
    }

    private class NodeTasksResponse
    extends TransportResponse {
        protected String nodeId;
        protected List<TaskOperationFailure> exceptions;
        protected List<TaskResponse> results;

        NodeTasksResponse(TransportTasksAction transportTasksAction, StreamInput in) throws IOException {
            super(in);
            int resultsSize;
            this.nodeId = in.readString();
            this.results = new ArrayList(resultsSize);
            for (resultsSize = in.readVInt(); resultsSize > 0; --resultsSize) {
                Writeable result = in.readBoolean() ? (Writeable)transportTasksAction.responseReader.read(in) : null;
                this.results.add(result);
            }
            if (in.readBoolean()) {
                int taskFailures = in.readVInt();
                this.exceptions = new ArrayList<TaskOperationFailure>(taskFailures);
                for (int i = 0; i < taskFailures; ++i) {
                    this.exceptions.add(new TaskOperationFailure(in));
                }
            } else {
                this.exceptions = null;
            }
        }

        NodeTasksResponse(TransportTasksAction transportTasksAction, String nodeId, List<TaskResponse> results, List<TaskOperationFailure> exceptions) {
            this.nodeId = nodeId;
            this.results = results;
            this.exceptions = exceptions;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public List<TaskOperationFailure> getExceptions() {
            return this.exceptions;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeVInt(this.results.size());
            for (Writeable result : this.results) {
                if (result != null) {
                    out.writeBoolean(true);
                    result.writeTo(out);
                    continue;
                }
                out.writeBoolean(false);
            }
            out.writeBoolean(this.exceptions != null);
            if (this.exceptions != null) {
                int taskFailures = this.exceptions.size();
                out.writeVInt(taskFailures);
                for (TaskOperationFailure exception : this.exceptions) {
                    exception.writeTo(out);
                }
            }
        }
    }
}

