/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.termvectors;

import io.lucenia.action.termvectors.TransportMultiTermVectorsAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.TransportActions;
import io.skylite.core.action.support.single.shard.SingleShardRequest;
import io.skylite.core.action.support.single.shard.TransportSingleShardAction;
import io.skylite.core.action.termvectors.MultiTermVectorsAction;
import io.skylite.core.action.termvectors.MultiTermVectorsResponse;
import io.skylite.core.action.termvectors.MultiTermVectorsShardRequest;
import io.skylite.core.action.termvectors.MultiTermVectorsShardResponse;
import io.skylite.core.action.termvectors.TermVectorsRequest;
import io.skylite.core.action.termvectors.TermVectorsResponse;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.termvectors.TermVectorsService;
import org.opensearch.indices.IndicesService;

public class TransportShardMultiTermsVectorAction
extends TransportSingleShardAction<MultiTermVectorsShardRequest, MultiTermVectorsShardResponse> {
    private final IndicesService indicesService;
    private static final String ACTION_NAME = "indices:data/read/mtv[shard]";

    @Inject
    public TransportShardMultiTermsVectorAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, MultiTermVectorsShardRequest::new, "get");
        this.indicesService = indicesService;
    }

    protected boolean isSubAction() {
        return true;
    }

    protected Writeable.Reader<MultiTermVectorsShardResponse> getResponseReader() {
        return MultiTermVectorsShardResponse::new;
    }

    protected boolean resolveIndex(MultiTermVectorsShardRequest request) {
        return false;
    }

    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(state, request.concreteIndex(), ((MultiTermVectorsShardRequest)request.request()).shardId(), ((MultiTermVectorsShardRequest)request.request()).preference());
    }

    protected MultiTermVectorsShardResponse shardOperation(MultiTermVectorsShardRequest request, ShardId shardId) {
        MultiTermVectorsShardResponse response = new MultiTermVectorsShardResponse();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        for (int i = 0; i < request.getLocations().size(); ++i) {
            TermVectorsRequest termVectorsRequest = (TermVectorsRequest)request.getRequests().get(i);
            try {
                TermVectorsResponse termVectorsResponse = TermVectorsService.getTermVectors(indexShard, termVectorsRequest);
                response.add(((Integer)request.getLocations().get(i)).intValue(), termVectorsResponse);
                continue;
            }
            catch (RuntimeException e) {
                if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                    throw e;
                }
                this.logger.debug(() -> new ParameterizedMessage("{} failed to execute multi term vectors for [{}]", (Object)shardId, (Object)termVectorsRequest.id()), (Throwable)e);
                response.add(((Integer)request.getLocations().get(i)).intValue(), new MultiTermVectorsResponse.Failure(request.index(), termVectorsRequest.id(), (Exception)e));
            }
        }
        return response;
    }

    protected String getExecutor(MultiTermVectorsShardRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? "search_throttled" : super.getExecutor((SingleShardRequest)request, shardId);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return MultiTermVectorsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportMultiTermVectorsAction.class;
        }

        public Class<?>[] getSupportTransportActions() {
            return new Class[]{TransportShardMultiTermsVectorAction.class};
        }
    }
}

