/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.termvectors;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.RoutingMissingException;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.single.shard.SingleShardRequest;
import io.skylite.core.action.support.single.shard.TransportSingleShardAction;
import io.skylite.core.action.termvectors.TermVectorsAction;
import io.skylite.core.action.termvectors.TermVectorsRequest;
import io.skylite.core.action.termvectors.TermVectorsResponse;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.GroupShardsIterator;
import io.skylite.core.cluster.routing.Preference;
import io.skylite.core.cluster.routing.ShardIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.termvectors.TermVectorsService;
import org.opensearch.indices.IndicesService;

public class TransportTermVectorsAction
extends TransportSingleShardAction<TermVectorsRequest, TermVectorsResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportTermVectorsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/tv", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, TermVectorsRequest::new, "get");
        this.indicesService = indicesService;
    }

    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        String preference = ((TermVectorsRequest)request.request()).preference();
        if (((TermVectorsRequest)request.request()).realtime() && preference == null && state.getMetadata().isSegmentReplicationEnabled(request.concreteIndex())) {
            preference = Preference.PRIMARY.type();
        }
        if (((TermVectorsRequest)request.request()).doc() != null && ((TermVectorsRequest)request.request()).routing() == null) {
            GroupShardsIterator groupShardsIter = this.clusterService.operationRouting().searchShards(state, new String[]{request.concreteIndex()}, null, preference);
            return (ShardIterator)groupShardsIter.iterator().next();
        }
        return this.clusterService.operationRouting().getShards(state, request.concreteIndex(), ((TermVectorsRequest)request.request()).id(), ((TermVectorsRequest)request.request()).routing(), preference);
    }

    protected boolean resolveIndex(TermVectorsRequest request) {
        return true;
    }

    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ((TermVectorsRequest)request.request()).routing(state.metadata().resolveIndexRouting(((TermVectorsRequest)request.request()).routing(), ((TermVectorsRequest)request.request()).index()));
        if (((TermVectorsRequest)request.request()).routing() == null && state.getMetadata().routingRequired(request.concreteIndex())) {
            throw new RoutingMissingException(request.concreteIndex(), ((TermVectorsRequest)request.request()).id());
        }
    }

    protected void asyncShardOperation(TermVectorsRequest request, ShardId shardId, ActionListener<TermVectorsResponse> listener) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.realtime()) {
            super.asyncShardOperation((SingleShardRequest)request, shardId, listener);
        } else {
            indexShard.awaitShardSearchActive(b -> {
                try {
                    super.asyncShardOperation((SingleShardRequest)request, shardId, listener);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
    }

    protected TermVectorsResponse shardOperation(TermVectorsRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        return TermVectorsService.getTermVectors(indexShard, request);
    }

    protected Writeable.Reader<TermVectorsResponse> getResponseReader() {
        return TermVectorsResponse::new;
    }

    protected String getExecutor(TermVectorsRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? "search_throttled" : super.getExecutor((SingleShardRequest)request, shardId);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return TermVectorsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportTermVectorsAction.class;
        }
    }
}

