/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.update;

import io.lucenia.action.support.AutoCreateIndex;
import io.lucenia.action.support.single.instance.TransportInstanceSingleOperationAction;
import io.lucenia.action.update.UpdateHelper;
import io.skylite.ResourceAlreadyExistsException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.collect.Tuple;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.RoutingMissingException;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexResponse;
import io.skylite.core.action.bulk.TransportSingleItemBulkWriteAction;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.TransportActions;
import io.skylite.core.action.support.replication.ReplicatedWriteRequest;
import io.skylite.core.action.update.UpdateAction;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.routing.PlainShardIterator;
import io.skylite.core.cluster.routing.ShardIterator;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.NotSerializableExceptionWrapper;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.index.shard.IndexingStats;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class TransportUpdateAction
extends TransportInstanceSingleOperationAction<UpdateRequest, UpdateResponse> {
    private final AutoCreateIndex autoCreateIndex;
    private final UpdateHelper updateHelper;
    private final IndicesService indicesService;
    private final NodeClient client;
    private final ClusterService clusterService;

    @Inject
    public TransportUpdateAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, UpdateHelper updateHelper, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, AutoCreateIndex autoCreateIndex, NodeClient client) {
        super("indices:data/write/update", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, UpdateRequest::new);
        this.updateHelper = updateHelper;
        this.indicesService = indicesService;
        this.autoCreateIndex = autoCreateIndex;
        this.client = client;
        this.clusterService = clusterService;
    }

    @Override
    protected String executor(ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().getIndexMetadata().isSystem() ? "system_write" : "write";
    }

    @Override
    protected UpdateResponse newResponse(StreamInput in) throws IOException {
        return new UpdateResponse(in);
    }

    @Override
    protected boolean retryOnFailure(Exception e) {
        return TransportActions.isShardNotAvailableException((Throwable)e);
    }

    @Override
    protected void resolveRequest(ClusterState state, UpdateRequest request) {
        TransportUpdateAction.resolveAndValidateRouting(state.metadata(), request.concreteIndex(), request);
    }

    public static void resolveAndValidateRouting(Metadata metadata, String concreteIndex, UpdateRequest request) {
        request.routing(metadata.resolveWriteIndexRouting(request.routing(), request.index()));
        if (request.routing() == null && metadata.routingRequired(concreteIndex)) {
            throw new RoutingMissingException(concreteIndex, request.id());
        }
    }

    @Override
    protected void doExecute(final Task task, final UpdateRequest request, final ActionListener<UpdateResponse> listener) {
        if (request.isRequireAlias() && !this.clusterService.state().getMetadata().hasAlias(request.index())) {
            IndexNotFoundException e = new IndexNotFoundException("[require_alias] request flag is [true] and [" + request.index() + "] is not an alias", request.index());
            this.incDocStatusStats((Exception)((Object)e));
            throw e;
        }
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), this.clusterService.state())) {
            this.client.admin().indices().create((CreateIndexRequest)new CreateIndexRequest().index(request.index()).cause("auto(update api)").clusterManagerNodeTimeout(request.timeout()), (ActionListener)new ActionListener<CreateIndexResponse>(){

                public void onResponse(CreateIndexResponse result) {
                    TransportUpdateAction.this.innerExecute(task, request, (ActionListener<UpdateResponse>)listener);
                }

                public void onFailure(Exception e) {
                    if (SkyliteExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                        try {
                            TransportUpdateAction.this.innerExecute(task, request, (ActionListener<UpdateResponse>)listener);
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            listener.onFailure(inner);
                        }
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(task, request, listener);
        }
    }

    private void innerExecute(Task task, UpdateRequest request, ActionListener<UpdateResponse> listener) {
        super.doExecute(task, request, ActionListenerHelper.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
            this.incDocStatusStats((Exception)e);
            listener.onFailure(e);
        }));
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, UpdateRequest request) {
        ShardRouting shard;
        if (request.getShardId() != null) {
            return clusterState.routingTable().index(request.concreteIndex()).shard(request.getShardId().getId()).primaryShardIt();
        }
        ShardIterator shardIterator = this.clusterService.operationRouting().indexShards(clusterState, request.concreteIndex(), request.id(), request.routing());
        while ((shard = shardIterator.nextOrNull()) != null) {
            if (!shard.primary()) continue;
            return new PlainShardIterator(shardIterator.shardId(), Collections.singletonList(shard));
        }
        return new PlainShardIterator(shardIterator.shardId(), Collections.emptyList());
    }

    @Override
    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        this.shardOperation(request, listener, 0);
    }

    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener, int retryCount) {
        ShardId shardId = request.getShardId();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.getId());
        UpdateHelper.Result result = this.updateHelper.prepare(request, indexShard, () -> ((ThreadPool)this.threadPool).absoluteTimeInMillis());
        switch (result.getResponseResult()) {
            case CREATED: {
                IndexRequest upsertRequest = (IndexRequest)result.action();
                BytesReference upsertSourceBytes = upsertRequest.source();
                this.client.bulk(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest((ReplicatedWriteRequest)upsertRequest), TransportSingleItemBulkWriteAction.wrapBulkResponse((ActionListener)ActionListenerHelper.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    if (request.fetchSource() != null && request.fetchSource().fetchSource()) {
                        Tuple sourceAndContent = XContentHelper.convertToMap((BytesReference)upsertSourceBytes, (boolean)true, (MediaType)upsertRequest.getContentType());
                        update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), (Map)sourceAndContent.v2(), (MediaType)sourceAndContent.v1(), upsertSourceBytes));
                    } else {
                        update.setGetResult(null);
                    }
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse((Object)update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case UPDATED: {
                IndexRequest indexRequest = (IndexRequest)result.action();
                BytesReference indexSourceBytes = indexRequest.source();
                this.client.bulk(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest((ReplicatedWriteRequest)indexRequest), TransportSingleItemBulkWriteAction.wrapBulkResponse((ActionListener)ActionListenerHelper.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), indexSourceBytes));
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse((Object)update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case DELETED: {
                DeleteRequest deleteRequest = (DeleteRequest)result.action();
                this.client.bulk(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest((ReplicatedWriteRequest)deleteRequest), TransportSingleItemBulkWriteAction.wrapBulkResponse((ActionListener)ActionListenerHelper.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), null));
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse((Object)update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case NOOP: {
                IndexShard shard;
                UpdateResponse update = (UpdateResponse)result.action();
                IndexService indexServiceOrNull = this.indicesService.indexService(shardId.getIndex());
                if (indexServiceOrNull != null && (shard = indexService.getShardOrNull(shardId.getId())) != null) {
                    shard.noopUpdate();
                }
                IndexingStats.Stats.DocStatusStats stats = new IndexingStats.Stats.DocStatusStats();
                stats.inc(RestStatus.OK);
                this.indicesService.addDocStatusStats(stats);
                listener.onResponse((Object)update);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal result " + String.valueOf(result.getResponseResult()));
            }
        }
    }

    private void handleUpdateFailureWithRetry(ActionListener<UpdateResponse> listener, UpdateRequest request, Exception failure, int retryCount) {
        Throwable cause = SkyliteExceptionsHelper.unwrapCause((Throwable)failure);
        if (cause instanceof VersionConflictEngineException && retryCount < request.retryOnConflict()) {
            this.logger.trace("Retry attempt [{}] of [{}] on version conflict on [{}][{}][{}]", (Object)(retryCount + 1), (Object)request.retryOnConflict(), (Object)request.index(), (Object)request.getShardId(), (Object)request.id());
            this.threadPool.executor(this.executor(request.getShardId())).execute((Runnable)ActionRunnable.wrap(listener, l -> this.shardOperation(request, (ActionListener<UpdateResponse>)l, retryCount + 1)));
            return;
        }
        listener.onFailure(cause instanceof Exception ? (Exception)cause : new NotSerializableExceptionWrapper(cause));
    }

    private void incDocStatusStats(Exception e) {
        IndexingStats.Stats.DocStatusStats stats = new IndexingStats.Stats.DocStatusStats();
        stats.inc(SkyliteExceptionsHelper.status((Throwable)e));
        this.indicesService.addDocStatusStats(stats);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return UpdateAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportUpdateAction.class;
        }
    }
}

