/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.bootstrap;

import io.lucenia.bootstrap.FilePermissionUtils;
import io.lucenia.bootstrap.LuceniaPolicy;
import io.lucenia.bootstrap.LuceniaUncaughtExceptionHandler;
import io.lucenia.plugins.PluginsService;
import io.skylite.bootstrap.JarHell;
import io.skylite.cli.Command;
import io.skylite.common.SuppressForbidden;
import io.skylite.common.io.PathUtils;
import io.skylite.common.network.NetworkAddress;
import io.skylite.common.transport.PortsRange;
import io.skylite.core.env.Environment;
import io.skylite.core.http.HttpTransportSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.TcpTransport;
import io.skylite.secure_sm.SecureSM;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.Permissions;
import java.security.Policy;
import java.security.URIParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class Security {
    private Security() {
    }

    static void configure(Environment environment, boolean filterBadDefaults) throws IOException, NoSuchAlgorithmException {
        Map<String, URL> codebases = Security.getCodebaseJarMap(JarHell.parseClassPath());
        Policy.setPolicy(new LuceniaPolicy(codebases, Security.createPermissions(environment), Security.getPluginPermissions(environment), filterBadDefaults, Security.createRecursiveDataPathPermission(environment)));
        String[] classesThatCanExit = new String[]{LuceniaUncaughtExceptionHandler.PrivilegedHaltAction.class.getName().replace("$", "\\$"), Command.class.getName()};
        Set<String> trustedHosts = Security.getTrustedHosts(Arrays.asList("https://cloud.lucenia.io", "cloud.lucenia.io", "localhost"));
        System.setSecurityManager((SecurityManager)new SecureSM(classesThatCanExit, trustedHosts));
        Security.selfTest();
    }

    @SuppressForbidden(reason="whitelist local addresses")
    private static Set<String> getIPAddresses(String url) {
        HashSet<String> ipAddresses = new HashSet<String>();
        ipAddresses.add(url);
        try {
            URI uri = new URI(url);
            String hostname = uri.getHost();
            InetAddress[] addresses = InetAddress.getAllByName(hostname);
            ipAddresses.addAll(Arrays.stream(addresses).map(InetAddress::getHostAddress).collect(Collectors.toSet()));
        }
        catch (Exception e) {
            ipAddresses.add("Error: " + e.getMessage());
        }
        return ipAddresses;
    }

    private static Set<String> getIPAddressesFromURLs(List<String> urls) {
        return urls.stream().flatMap(url -> Security.getIPAddresses(url).stream()).collect(Collectors.toSet());
    }

    @SuppressForbidden(reason="find URL path")
    static Map<String, URL> getCodebaseJarMap(Set<URL> urls) {
        LinkedHashMap<String, URL> codebases = new LinkedHashMap<String, URL>();
        for (URL url : urls) {
            try {
                String fileName = PathUtils.get((URI)url.toURI()).getFileName().toString();
                if (!fileName.endsWith(".jar")) continue;
                codebases.put(fileName, url);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return codebases;
    }

    @SuppressForbidden(reason="proper use of URL")
    static Map<String, Policy> getPluginPermissions(Environment environment) throws IOException {
        HashMap<String, Policy> map = new HashMap<String, Policy>();
        LinkedHashSet<Path> pluginsAndModules = new LinkedHashSet<Path>(PluginsService.findPluginDirs(environment.pluginsDir()));
        pluginsAndModules.addAll(PluginsService.findPluginDirs(environment.modulesDir()));
        for (Path plugin : pluginsAndModules) {
            Path policyFile = plugin.resolve("plugin-security.policy");
            if (!Files.exists(policyFile, new LinkOption[0])) continue;
            LinkedHashSet<URL> codebases = new LinkedHashSet<URL>();
            try (DirectoryStream<Path> jarStream = Files.newDirectoryStream(plugin, "*.jar");){
                for (Path jar : jarStream) {
                    URL url = jar.toRealPath(new LinkOption[0]).toUri().toURL();
                    if (codebases.add(url)) continue;
                    throw new IllegalStateException("duplicate module/plugin: " + String.valueOf(url));
                }
            }
            Policy policy = Security.readPolicy(policyFile.toUri().toURL(), Security.getCodebaseJarMap(codebases));
            for (URL url : codebases) {
                if (map.put(url.getFile(), policy) == null) continue;
                throw new IllegalStateException("per-plugin permissions already granted for jar file: " + String.valueOf(url));
            }
        }
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static Policy readPolicy(URL policyFile, Map<String, URL> codebases) {
        Policy policy;
        ArrayList<CallSite> propertiesSet = new ArrayList<CallSite>();
        try {
            for (Map.Entry<String, URL> codebase : codebases.entrySet()) {
                String previous;
                String string = codebase.getKey();
                URL url = codebase.getValue();
                String property = "codebase." + string;
                String aliasProperty = "codebase." + string.replaceFirst("-\\d+\\.\\d+.*\\.jar", "");
                if (!aliasProperty.equals(property)) {
                    propertiesSet.add((CallSite)((Object)aliasProperty));
                    previous = System.setProperty(aliasProperty, url.toString());
                    if (previous != null) {
                        throw new IllegalStateException("codebase property already set: " + aliasProperty + " -> " + previous + ", cannot set to " + url.toString());
                    }
                }
                propertiesSet.add((CallSite)((Object)property));
                previous = System.setProperty(property, url.toString());
                if (previous == null) continue;
                throw new IllegalStateException("codebase property already set: " + property + " -> " + previous + ", cannot set to " + url.toString());
            }
            policy = Policy.getInstance("JavaPolicy", new URIParameter(policyFile.toURI()));
        }
        catch (Throwable throwable) {
            try {
                for (String string : propertiesSet) {
                    System.clearProperty(string);
                }
                throw throwable;
            }
            catch (URISyntaxException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("unable to parse policy file `" + String.valueOf(policyFile) + "`", e);
            }
        }
        for (String string : propertiesSet) {
            System.clearProperty(string);
        }
        return policy;
    }

    static Permissions createPermissions(Environment environment) throws IOException {
        Permissions policy = new Permissions();
        Security.addClasspathPermissions(policy);
        Security.addFilePermissions(policy, environment);
        Security.addBindPermissions(policy, environment.settings());
        return policy;
    }

    private static Permissions createRecursiveDataPathPermission(Environment environment) throws IOException {
        Permissions policy = new Permissions();
        for (Path path : environment.dataFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_DATA_SETTING.getKey(), path, "read,readlink,write,delete", true);
        }
        return policy;
    }

    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static void addClasspathPermissions(Permissions policy) throws IOException {
        for (URL url : JarHell.parseClassPath()) {
            Path path;
            try {
                path = PathUtils.get((URI)url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                FilePermissionUtils.addDirectoryPath(policy, "class.path", path, "read,readlink", false);
                continue;
            }
            FilePermissionUtils.addSingleFilePath(policy, path, "read,readlink");
        }
    }

    static void addFilePermissions(Permissions policy, Environment environment) throws IOException {
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.binDir(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.libDir(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.modulesDir(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.pluginsDir(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, "path.conf'", environment.configDir(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, "java.io.tmpdir", environment.tmpDir(), "read,readlink,write,delete", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_LOGS_SETTING.getKey(), environment.logsDir(), "read,readlink,write,delete", false);
        if (environment.sharedDataDir() != null) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_SHARED_DATA_SETTING.getKey(), environment.sharedDataDir(), "read,readlink,write,delete", false);
        }
        HashSet<Path> dataFilesPaths = new HashSet<Path>();
        for (Path path : environment.dataFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_DATA_SETTING.getKey(), path, "read,readlink,write,delete", false);
            try {
                Path realPath = path.toRealPath(new LinkOption[0]);
                if (dataFilesPaths.add(realPath)) continue;
                throw new IllegalStateException("path [" + String.valueOf(realPath) + "] is duplicated by [" + String.valueOf(path) + "]");
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to access [" + String.valueOf(path) + "]", e);
            }
        }
        for (Path path : environment.repoFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_REPO_SETTING.getKey(), path, "read,readlink,write,delete", false);
        }
        if (environment.pidFile() != null) {
            FilePermissionUtils.addSingleFilePath(policy, environment.pidFile(), "delete");
        }
    }

    private static void addBindPermissions(Permissions policy, Settings settings) {
        Security.addSocketPermissionForHttp(policy, settings);
        Security.addSocketPermissionForTransportProfiles(policy, settings);
    }

    private static void addSocketPermissionForHttp(Permissions policy, Settings settings) {
        String httpRange = ((PortsRange)HttpTransportSettings.SETTING_HTTP_PORT.get(settings)).getPortRangeString();
        Security.addSocketPermissionForPortRange(policy, httpRange);
    }

    private static void addSocketPermissionForTransportProfiles(Permissions policy, Settings settings) {
        Set profiles = TcpTransport.getProfileSettings((Settings)settings);
        HashSet<String> uniquePortRanges = new HashSet<String>();
        for (TcpTransport.ProfileSettings profile : profiles) {
            if (!uniquePortRanges.add(profile.portOrRange)) continue;
            Security.addSocketPermissionForPortRange(policy, profile.portOrRange);
        }
    }

    private static void addSocketPermissionForPortRange(Permissions policy, String portRange) {
        policy.add(new SocketPermission("*:" + portRange, "listen,resolve"));
    }

    static void ensureDirectoryExists(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            path.getFileSystem().provider().checkAccess(path.toRealPath(new LinkOption[0]), AccessMode.READ);
        } else {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                NotDirectoryException e2 = new NotDirectoryException(path.toString());
                e2.addSuppressed(e);
                throw e2;
            }
        }
    }

    @SuppressForbidden(reason="accesses jvm default tempdir as a self-test")
    static void selfTest() throws IOException {
        try {
            Path p = Files.createTempFile(null, null, new FileAttribute[0]);
            try {
                Files.delete(p);
            }
            catch (IOException iOException) {}
        }
        catch (SecurityException problem) {
            throw new SecurityException("Security misconfiguration: cannot access java.io.tmpdir", problem);
        }
    }

    static Set<String> getTrustedHosts(List<String> initialTrustedHosts) {
        HashSet<String> addresses = new HashSet<String>(Security.getIPAddressesFromURLs(initialTrustedHosts));
        try {
            addresses.addAll(Collections.list(NetworkInterface.getNetworkInterfaces()).stream().flatMap(iface -> Collections.list(iface.getInetAddresses()).stream()).map(address -> NetworkAddress.format((InetAddress)address)).collect(Collectors.toSet()));
            addresses.add(NetworkAddress.format((InetAddress)InetAddress.getLoopbackAddress()));
            addresses.add("0:0:0:0:0:0:0:0");
            addresses.add("0:0:0:0:0:0:0:1");
        }
        catch (SocketException e) {
            return Collections.emptySet();
        }
        return addresses;
    }
}

