/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.cli;

import io.lucenia.cli.CommandLoggingConfigurator;
import io.skylite.cli.Command;
import io.skylite.cli.Terminal;
import io.skylite.common.SuppressForbidden;
import io.skylite.common.posix.UserException;
import io.skylite.core.cluster.node.InternalSettingsPreparer;
import io.skylite.core.env.Environment;
import io.skylite.core.settings.Settings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.util.KeyValuePair;

public abstract class EnvironmentAwareCommand
extends Command {
    private final OptionSpec<KeyValuePair> settingOption;

    public EnvironmentAwareCommand(String description) {
        this(description, CommandLoggingConfigurator::configureLoggingWithoutConfig);
    }

    public EnvironmentAwareCommand(String description, Runnable beforeMain) {
        super(description, beforeMain);
        this.settingOption = this.parser.accepts("E", "Configure a setting").withRequiredArg().ofType(KeyValuePair.class);
    }

    protected void execute(Terminal terminal, OptionSet options) throws Exception {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (KeyValuePair kvp : this.settingOption.values(options)) {
            if (kvp.value.isEmpty()) {
                throw new UserException(64, "setting [" + kvp.key + "] must not be empty");
            }
            if (settings.containsKey(kvp.key)) {
                String message = String.format(Locale.ROOT, "setting [%s] already set, saw [%s] and [%s]", kvp.key, settings.get(kvp.key), kvp.value);
                throw new UserException(64, message);
            }
            settings.put(kvp.key, kvp.value);
        }
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "path.data", "lucenia.path.data");
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "path.home", "lucenia.path.home");
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "path.logs", "lucenia.path.logs");
        this.execute(terminal, options, this.createEnv(settings));
    }

    protected Environment createEnv(Map<String, String> settings) throws UserException {
        return this.createEnv(Settings.EMPTY, settings);
    }

    protected final Environment createEnv(Settings baseSettings, Map<String, String> settings) throws UserException {
        String luceniaPathConf = System.getProperty("lucenia.path.conf");
        if (luceniaPathConf == null) {
            throw new UserException(78, "the system property [lucenia.path.conf] must be set");
        }
        return InternalSettingsPreparer.prepareEnvironment((Settings)baseSettings, settings, (Path)EnvironmentAwareCommand.getConfigPath(luceniaPathConf), () -> System.getenv("HOSTNAME"));
    }

    @SuppressForbidden(reason="need path to construct environment")
    private static Path getConfigPath(String pathConf) {
        return Paths.get(pathConf, new String[0]);
    }

    private static void putSystemPropertyIfSettingIsMissing(Map<String, String> settings, String setting, String key) {
        String value = System.getProperty(key);
        if (value != null) {
            if (settings.containsKey(setting)) {
                String message = String.format(Locale.ROOT, "duplicate setting [%s] found via command-line [%s] and system property [%s]", setting, settings.get(setting), value);
                throw new IllegalArgumentException(message);
            }
            settings.put(setting, value);
        }
    }

    protected abstract void execute(Terminal var1, OptionSet var2, Environment var3) throws Exception;
}

