/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.common.network;

import io.lucenia.plugins.NetworkPlugin;
import io.lucenia.plugins.SecureSettingsFactory;
import io.skylite.common.CheckedFunction;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.core.ParseField;
import io.skylite.core.action.replication.ReplicationTask;
import io.skylite.core.cluster.routing.allocation.AllocationCommand;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.network.NetworkModuleSettings;
import io.skylite.core.common.network.NetworkService;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.PageCacheRecycler;
import io.skylite.core.http.HttpServerTransport;
import io.skylite.core.index.shard.PrimaryReplicaSyncer;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.plugins.SecureHttpTransportSettingsProvider;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.RawTaskStatus;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.SecureTransportSettingsProvider;
import io.skylite.core.transport.Transport;
import io.skylite.core.transport.TransportInterceptor;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestHandler;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.opensearch.cluster.routing.allocation.command.AllocateEmptyPrimaryAllocationCommand;
import org.opensearch.cluster.routing.allocation.command.AllocateReplicaAllocationCommand;
import org.opensearch.cluster.routing.allocation.command.AllocateStalePrimaryAllocationCommand;
import org.opensearch.cluster.routing.allocation.command.CancelAllocationCommand;
import org.opensearch.cluster.routing.allocation.command.MoveAllocationCommand;

public final class NetworkModule {
    public static final Setting<Boolean> TRANSPORT_SSL_DUAL_MODE_ENABLED = Setting.boolSetting((String)"transport.ssl.dual_mode.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Settings settings;
    private static final List<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
    private static final List<NamedXContentRegistry.Entry> namedXContents = new ArrayList<NamedXContentRegistry.Entry>();
    private final Map<String, Supplier<Transport>> transportFactories = new HashMap<String, Supplier<Transport>>();
    private final Map<String, Supplier<HttpServerTransport>> transportHttpFactories = new HashMap<String, Supplier<HttpServerTransport>>();
    private final List<TransportInterceptor> transportInterceptors = new ArrayList<TransportInterceptor>();

    public NetworkModule(Settings settings, List<NetworkPlugin> plugins, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, Tracer tracer, List<TransportInterceptor> transportInterceptors, Collection<SecureSettingsFactory> secureSettingsFactories) {
        this.settings = settings;
        Collection secureTransportSettingsProviders = secureSettingsFactories.stream().map(p -> p.getSecureTransportSettingsProvider(settings)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (secureTransportSettingsProviders.size() > 1) {
            throw new IllegalArgumentException("there is more than one secure transport settings provider: " + String.valueOf(secureTransportSettingsProviders));
        }
        Collection secureHttpTransportSettingsProviders = secureSettingsFactories.stream().map(p -> p.getSecureHttpTransportSettingsProvider(settings)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (secureHttpTransportSettingsProviders.size() > 1) {
            throw new IllegalArgumentException("there is more than one secure transport settings provider: " + String.valueOf(secureHttpTransportSettingsProviders));
        }
        if (transportInterceptors != null) {
            transportInterceptors.forEach(this::registerTransportInterceptor);
        }
        for (NetworkPlugin plugin : plugins) {
            Map<String, Supplier<HttpServerTransport>> httpTransportFactory = plugin.getHttpTransports(settings, threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, xContentRegistry, networkService, dispatcher, clusterSettings, tracer);
            for (Map.Entry<String, Supplier<HttpServerTransport>> entry : httpTransportFactory.entrySet()) {
                this.registerHttpTransport(entry.getKey(), entry.getValue());
            }
            Map<String, Supplier<Transport>> transportFactory = plugin.getTransports(settings, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService, tracer);
            for (Map.Entry<String, Supplier<Transport>> entry3 : transportFactory.entrySet()) {
                this.registerTransport(entry3.getKey(), entry3.getValue());
            }
            if (!secureHttpTransportSettingsProviders.isEmpty()) {
                SecureHttpTransportSettingsProvider secureHttpTransportSettingsProvider = (SecureHttpTransportSettingsProvider)secureHttpTransportSettingsProviders.iterator().next();
                Map<String, Supplier<HttpServerTransport>> secureHttpTransportFactory = plugin.getSecureHttpTransports(settings, threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, xContentRegistry, networkService, dispatcher, clusterSettings, secureHttpTransportSettingsProvider, tracer);
                for (Map.Entry<String, Supplier<HttpServerTransport>> entry : secureHttpTransportFactory.entrySet()) {
                    this.registerHttpTransport(entry.getKey(), entry.getValue());
                }
            }
            if (!secureTransportSettingsProviders.isEmpty()) {
                SecureTransportSettingsProvider secureTransportSettingsProvider = (SecureTransportSettingsProvider)secureTransportSettingsProviders.iterator().next();
                Map<String, Supplier<Transport>> secureTransportFactory = plugin.getSecureTransports(settings, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService, secureTransportSettingsProvider, tracer);
                for (Map.Entry<String, Supplier<HttpServerTransport>> entry : secureTransportFactory.entrySet()) {
                    this.registerTransport(entry.getKey(), entry.getValue());
                }
            }
            List<TransportInterceptor> list = plugin.getTransportInterceptors(namedWriteableRegistry, threadPool.getThreadContext());
            for (TransportInterceptor interceptor : list) {
                this.registerTransportInterceptor(interceptor);
            }
        }
    }

    private void registerTransport(String key, Supplier<Transport> factory) {
        if (this.transportFactories.putIfAbsent(key, factory) != null) {
            throw new IllegalArgumentException("transport for name: " + key + " is already registered");
        }
    }

    private void registerHttpTransport(String key, Supplier<HttpServerTransport> factory) {
        if (this.transportHttpFactories.putIfAbsent(key, factory) != null) {
            throw new IllegalArgumentException("transport for name: " + key + " is already registered");
        }
    }

    private static <T extends AllocationCommand> void registerAllocationCommand(Writeable.Reader<T> reader, CheckedFunction<XContentParser, T, IOException> parser, ParseField commandName) {
        namedXContents.add(new NamedXContentRegistry.Entry(AllocationCommand.class, commandName, parser));
        namedWriteables.add(new NamedWriteableRegistry.Entry(AllocationCommand.class, commandName.getPreferredName(), reader));
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.unmodifiableList(namedWriteables);
    }

    public static List<NamedXContentRegistry.Entry> getNamedXContents() {
        return Collections.unmodifiableList(namedXContents);
    }

    public Supplier<HttpServerTransport> getHttpServerTransportSupplier() {
        String name = NetworkModuleSettings.HTTP_TYPE_SETTING.exists(this.settings) ? (String)NetworkModuleSettings.HTTP_TYPE_SETTING.get(this.settings) : (String)NetworkModuleSettings.HTTP_DEFAULT_TYPE_SETTING.get(this.settings);
        Supplier<HttpServerTransport> factory = this.transportHttpFactories.get(name);
        if (factory == null) {
            throw new IllegalStateException("Unsupported http.type [" + name + "]");
        }
        return factory;
    }

    public Supplier<Transport> getTransportSupplier() {
        String name = NetworkModuleSettings.TRANSPORT_TYPE_SETTING.exists(this.settings) ? (String)NetworkModuleSettings.TRANSPORT_TYPE_SETTING.get(this.settings) : (String)NetworkModuleSettings.TRANSPORT_DEFAULT_TYPE_SETTING.get(this.settings);
        Supplier<Transport> factory = this.transportFactories.get(name);
        if (factory == null) {
            throw new IllegalStateException("Unsupported transport.type [" + name + "]");
        }
        return factory;
    }

    private void registerTransportInterceptor(TransportInterceptor interceptor) {
        this.transportInterceptors.add(Objects.requireNonNull(interceptor, "interceptor must not be null"));
    }

    public TransportInterceptor getTransportInterceptor() {
        return new CompositeTransportInterceptor(this.transportInterceptors);
    }

    static {
        NetworkModule.registerAllocationCommand(CancelAllocationCommand::new, CancelAllocationCommand::fromXContent, CancelAllocationCommand.COMMAND_NAME_FIELD);
        NetworkModule.registerAllocationCommand(MoveAllocationCommand::new, MoveAllocationCommand::fromXContent, MoveAllocationCommand.COMMAND_NAME_FIELD);
        NetworkModule.registerAllocationCommand(AllocateReplicaAllocationCommand::new, AllocateReplicaAllocationCommand::fromXContent, AllocateReplicaAllocationCommand.COMMAND_NAME_FIELD);
        NetworkModule.registerAllocationCommand(AllocateEmptyPrimaryAllocationCommand::new, AllocateEmptyPrimaryAllocationCommand::fromXContent, AllocateEmptyPrimaryAllocationCommand.COMMAND_NAME_FIELD);
        NetworkModule.registerAllocationCommand(AllocateStalePrimaryAllocationCommand::new, AllocateStalePrimaryAllocationCommand::fromXContent, AllocateStalePrimaryAllocationCommand.COMMAND_NAME_FIELD);
        namedWriteables.add(new NamedWriteableRegistry.Entry(Task.Status.class, "replication", ReplicationTask.Status::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(Task.Status.class, "raw", RawTaskStatus::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(Task.Status.class, "resync", PrimaryReplicaSyncer.ResyncTask.Status::new));
    }

    static final class CompositeTransportInterceptor
    implements TransportInterceptor {
        final List<TransportInterceptor> transportInterceptors;

        private CompositeTransportInterceptor(List<TransportInterceptor> transportInterceptors) {
            this.transportInterceptors = new ArrayList<TransportInterceptor>(transportInterceptors);
        }

        public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
            for (TransportInterceptor interceptor : this.transportInterceptors) {
                actualHandler = interceptor.interceptHandler(action, executor, forceExecution, actualHandler);
            }
            return actualHandler;
        }

        public TransportInterceptor.AsyncSender interceptSender(TransportInterceptor.AsyncSender sender) {
            for (TransportInterceptor interceptor : this.transportInterceptors) {
                sender = interceptor.interceptSender(sender);
            }
            return sender;
        }
    }
}

