/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import io.skylite.Version;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.cluster.NotClusterManagerException;
import io.skylite.core.cluster.block.ClusterBlocks;
import io.skylite.core.cluster.coordination.CoordinationMetadata;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.RepositoriesMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.RerouteService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskExecutor;
import io.skylite.core.common.Priority;
import io.skylite.core.node.RemoteStoreNodeAttribute;
import io.skylite.core.node.RemoteStoreNodeService;
import io.skylite.core.settings.Settings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.decommission.DecommissionHelper;
import org.opensearch.cluster.decommission.NodeDecommissionedException;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.persistent.PersistentTasksCustomMetadata;

public class JoinTaskExecutor
implements ClusterStateTaskExecutor<Task> {
    private final AllocationService allocationService;
    private final Logger logger;
    private final RerouteService rerouteService;
    private final RemoteStoreNodeService remoteStoreNodeService;

    public JoinTaskExecutor(Settings settings, AllocationService allocationService, Logger logger, RerouteService rerouteService, RemoteStoreNodeService remoteStoreNodeService) {
        this.allocationService = allocationService;
        this.logger = logger;
        this.rerouteService = rerouteService;
        this.remoteStoreNodeService = remoteStoreNodeService;
    }

    public ClusterStateTaskExecutor.ClusterStateTasksResult<Task> execute(ClusterState currentState, List<Task> joiningNodes) throws Exception {
        ClusterState.Builder newState;
        ClusterStateTaskExecutor.ClusterStateTasksResult.Builder results = ClusterStateTaskExecutor.ClusterStateTasksResult.builder();
        DiscoveryNodes currentNodes = currentState.nodes();
        boolean nodesChanged = false;
        if (joiningNodes.size() == 1 && joiningNodes.get(0).isFinishElectionTask()) {
            return results.successes(joiningNodes).build(currentState);
        }
        if (currentNodes.getClusterManagerNode() == null && joiningNodes.stream().anyMatch(Task::isBecomeClusterManagerTask)) {
            assert (joiningNodes.stream().anyMatch(Task::isFinishElectionTask)) : "becoming a cluster-manager but election is not finished " + String.valueOf(joiningNodes);
            newState = this.becomeClusterManagerAndTrimConflictingNodes(currentState, joiningNodes);
            nodesChanged = true;
        } else {
            if (!currentNodes.isLocalNodeElectedClusterManager()) {
                this.logger.trace("processing node joins, but we are not the cluster-manager. current cluster-manager: {}", (Object)currentNodes.getClusterManagerNode());
                throw new NotClusterManagerException("Node [" + String.valueOf(currentNodes.getLocalNode()) + "] not cluster-manager for join request");
            }
            newState = ClusterState.builder((ClusterState)currentState);
        }
        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder((DiscoveryNodes)newState.nodes());
        Optional<DiscoveryNode> remoteDN = currentNodes.getNodes().values().stream().filter(DiscoveryNode::isRemoteStoreNode).findFirst();
        DiscoveryNode dn = remoteDN.orElseGet(() -> (DiscoveryNode)currentNodes.getNodes().values().stream().findFirst().get());
        RepositoriesMetadata repositoriesMetadata = this.remoteStoreNodeService.updateRepositoriesMetadata(dn, (RepositoriesMetadata)currentState.getMetadata().custom("repositories"));
        assert (nodesBuilder.isLocalNodeElectedClusterManager());
        Version minClusterNodeVersion = newState.nodes().getMinNodeVersion();
        Version maxClusterNodeVersion = newState.nodes().getMaxNodeVersion();
        boolean enforceMajorVersion = !currentState.getBlocks().hasGlobalBlock(ClusterBlocks.STATE_NOT_RECOVERED_BLOCK);
        HashMap<String, String> joiniedNodeNameIds = new HashMap<String, String>();
        for (Task joinTask : joiningNodes) {
            block16: {
                DiscoveryNode node = joinTask.node();
                if (!joinTask.isBecomeClusterManagerTask() && !joinTask.isFinishElectionTask()) {
                    if (currentNodes.nodeExistsWithSameRoles(node)) {
                        this.logger.debug("received a join request for an existing node [{}]", (Object)node);
                    } else {
                        try {
                            if (enforceMajorVersion) {
                                JoinTaskExecutor.ensureMajorVersionBarrier(node.getVersion(), minClusterNodeVersion);
                            }
                            JoinTaskExecutor.ensureNodesCompatibility(node, currentNodes, currentState.metadata(), minClusterNodeVersion, maxClusterNodeVersion);
                            JoinTaskExecutor.ensureIndexCompatibility(node.getVersion(), currentState.getMetadata());
                            JoinTaskExecutor.ensureNodeCommissioned(node, currentState.metadata());
                            nodesBuilder.add(node);
                            if (remoteDN.isEmpty() && node.isRemoteStoreNode()) {
                                this.logger.info("Updating system repository now for remote store");
                                repositoriesMetadata = this.remoteStoreNodeService.updateRepositoriesMetadata(node, (RepositoriesMetadata)currentState.getMetadata().custom("repositories"));
                            }
                            nodesChanged = true;
                            minClusterNodeVersion = Version.min((Version)minClusterNodeVersion, (Version)node.getVersion());
                            maxClusterNodeVersion = Version.max((Version)maxClusterNodeVersion, (Version)node.getVersion());
                            if (!node.isClusterManagerNode()) break block16;
                            joiniedNodeNameIds.put(node.getName(), node.getId());
                        }
                        catch (IllegalArgumentException | IllegalStateException | NodeDecommissionedException e2) {
                            results.failure((Object)joinTask, (Exception)e2);
                            continue;
                        }
                    }
                }
            }
            results.success((Object)joinTask);
        }
        if (nodesChanged) {
            Set currentVotingConfigExclusions;
            Set<CoordinationMetadata.VotingConfigExclusion> newVotingConfigExclusions;
            this.rerouteService.reroute("post-join reroute", Priority.HIGH, ActionListenerHelper.wrap(r -> this.logger.trace("post-join reroute completed"), e -> this.logger.debug("post-join reroute failed", (Throwable)e)));
            if (!joiniedNodeNameIds.isEmpty() && !(newVotingConfigExclusions = (currentVotingConfigExclusions = currentState.getVotingConfigExclusions()).stream().map(e -> {
                if ("_absent_".equals(e.getNodeId()) && joiniedNodeNameIds.containsKey(e.getNodeName())) {
                    return new CoordinationMetadata.VotingConfigExclusion((String)joiniedNodeNameIds.get(e.getNodeName()), e.getNodeName());
                }
                return e;
            }).collect(Collectors.toSet())).equals(currentVotingConfigExclusions)) {
                CoordinationMetadata.Builder coordMetadataBuilder = CoordinationMetadata.builder((CoordinationMetadata)currentState.coordinationMetadata()).clearVotingConfigExclusions();
                newVotingConfigExclusions.forEach(arg_0 -> ((CoordinationMetadata.Builder)coordMetadataBuilder).addVotingConfigExclusion(arg_0));
                Metadata newMetadata = Metadata.builder((Metadata)currentState.metadata()).coordinationMetadata(coordMetadataBuilder.build()).build();
                return results.build(this.allocationService.adaptAutoExpandReplicas(newState.nodes(nodesBuilder).metadata(this.updateMetadataWithRepositoriesMetadata(newMetadata, repositoriesMetadata)).build()));
            }
            return results.build(this.allocationService.adaptAutoExpandReplicas(newState.nodes(nodesBuilder).metadata(this.updateMetadataWithRepositoriesMetadata(currentState.metadata(), repositoriesMetadata)).build()));
        }
        return results.build(newState.metadata(this.updateMetadataWithRepositoriesMetadata(currentState.metadata(), repositoriesMetadata)).build());
    }

    private Metadata updateMetadataWithRepositoriesMetadata(Metadata currentMetadata, RepositoriesMetadata repositoriesMetadata) {
        if (repositoriesMetadata == null || repositoriesMetadata.repositories() == null || repositoriesMetadata.repositories().isEmpty()) {
            return currentMetadata;
        }
        return Metadata.builder((Metadata)currentMetadata).putCustom("repositories", (Metadata.Custom)repositoriesMetadata.get()).build();
    }

    protected ClusterState.Builder becomeClusterManagerAndTrimConflictingNodes(ClusterState currentState, List<Task> joiningNodes) {
        assert (currentState.nodes().getClusterManagerNodeId() == null) : currentState;
        DiscoveryNodes currentNodes = currentState.nodes();
        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder((DiscoveryNodes)currentNodes);
        nodesBuilder.clusterManagerNodeId(currentState.nodes().getLocalNodeId());
        for (Task joinTask : joiningNodes) {
            DiscoveryNode nodeWithSameAddress;
            if (joinTask.isBecomeClusterManagerTask() || joinTask.isFinishElectionTask()) continue;
            DiscoveryNode joiningNode = joinTask.node();
            DiscoveryNode nodeWithSameId = nodesBuilder.get(joiningNode.getId());
            if (nodeWithSameId != null && !nodeWithSameId.equals((Object)joiningNode)) {
                this.logger.debug("removing existing node [{}], which conflicts with incoming join from [{}]", (Object)nodeWithSameId, (Object)joiningNode);
                nodesBuilder.remove(nodeWithSameId.getId());
            }
            if ((nodeWithSameAddress = currentNodes.findByAddress(joiningNode.getAddress())) == null || nodeWithSameAddress.equals((Object)joiningNode)) continue;
            this.logger.debug("removing existing node [{}], which conflicts with incoming join from [{}]", (Object)nodeWithSameAddress, (Object)joiningNode);
            nodesBuilder.remove(nodeWithSameAddress.getId());
        }
        ClusterState tmpState = ClusterState.builder((ClusterState)currentState).nodes(nodesBuilder).blocks(ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(2)).build();
        this.logger.trace("becomeClusterManagerAndTrimConflictingNodes: {}", (Object)tmpState.nodes());
        this.allocationService.cleanCaches();
        tmpState = PersistentTasksCustomMetadata.disassociateDeadNodes(tmpState);
        return ClusterState.builder((ClusterState)this.allocationService.disassociateDeadNodes(tmpState, false, "removed dead nodes on election"));
    }

    public boolean runOnlyOnClusterManager() {
        return false;
    }

    @Deprecated
    public static Task newBecomeMasterTask() {
        return new Task(null, "_BECOME_MASTER_TASK_");
    }

    public static Task newBecomeClusterManagerTask() {
        return new Task(null, "_BECOME_CLUSTER_MANAGER_TASK_");
    }

    public static Task newFinishElectionTask() {
        return new Task(null, "_FINISH_ELECTION_");
    }

    public static void ensureIndexCompatibility(Version nodeVersion, Metadata metadata) {
        Version supportedIndexVersion = nodeVersion.minimumIndexCompatibilityVersion();
        for (IndexMetadata idxMetadata : metadata) {
            if (idxMetadata.getCreationVersion().after(nodeVersion)) {
                throw new IllegalStateException("index " + String.valueOf(idxMetadata.getIndex()) + " version not supported: " + String.valueOf(idxMetadata.getCreationVersion()) + " the node version is: " + String.valueOf(nodeVersion));
            }
            if (!idxMetadata.getCreationVersion().before(supportedIndexVersion)) continue;
            throw new IllegalStateException("index " + String.valueOf(idxMetadata.getIndex()) + " version not supported: " + String.valueOf(idxMetadata.getCreationVersion()) + " minimum compatible index version is: " + String.valueOf(supportedIndexVersion));
        }
    }

    public static void ensureNodesCompatibility(DiscoveryNode joiningNode, DiscoveryNodes currentNodes, Metadata metadata) {
        Version minNodeVersion = currentNodes.getMinNodeVersion();
        Version maxNodeVersion = currentNodes.getMaxNodeVersion();
        JoinTaskExecutor.ensureNodesCompatibility(joiningNode, currentNodes, metadata, minNodeVersion, maxNodeVersion);
    }

    public static void ensureNodesCompatibility(DiscoveryNode joiningNode, DiscoveryNodes currentNodes, Metadata metadata, Version minClusterNodeVersion, Version maxClusterNodeVersion) {
        Version joiningNodeVersion = joiningNode.getVersion();
        assert (minClusterNodeVersion.onOrBefore(maxClusterNodeVersion)) : String.valueOf(minClusterNodeVersion) + " > " + String.valueOf(maxClusterNodeVersion);
        if (!joiningNodeVersion.isCompatible(maxClusterNodeVersion)) {
            throw new IllegalStateException("node version [" + String.valueOf(joiningNodeVersion) + "] is not supported. The cluster contains nodes with version [" + String.valueOf(maxClusterNodeVersion) + "], which is incompatible.");
        }
        if (!joiningNodeVersion.isCompatible(minClusterNodeVersion)) {
            throw new IllegalStateException("node version [" + String.valueOf(joiningNodeVersion) + "] is not supported.The cluster contains nodes with version [" + String.valueOf(minClusterNodeVersion) + "], which is incompatible.");
        }
        JoinTaskExecutor.ensureRemoteStoreNodesCompatibility(joiningNode, currentNodes, metadata);
    }

    public static void ensureMajorVersionBarrier(Version joiningNodeVersion, Version minClusterNodeVersion) {
        byte clusterMajor;
        byte by = clusterMajor = minClusterNodeVersion.major == 1 ? (byte)7 : (byte)minClusterNodeVersion.major;
        if (joiningNodeVersion.compareMajor(minClusterNodeVersion) < 0) {
            throw new IllegalStateException("node version [" + String.valueOf(joiningNodeVersion) + "] is not supported. All nodes in the cluster are of a higher major [" + clusterMajor + "].");
        }
    }

    public static void ensureNodeCommissioned(DiscoveryNode node, Metadata metadata) {
        if (!DecommissionHelper.nodeCommissioned(node, metadata)) {
            throw new NodeDecommissionedException("node [{}] has decommissioned attribute [{}] with current status of decommissioning [{}]", node.toString(), metadata.decommissionAttributeMetadata().decommissionAttribute().toString(), metadata.decommissionAttributeMetadata().status().status());
        }
    }

    private static void ensureRemoteStoreNodesCompatibility(DiscoveryNode joiningNode, DiscoveryNodes currentNodes, Metadata metadata) {
        ArrayList existingNodes = new ArrayList(currentNodes.getNodes().values());
        assert (!existingNodes.isEmpty());
        RemoteStoreNodeService.CompatibilityMode remoteStoreCompatibilityMode = (RemoteStoreNodeService.CompatibilityMode)RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING.get(metadata.settings());
        if (RemoteStoreNodeService.CompatibilityMode.STRICT.equals((Object)remoteStoreCompatibilityMode)) {
            DiscoveryNode existingNode = (DiscoveryNode)existingNodes.get(0);
            if (joiningNode.isRemoteStoreNode()) {
                JoinTaskExecutor.ensureRemoteStoreNodesCompatibility(joiningNode, existingNode);
            } else if (existingNode.isRemoteStoreNode()) {
                throw new IllegalStateException("a non remote store node [" + String.valueOf(joiningNode) + "] is trying to join a remote store cluster");
            }
        } else if (remoteStoreCompatibilityMode == RemoteStoreNodeService.CompatibilityMode.MIXED && joiningNode.isRemoteStoreNode()) {
            Optional<DiscoveryNode> remoteDN = existingNodes.stream().filter(DiscoveryNode::isRemoteStoreNode).findFirst();
            remoteDN.ifPresent(discoveryNode -> JoinTaskExecutor.ensureRemoteStoreNodesCompatibility(joiningNode, discoveryNode));
        }
    }

    private static void ensureRemoteStoreNodesCompatibility(DiscoveryNode joiningNode, DiscoveryNode existingNode) {
        if (joiningNode.isRemoteStoreNode()) {
            if (existingNode.isRemoteStoreNode()) {
                RemoteStoreNodeAttribute existingRemoteStoreNodeAttribute = new RemoteStoreNodeAttribute(existingNode);
                RemoteStoreNodeAttribute joiningRemoteStoreNodeAttribute = new RemoteStoreNodeAttribute(joiningNode);
                if (!existingRemoteStoreNodeAttribute.equals((Object)joiningRemoteStoreNodeAttribute)) {
                    throw new IllegalStateException("a remote store node [" + String.valueOf(joiningNode) + "] is trying to join a remote store cluster with incompatible node attributes in comparison with existing node [" + String.valueOf(existingNode) + "]");
                }
            } else {
                throw new IllegalStateException("a remote store node [" + String.valueOf(joiningNode) + "] is trying to join a non remote store cluster");
            }
        }
    }

    public static Collection<BiConsumer<DiscoveryNode, ClusterState>> addBuiltInJoinValidators(Collection<BiConsumer<DiscoveryNode, ClusterState>> onJoinValidators) {
        ArrayList<BiConsumer<DiscoveryNode, ClusterState>> validators = new ArrayList<BiConsumer<DiscoveryNode, ClusterState>>();
        validators.add((node, state) -> {
            JoinTaskExecutor.ensureNodesCompatibility(node, state.getNodes(), state.metadata());
            JoinTaskExecutor.ensureIndexCompatibility(node.getVersion(), state.getMetadata());
            JoinTaskExecutor.ensureNodeCommissioned(node, state.getMetadata());
        });
        validators.addAll(onJoinValidators);
        return Collections.unmodifiableCollection(validators);
    }

    public static class Task {
        private final DiscoveryNode node;
        private final String reason;
        @Deprecated
        private static final String BECOME_MASTER_TASK_REASON = "_BECOME_MASTER_TASK_";
        private static final String BECOME_CLUSTER_MANAGER_TASK_REASON = "_BECOME_CLUSTER_MANAGER_TASK_";
        private static final String FINISH_ELECTION_TASK_REASON = "_FINISH_ELECTION_";

        public Task(DiscoveryNode node, String reason) {
            this.node = node;
            this.reason = reason;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String reason() {
            return this.reason;
        }

        public String toString() {
            return this.node != null ? String.valueOf(this.node) + " " + this.reason : this.reason;
        }

        public boolean isBecomeClusterManagerTask() {
            return this.reason.equals(BECOME_MASTER_TASK_REASON) || this.reason.equals(BECOME_CLUSTER_MANAGER_TASK_REASON);
        }

        @Deprecated
        public boolean isBecomeMasterTask() {
            return this.isBecomeClusterManagerTask();
        }

        public boolean isFinishElectionTask() {
            return this.reason.equals(FINISH_ELECTION_TASK_REASON);
        }
    }
}

