/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.transport.TransportResponse;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PeersResponse
extends TransportResponse {
    private final Optional<DiscoveryNode> clusterManagerNode;
    private final List<DiscoveryNode> knownPeers;
    private final long term;

    public PeersResponse(Optional<DiscoveryNode> clusterManagerNode, List<DiscoveryNode> knownPeers, long term) {
        assert (!clusterManagerNode.isPresent() || knownPeers.isEmpty());
        this.clusterManagerNode = clusterManagerNode;
        this.knownPeers = knownPeers;
        this.term = term;
    }

    public PeersResponse(StreamInput in) throws IOException {
        this.clusterManagerNode = Optional.ofNullable((DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new));
        this.knownPeers = in.readList(DiscoveryNode::new);
        this.term = in.readLong();
        assert (!this.clusterManagerNode.isPresent() || this.knownPeers.isEmpty());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.clusterManagerNode.orElse(null));
        out.writeList(this.knownPeers);
        out.writeLong(this.term);
    }

    public Optional<DiscoveryNode> getClusterManagerNode() {
        return this.clusterManagerNode;
    }

    @Deprecated
    public Optional<DiscoveryNode> getMasterNode() {
        return this.getClusterManagerNode();
    }

    public List<DiscoveryNode> getKnownPeers() {
        return this.knownPeers;
    }

    public long getTerm() {
        return this.term;
    }

    public String toString() {
        return "PeersResponse{clusterManagerNode=" + String.valueOf(this.clusterManagerNode) + ", knownPeers=" + String.valueOf(this.knownPeers) + ", term=" + this.term + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PeersResponse that = (PeersResponse)((Object)o);
        return this.term == that.term && Objects.equals(this.clusterManagerNode, that.clusterManagerNode) && Objects.equals(this.knownPeers, that.knownPeers);
    }

    public int hashCode() {
        return Objects.hash(this.clusterManagerNode, this.knownPeers, this.term);
    }
}

