/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.transport.TransportResponse;
import java.io.IOException;
import java.util.Optional;
import org.opensearch.cluster.coordination.Join;
import org.opensearch.cluster.coordination.PublishResponse;

public class PublishWithJoinResponse
extends TransportResponse {
    private final PublishResponse publishResponse;
    private final Optional<Join> optionalJoin;

    public PublishWithJoinResponse(PublishResponse publishResponse, Optional<Join> optionalJoin) {
        this.publishResponse = publishResponse;
        this.optionalJoin = optionalJoin;
    }

    public PublishWithJoinResponse(StreamInput in) throws IOException {
        this.publishResponse = new PublishResponse(in);
        this.optionalJoin = Optional.ofNullable((Join)in.readOptionalWriteable(Join::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.publishResponse.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.optionalJoin.orElse(null));
    }

    public PublishResponse getPublishResponse() {
        return this.publishResponse;
    }

    public Optional<Join> getJoin() {
        return this.optionalJoin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishWithJoinResponse)) {
            return false;
        }
        PublishWithJoinResponse that = (PublishWithJoinResponse)((Object)o);
        if (!this.publishResponse.equals(that.publishResponse)) {
            return false;
        }
        return this.optionalJoin.equals(that.optionalJoin);
    }

    public int hashCode() {
        int result = this.publishResponse.hashCode();
        result = 31 * result + this.optionalJoin.hashCode();
        return result;
    }

    public String toString() {
        return "PublishWithJoinResponse{publishResponse=" + String.valueOf(this.publishResponse) + ", optionalJoin=" + String.valueOf(this.optionalJoin) + "}";
    }
}

