/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.decommission;

import io.skylite.SkyliteTimeoutException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.cluster.configuration.VotingConfigExclusionsHelper;
import io.skylite.core.action.admin.cluster.node.stats.NodeStats;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsRequest;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsResponse;
import io.skylite.core.cluster.decommission.DecommissionAttributeMetadata;
import io.skylite.core.cluster.decommission.DecommissionStatus;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateObserver;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateTaskExecutor;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.common.Priority;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.http.HttpStats;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.coordination.NodeRemovalClusterStateTaskExecutor;
import org.opensearch.cluster.routing.allocation.AllocationService;

public class DecommissionController {
    private static final Logger logger = LogManager.getLogger(DecommissionController.class);
    private final NodeRemovalClusterStateTaskExecutor nodeRemovalExecutor;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final ThreadPool threadPool;

    DecommissionController(ClusterService clusterService, TransportService transportService, AllocationService allocationService, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.nodeRemovalExecutor = new NodeRemovalClusterStateTaskExecutor(allocationService, logger);
        this.threadPool = threadPool;
    }

    public synchronized void removeDecommissionedNodes(final Set<DiscoveryNode> nodesToBeDecommissioned, String reason, TimeValue timeout, final ActionListener<Void> nodesRemovedListener) {
        LinkedHashMap nodesDecommissionTasks = new LinkedHashMap(nodesToBeDecommissioned.size());
        nodesToBeDecommissioned.forEach(discoveryNode -> {
            NodeRemovalClusterStateTaskExecutor.Task task = new NodeRemovalClusterStateTaskExecutor.Task((DiscoveryNode)discoveryNode, reason);
            nodesDecommissionTasks.put(task, this.nodeRemovalExecutor);
        });
        logger.info("submitting state update task to remove [{}] nodes due to decommissioning", (Object)nodesToBeDecommissioned.toString());
        this.clusterService.submitStateUpdateTasks("node-decommissioned", nodesDecommissionTasks, ClusterStateTaskConfig.build((Priority)Priority.URGENT), (ClusterStateTaskExecutor)this.nodeRemovalExecutor);
        Predicate<ClusterState> allDecommissionedNodesRemovedPredicate = clusterState -> {
            Set intersection = Arrays.stream(clusterState.nodes().getNodes().values().toArray(new DiscoveryNode[0])).collect(Collectors.toSet());
            intersection.retainAll(nodesToBeDecommissioned);
            return intersection.size() == 0;
        };
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, timeout, logger, this.threadPool.getThreadContext());
        ClusterStateObserver.Listener removalListener = new ClusterStateObserver.Listener(){

            public void onNewClusterState(ClusterState state) {
                logger.info("successfully removed all decommissioned nodes [{}] from the cluster", (Object)nodesToBeDecommissioned.toString());
                nodesRemovedListener.onResponse(null);
            }

            public void onClusterServiceClose() {
                logger.warn("cluster service closed while waiting for removal of decommissioned nodes [{}]", (Object)nodesToBeDecommissioned.toString());
            }

            public void onTimeout(TimeValue timeout) {
                logger.info("timed out [{}] while waiting for removal of decommissioned nodes [{}]", (Object)timeout.toString(), (Object)nodesToBeDecommissioned.toString());
                nodesRemovedListener.onFailure((Exception)new SkyliteTimeoutException("timed out [{}] while waiting for removal of decommissioned nodes [{}]", new Object[]{timeout.toString(), nodesToBeDecommissioned.toString()}));
            }
        };
        if (allDecommissionedNodesRemovedPredicate.test(this.clusterService.getClusterApplierService().state())) {
            removalListener.onNewClusterState(this.clusterService.getClusterApplierService().state());
        } else {
            observer.waitForNextChange(removalListener, allDecommissionedNodesRemovedPredicate);
        }
    }

    public void updateMetadataWithDecommissionStatus(final DecommissionStatus decommissionStatus, final ActionListener<DecommissionStatus> listener) {
        this.clusterService.submitStateUpdateTask("update-decommission-status", (ClusterStateTaskConfig)new ClusterStateUpdateTask(this, Priority.URGENT){

            public ClusterState execute(ClusterState currentState) {
                DecommissionAttributeMetadata decommissionAttributeMetadata = currentState.metadata().decommissionAttributeMetadata();
                assert (decommissionAttributeMetadata != null && decommissionAttributeMetadata.decommissionAttribute() != null);
                logger.info("attempting to update current decommission status [{}] with expected status [{}]", (Object)decommissionAttributeMetadata.status(), (Object)decommissionStatus);
                decommissionAttributeMetadata.validateNewStatus(decommissionStatus);
                decommissionAttributeMetadata = new DecommissionAttributeMetadata(decommissionAttributeMetadata.decommissionAttribute(), decommissionStatus, decommissionAttributeMetadata.requestID());
                ClusterState newState = ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.metadata()).decommissionAttributeMetadata(decommissionAttributeMetadata)).build();
                if (decommissionStatus.equals((Object)DecommissionStatus.SUCCESSFUL) || decommissionStatus.equals((Object)DecommissionStatus.FAILED)) {
                    newState = VotingConfigExclusionsHelper.clearExclusionsAndGetState((ClusterState)newState);
                }
                return newState;
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                DecommissionAttributeMetadata decommissionAttributeMetadata = newState.metadata().decommissionAttributeMetadata();
                assert (decommissionAttributeMetadata != null);
                assert (decommissionAttributeMetadata.status().equals((Object)decommissionStatus));
                listener.onResponse((Object)decommissionAttributeMetadata.status());
            }
        });
    }

    private void logActiveConnections(NodesStatsResponse nodesStatsResponse) {
        if (nodesStatsResponse == null || nodesStatsResponse.getNodes() == null) {
            logger.info("Node stats response received is null/empty.");
            return;
        }
        HashMap<String, Long> nodeActiveConnectionMap = new HashMap<String, Long>();
        List responseNodes = nodesStatsResponse.getNodes();
        for (int i = 0; i < responseNodes.size(); ++i) {
            HttpStats httpStats = ((NodeStats)responseNodes.get(i)).getHttp();
            DiscoveryNode node = ((NodeStats)responseNodes.get(i)).getNode();
            nodeActiveConnectionMap.put(node.getId(), httpStats.getServerOpen());
        }
        logger.info("Decommissioning node with connections : [{}]", nodeActiveConnectionMap);
    }

    void getActiveRequestCountOnDecommissionedNodes(Set<DiscoveryNode> decommissionedNodes) {
        if (decommissionedNodes == null || decommissionedNodes.isEmpty()) {
            return;
        }
        String[] nodes = (String[])decommissionedNodes.stream().map(DiscoveryNode::getId).toArray(String[]::new);
        if (nodes.length == 0) {
            return;
        }
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest(nodes);
        nodesStatsRequest.clear();
        nodesStatsRequest.addMetric(NodesStatsRequest.Metric.HTTP.metricName());
        this.transportService.sendRequest(this.transportService.getLocalNode(), "cluster:monitor/nodes/stats", (TransportRequest)nodesStatsRequest, (TransportResponseHandler)new TransportResponseHandler<NodesStatsResponse>(){

            public void handleResponse(NodesStatsResponse response) {
                DecommissionController.this.logActiveConnections(response);
            }

            public void handleException(TransportException exp) {
                logger.error("Failure occurred while dumping connection for decommission nodes - ", exp.unwrapCause());
            }

            public String executor() {
                return "same";
            }

            public NodesStatsResponse read(StreamInput in) throws IOException {
                return new NodesStatsResponse(in);
            }
        });
    }
}

