/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.decommission;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.cluster.configuration.AddVotingConfigExclusionsRequest;
import io.skylite.core.action.admin.cluster.configuration.VotingConfigExclusionsHelper;
import io.skylite.core.cluster.decommission.DecommissionAttribute;
import io.skylite.core.cluster.decommission.DecommissionAttributeMetadata;
import io.skylite.core.cluster.decommission.DecommissionStatus;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.Strings;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DecommissionHelper {
    static ClusterState registerDecommissionAttributeInClusterState(ClusterState currentState, DecommissionAttribute decommissionAttribute, String requestID) {
        DecommissionAttributeMetadata decommissionAttributeMetadata = new DecommissionAttributeMetadata(decommissionAttribute, requestID);
        return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.metadata()).decommissionAttributeMetadata(decommissionAttributeMetadata)).build();
    }

    static ClusterState deleteDecommissionAttributeInClusterState(ClusterState currentState) {
        Metadata metadata = currentState.metadata();
        Metadata.Builder mdBuilder = Metadata.builder((Metadata)metadata);
        mdBuilder.removeCustom("decommissionedAttribute");
        return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
    }

    static ClusterState addVotingConfigExclusionsForNodesToBeDecommissioned(ClusterState currentState, Set<String> nodeIdsToBeExcluded, TimeValue decommissionActionTimeout, int maxVotingConfigExclusions) {
        AddVotingConfigExclusionsRequest request = new AddVotingConfigExclusionsRequest(Strings.EMPTY_ARRAY, (String[])nodeIdsToBeExcluded.toArray(String[]::new), Strings.EMPTY_ARRAY, decommissionActionTimeout);
        Set resolvedExclusion = VotingConfigExclusionsHelper.resolveVotingConfigExclusionsAndCheckMaximum((AddVotingConfigExclusionsRequest)request, (ClusterState)currentState, (int)maxVotingConfigExclusions);
        return VotingConfigExclusionsHelper.addExclusionAndGetState((ClusterState)currentState, (Set)resolvedExclusion, (int)maxVotingConfigExclusions);
    }

    static Set<DiscoveryNode> filterNodesWithDecommissionAttribute(ClusterState clusterState, DecommissionAttribute decommissionAttribute, boolean onlyClusterManagerNodes) {
        Iterator nodesIter;
        HashSet<DiscoveryNode> nodesWithDecommissionAttribute = new HashSet<DiscoveryNode>();
        Iterator iterator = nodesIter = onlyClusterManagerNodes ? clusterState.nodes().getClusterManagerNodes().values().iterator() : clusterState.nodes().getNodes().values().iterator();
        while (nodesIter.hasNext()) {
            DiscoveryNode node = (DiscoveryNode)nodesIter.next();
            if (!DecommissionHelper.nodeHasDecommissionedAttribute(node, decommissionAttribute)) continue;
            nodesWithDecommissionAttribute.add(node);
        }
        return nodesWithDecommissionAttribute;
    }

    public static boolean nodeHasDecommissionedAttribute(DiscoveryNode discoveryNode, DecommissionAttribute decommissionAttribute) {
        String nodeAttributeValue = (String)discoveryNode.getAttributes().get(decommissionAttribute.attributeName());
        return nodeAttributeValue != null && nodeAttributeValue.equals(decommissionAttribute.attributeValue());
    }

    public static boolean nodeCommissioned(DiscoveryNode discoveryNode, Metadata metadata) {
        DecommissionAttributeMetadata decommissionAttributeMetadata = metadata.decommissionAttributeMetadata();
        if (decommissionAttributeMetadata != null) {
            DecommissionAttribute decommissionAttribute = decommissionAttributeMetadata.decommissionAttribute();
            DecommissionStatus status = decommissionAttributeMetadata.status();
            if (decommissionAttribute != null && status != null && DecommissionHelper.nodeHasDecommissionedAttribute(discoveryNode, decommissionAttribute) && (status.equals((Object)DecommissionStatus.IN_PROGRESS) || status.equals((Object)DecommissionStatus.SUCCESSFUL) || status.equals((Object)DecommissionStatus.DRAINING))) {
                return false;
            }
        }
        return true;
    }
}

