/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import io.skylite.common.Booleans;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;

public final class AutoExpandReplicas {
    private static final String ALL_NODES_VALUE = "all";
    private static final AutoExpandReplicas FALSE_INSTANCE = new AutoExpandReplicas(0, 0, false);
    public static final Setting<AutoExpandReplicas> SETTING = new Setting("index.auto_expand_replicas", "false", AutoExpandReplicas::parse, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    private final int minReplicas;
    private final int maxReplicas;
    private final boolean enabled;

    private static AutoExpandReplicas parse(String value) {
        int max;
        int min;
        if (Booleans.isFalse((String)value)) {
            return FALSE_INSTANCE;
        }
        int dash = value.indexOf(45);
        if (-1 == dash) {
            throw new IllegalArgumentException("failed to parse [index.auto_expand_replicas] from value: [" + value + "] at index " + dash);
        }
        String sMin = value.substring(0, dash);
        try {
            min = Integer.parseInt(sMin);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("failed to parse [index.auto_expand_replicas] from value: [" + value + "] at index " + dash, e);
        }
        String sMax = value.substring(dash + 1);
        if (sMax.equals(ALL_NODES_VALUE)) {
            max = Integer.MAX_VALUE;
        } else {
            try {
                max = Integer.parseInt(sMax);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse [index.auto_expand_replicas] from value: [" + value + "] at index " + dash, e);
            }
        }
        return new AutoExpandReplicas(min, max, true);
    }

    private AutoExpandReplicas(int minReplicas, int maxReplicas, boolean enabled) {
        if (minReplicas > maxReplicas) {
            throw new IllegalArgumentException("[index.auto_expand_replicas] minReplicas must be =< maxReplicas but wasn't " + minReplicas + " > " + maxReplicas);
        }
        this.minReplicas = minReplicas;
        this.maxReplicas = maxReplicas;
        this.enabled = enabled;
    }

    int getMinReplicas() {
        return this.minReplicas;
    }

    int getMaxReplicas(int numDataNodes) {
        return Math.min(this.maxReplicas, numDataNodes - 1);
    }

    public int getMaxReplicas() {
        return this.maxReplicas;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private OptionalInt getDesiredNumberOfReplicas(IndexMetadata indexMetadata, RoutingAllocation allocation) {
        if (this.enabled) {
            int numMatchingDataNodes = 0;
            for (DiscoveryNode cursor : allocation.nodes().getDataNodes().values()) {
                Decision decision = allocation.deciders().shouldAutoExpandToNode(indexMetadata, cursor, allocation);
                if (decision.type() == Decision.Type.NO) continue;
                ++numMatchingDataNodes;
            }
            int min = this.getMinReplicas();
            int max = this.getMaxReplicas(numMatchingDataNodes);
            int numberOfReplicas = numMatchingDataNodes - 1;
            if (numberOfReplicas < min) {
                numberOfReplicas = min;
            } else if (numberOfReplicas > max) {
                numberOfReplicas = max;
            }
            if (numberOfReplicas >= min && numberOfReplicas <= max) {
                return OptionalInt.of(numberOfReplicas);
            }
        }
        return OptionalInt.empty();
    }

    public String toString() {
        return this.enabled ? this.minReplicas + "-" + this.maxReplicas : "false";
    }

    public static Map<Integer, List<String>> getAutoExpandReplicaChanges(Metadata metadata, RoutingAllocation allocation) {
        HashMap<Integer, List<String>> nrReplicasChanged = new HashMap<Integer, List<String>>();
        for (IndexMetadata indexMetadata : metadata) {
            if (indexMetadata.getState() != IndexMetadata.State.OPEN && !IndexMetadata.isIndexVerifiedBeforeClosed((IndexMetadata)indexMetadata)) continue;
            AutoExpandReplicas autoExpandReplicas = (AutoExpandReplicas)SETTING.get(indexMetadata.getSettings());
            autoExpandReplicas.getDesiredNumberOfReplicas(indexMetadata, allocation).ifPresent(numberOfReplicas -> {
                if (numberOfReplicas != indexMetadata.getNumberOfReplicas()) {
                    nrReplicasChanged.computeIfAbsent(numberOfReplicas, ArrayList::new).add(indexMetadata.getIndex().getName());
                }
            });
        }
        return nrReplicasChanged;
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(SETTING);
        }
    }
}

