/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import io.skylite.ResourceAlreadyExistsException;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.support.ActiveShardsObserver;
import io.skylite.core.cluster.AckedRequest;
import io.skylite.core.cluster.metadata.ComposableIndexTemplate;
import io.skylite.core.cluster.metadata.DataStream;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.MetadataIndexTemplateUtility;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.AckedClusterStateUpdateTask;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateRequest;
import io.skylite.core.cluster.state.ClusterStateUpdateResponse;
import io.skylite.core.common.Priority;
import io.skylite.core.index.Index;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ObjectPath;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;

public class MetadataCreateDataStreamService {
    private static final Logger logger = LogManager.getLogger(MetadataCreateDataStreamService.class);
    private final ClusterService clusterService;
    private final ActiveShardsObserver activeShardsObserver;
    private final MetadataCreateIndexService metadataCreateIndexService;
    private final ClusterManagerTaskThrottler.ThrottlingKey createDataStreamTaskKey;

    public MetadataCreateDataStreamService(ThreadPool threadPool, ClusterService clusterService, MetadataCreateIndexService metadataCreateIndexService) {
        this.clusterService = clusterService;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.metadataCreateIndexService = metadataCreateIndexService;
        this.createDataStreamTaskKey = clusterService.registerClusterManagerTask("create-data-stream", true);
    }

    public void createDataStream(final CreateDataStreamClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> finalListener) {
        final AtomicReference firstBackingIndexRef = new AtomicReference();
        ActionListener listener = ActionListenerHelper.wrap(response -> {
            if (response.isAcknowledged()) {
                String firstBackingIndexName = (String)firstBackingIndexRef.get();
                assert (firstBackingIndexName != null);
                this.activeShardsObserver.waitForActiveShards(new String[]{firstBackingIndexName}, ActiveShardCount.DEFAULT, request.masterNodeTimeout(), shardsAcked -> finalListener.onResponse((Object)new AcknowledgedResponse(true)), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0));
            } else {
                finalListener.onResponse((Object)new AcknowledgedResponse(false));
            }
        }, arg_0 -> finalListener.onFailure(arg_0));
        this.clusterService.submitStateUpdateTask("create-data-stream [" + request.name + "]", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.HIGH, (AckedRequest)request, listener){

            public ClusterState execute(ClusterState currentState) throws Exception {
                ClusterState clusterState = MetadataCreateDataStreamService.createDataStream(MetadataCreateDataStreamService.this.metadataCreateIndexService, currentState, request);
                firstBackingIndexRef.set(((Index)((DataStream)clusterState.metadata().dataStreams().get(request.name)).getIndices().get(0)).getName());
                return clusterState;
            }

            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return MetadataCreateDataStreamService.this.createDataStreamTaskKey;
            }

            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }
        });
    }

    public ClusterState createDataStream(CreateDataStreamClusterStateUpdateRequest request, ClusterState current) throws Exception {
        return MetadataCreateDataStreamService.createDataStream(this.metadataCreateIndexService, current, request);
    }

    static ClusterState createDataStream(MetadataCreateIndexService metadataCreateIndexService, ClusterState currentState, CreateDataStreamClusterStateUpdateRequest request) throws Exception {
        if (currentState.metadata().dataStreams().containsKey(request.name)) {
            throw new ResourceAlreadyExistsException("data_stream [" + request.name + "] already exists", new Object[0]);
        }
        MetadataCreateIndexService.validateIndexOrAliasName(request.name, (s1, s2) -> new IllegalArgumentException("data_stream [" + s1 + "] " + s2));
        if (!request.name.toLowerCase(Locale.ROOT).equals(request.name)) {
            throw new IllegalArgumentException("data_stream [" + request.name + "] must be lowercase");
        }
        if (request.name.startsWith(".")) {
            throw new IllegalArgumentException("data_stream [" + request.name + "] must not start with '.'");
        }
        ComposableIndexTemplate template = MetadataCreateDataStreamService.lookupTemplateForDataStream(request.name, currentState.metadata());
        String firstBackingIndexName = DataStream.getDefaultBackingIndexName((String)request.name, (long)1L);
        CreateIndexClusterStateUpdateRequest createIndexRequest = new CreateIndexClusterStateUpdateRequest("initialize_data_stream", firstBackingIndexName, firstBackingIndexName).dataStreamName(request.name).settings(Settings.builder().put("index.hidden", true).build());
        try {
            currentState = metadataCreateIndexService.applyCreateIndexRequest(currentState, createIndexRequest, false);
        }
        catch (ResourceAlreadyExistsException e) {
            throw new SkyliteStatusException("data stream could not be created because backing index [{}] already exists", RestStatus.BAD_REQUEST, (Throwable)e, new Object[]{firstBackingIndexName});
        }
        IndexMetadata firstBackingIndex = currentState.metadata().index(firstBackingIndexName);
        assert (firstBackingIndex != null);
        assert (firstBackingIndex.mapping() != null) : "no mapping found for backing index [" + firstBackingIndexName + "]";
        String fieldName = template.getDataStreamTemplate().getTimestampField().getName();
        DataStream.TimestampField timestampField = new DataStream.TimestampField(fieldName);
        DataStream newDataStream = new DataStream(request.name, timestampField, Collections.singletonList(firstBackingIndex.getIndex()));
        Metadata.Builder builder = Metadata.builder((Metadata)currentState.metadata()).put(newDataStream);
        logger.info("adding data stream [{}]", (Object)request.name);
        return ClusterState.builder((ClusterState)currentState).metadata(builder).build();
    }

    public static ComposableIndexTemplate lookupTemplateForDataStream(String dataStreamName, Metadata metadata) {
        String v2Template = MetadataIndexTemplateUtility.findV2Template((Metadata)metadata, (String)dataStreamName, (boolean)false);
        if (v2Template == null) {
            throw new IllegalArgumentException("no matching index template found for data stream [" + dataStreamName + "]");
        }
        ComposableIndexTemplate composableIndexTemplate = (ComposableIndexTemplate)metadata.templatesV2().get(v2Template);
        if (composableIndexTemplate.getDataStreamTemplate() == null) {
            throw new IllegalArgumentException("matching index template [" + v2Template + "] for data stream [" + dataStreamName + "] has no data stream template");
        }
        return composableIndexTemplate;
    }

    public static void validateTimestampFieldMapping(MapperService mapperService) throws IOException {
        MetadataFieldMapper fieldMapper = (MetadataFieldMapper)mapperService.documentMapper().mappers().getMapper("_data_stream_timestamp");
        assert (fieldMapper != null) : "[_data_stream_timestamp] meta field mapper must exist";
        Map parsedTemplateMapping = MapperService.parseMapping((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (String)mapperService.documentMapper().mappingSource().string());
        Boolean enabled = (Boolean)ObjectPath.eval((String)"_doc._data_stream_timestamp.enabled", (Object)parsedTemplateMapping);
        if (enabled == null || !enabled.booleanValue()) {
            throw new IllegalStateException("[_data_stream_timestamp] meta field has been disabled");
        }
        fieldMapper.validate(mapperService.documentMapper().mappers());
    }

    public static final class CreateDataStreamClusterStateUpdateRequest
    extends ClusterStateUpdateRequest {
        private final String name;

        public CreateDataStreamClusterStateUpdateRequest(String name, TimeValue masterNodeTimeout, TimeValue timeout) {
            this.name = name;
            this.masterNodeTimeout(masterNodeTimeout);
            this.ackTimeout(timeout);
        }
    }
}

