/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.indices.SystemIndices;
import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemIndexMetadataUpgradeService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(SystemIndexMetadataUpgradeService.class);
    private final SystemIndices systemIndices;
    private final ClusterService clusterService;
    private boolean clusterManager = false;
    private volatile Map<String, IndexMetadata> lastIndexMetadataMap = Map.of();
    private volatile boolean updateTaskPending = false;

    public SystemIndexMetadataUpgradeService(SystemIndices systemIndices, ClusterService clusterService) {
        this.systemIndices = systemIndices;
        this.clusterService = clusterService;
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        Map indexMetadataMap;
        if (event.localNodeClusterManager() != this.clusterManager) {
            this.clusterManager = event.localNodeClusterManager();
        }
        if (this.clusterManager && !this.updateTaskPending && this.lastIndexMetadataMap != (indexMetadataMap = event.state().metadata().indices())) {
            for (Map.Entry cursor : indexMetadataMap.entrySet()) {
                if (cursor.getValue() == this.lastIndexMetadataMap.get(cursor.getKey()) || this.systemIndices.isSystemIndex(((IndexMetadata)cursor.getValue()).getIndex()) == ((IndexMetadata)cursor.getValue()).isSystem()) continue;
                this.updateTaskPending = true;
                this.clusterService.submitStateUpdateTask("system_index_metadata_upgrade_service {system metadata change}", (ClusterStateTaskConfig)new SystemIndexMetadataUpdateTask());
                break;
            }
        }
    }

    public class SystemIndexMetadataUpdateTask
    extends ClusterStateUpdateTask {
        public ClusterState execute(ClusterState currentState) throws Exception {
            Map indexMetadataMap = currentState.metadata().indices();
            ArrayList<IndexMetadata> updatedMetadata = new ArrayList<IndexMetadata>();
            for (Map.Entry cursor : indexMetadataMap.entrySet()) {
                if (cursor.getValue() == SystemIndexMetadataUpgradeService.this.lastIndexMetadataMap.get(cursor.getKey()) || SystemIndexMetadataUpgradeService.this.systemIndices.isSystemIndex(((IndexMetadata)cursor.getValue()).getIndex()) == ((IndexMetadata)cursor.getValue()).isSystem()) continue;
                updatedMetadata.add(IndexMetadata.builder((IndexMetadata)((IndexMetadata)cursor.getValue())).system(!((IndexMetadata)cursor.getValue()).isSystem()).build());
            }
            if (!updatedMetadata.isEmpty()) {
                Metadata.Builder builder = Metadata.builder((Metadata)currentState.metadata());
                updatedMetadata.forEach(idxMeta -> builder.put(idxMeta, true));
                return ClusterState.builder((ClusterState)currentState).metadata(builder).build();
            }
            return currentState;
        }

        public void onFailure(String source, Exception e) {
            SystemIndexMetadataUpgradeService.this.updateTaskPending = false;
            logger.error("failed to update system index metadata", (Throwable)e);
        }

        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            SystemIndexMetadataUpgradeService.this.lastIndexMetadataMap = newState.metadata().indices();
            SystemIndexMetadataUpgradeService.this.updateTaskPending = false;
        }
    }
}

