/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import io.skylite.SkyliteException;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.cluster.NotClusterManagerException;
import io.skylite.core.cluster.routing.RerouteService;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.common.Priority;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class BatchedRerouteService
implements RerouteService {
    private static final Logger logger = LogManager.getLogger(BatchedRerouteService.class);
    private static final String CLUSTER_UPDATE_TASK_SOURCE = "cluster_reroute";
    private final ClusterService clusterService;
    private final BiFunction<ClusterState, String, ClusterState> reroute;
    private final Object mutex = new Object();
    @Nullable
    private List<ActionListener<ClusterState>> pendingRerouteListeners;
    private Priority pendingTaskPriority = Priority.LANGUID;

    public BatchedRerouteService(ClusterService clusterService, BiFunction<ClusterState, String, ClusterState> reroute) {
        this.clusterService = clusterService;
        this.reroute = reroute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reroute(final String reason, Priority priority, ActionListener<ClusterState> listener) {
        ArrayList<Object> currentListeners;
        Object object = this.mutex;
        synchronized (object) {
            if (this.pendingRerouteListeners != null) {
                if (priority.sameOrAfter(this.pendingTaskPriority)) {
                    logger.trace("already has pending reroute at priority [{}], adding [{}] with priority [{}] to batch", (Object)this.pendingTaskPriority, (Object)reason, (Object)priority);
                    this.pendingRerouteListeners.add(listener);
                    return;
                }
                logger.trace("already has pending reroute at priority [{}], promoting batch to [{}] and adding [{}]", (Object)this.pendingTaskPriority, (Object)priority, (Object)reason);
                currentListeners = new ArrayList(1 + this.pendingRerouteListeners.size());
                currentListeners.add(listener);
                currentListeners.addAll(this.pendingRerouteListeners);
                this.pendingRerouteListeners.clear();
                this.pendingRerouteListeners = currentListeners;
                this.pendingTaskPriority = priority;
            } else {
                logger.trace("no pending reroute, scheduling reroute [{}] at priority [{}]", (Object)reason, (Object)priority);
                currentListeners = new ArrayList<ActionListener<ClusterState>>(1);
                currentListeners.add(listener);
                this.pendingRerouteListeners = currentListeners;
                this.pendingTaskPriority = priority;
            }
        }
        try {
            this.clusterService.submitStateUpdateTask("cluster_reroute(" + reason + ")", (ClusterStateTaskConfig)new ClusterStateUpdateTask(priority){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public ClusterState execute(ClusterState currentState) {
                    boolean currentListenersArePending;
                    Object object = BatchedRerouteService.this.mutex;
                    synchronized (object) {
                        assert (currentListeners.isEmpty() == (BatchedRerouteService.this.pendingRerouteListeners != currentListeners)) : "currentListeners=" + String.valueOf(currentListeners) + ", pendingRerouteListeners=" + String.valueOf(BatchedRerouteService.this.pendingRerouteListeners);
                        boolean bl = currentListenersArePending = BatchedRerouteService.this.pendingRerouteListeners == currentListeners;
                        if (currentListenersArePending) {
                            BatchedRerouteService.this.pendingRerouteListeners = null;
                        }
                    }
                    if (currentListenersArePending) {
                        logger.trace("performing batched reroute [{}]", (Object)reason);
                        return BatchedRerouteService.this.reroute.apply(currentState, reason);
                    }
                    logger.trace("batched reroute [{}] was promoted", (Object)reason);
                    return currentState;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onNoLongerClusterManager(String source) {
                    Object object = BatchedRerouteService.this.mutex;
                    synchronized (object) {
                        if (BatchedRerouteService.this.pendingRerouteListeners == currentListeners) {
                            BatchedRerouteService.this.pendingRerouteListeners = null;
                        }
                    }
                    ActionListenerHelper.onFailure((Iterable)currentListeners, (Exception)new NotClusterManagerException("delayed reroute [" + reason + "] cancelled"));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(String source, Exception e) {
                    Object object = BatchedRerouteService.this.mutex;
                    synchronized (object) {
                        if (BatchedRerouteService.this.pendingRerouteListeners == currentListeners) {
                            BatchedRerouteService.this.pendingRerouteListeners = null;
                        }
                    }
                    ClusterState state = BatchedRerouteService.this.clusterService.state();
                    if (logger.isTraceEnabled()) {
                        logger.error(() -> new ParameterizedMessage("unexpected failure during [{}], current state:\n{}", (Object)source, (Object)state), (Throwable)e);
                    } else {
                        logger.error(() -> new ParameterizedMessage("unexpected failure during [{}], current state version [{}]", (Object)source, (Object)state.version()), (Throwable)e);
                    }
                    ActionListenerHelper.onFailure((Iterable)currentListeners, (Exception)new SkyliteException("delayed reroute [" + reason + "] failed", (Throwable)e, new Object[0]));
                }

                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    ActionListenerHelper.onResponse((Iterable)currentListeners, (Object)newState);
                }
            });
        }
        catch (Exception e) {
            Object object2 = this.mutex;
            synchronized (object2) {
                assert (currentListeners.isEmpty() == (this.pendingRerouteListeners != currentListeners));
                if (this.pendingRerouteListeners == currentListeners) {
                    this.pendingRerouteListeners = null;
                }
            }
            ClusterState state = this.clusterService.state();
            logger.warn(() -> new ParameterizedMessage("failed to reroute routing table, current state:\n{}", (Object)state), (Throwable)e);
            ActionListenerHelper.onFailure(currentListeners, (Exception)new SkyliteException("delayed reroute [" + reason + "] could not be submitted", (Throwable)e, new Object[0]));
        }
    }
}

