/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.index.IndexModuleSettings;
import io.skylite.core.index.store.IndexStoreSettings;
import io.skylite.core.settings.Settings;

public enum RoutingPool {
    LOCAL_ONLY,
    REMOTE_CAPABLE;


    public static RoutingPool getNodePool(RoutingNode node) {
        return RoutingPool.getNodePool(node.node());
    }

    public static RoutingPool getNodePool(DiscoveryNode node) {
        if (node.isSearchNode()) {
            return REMOTE_CAPABLE;
        }
        return LOCAL_ONLY;
    }

    public static RoutingPool getShardPool(ShardRouting shard, RoutingAllocation allocation) {
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shard.index());
        return RoutingPool.getIndexPool(indexMetadata);
    }

    public static RoutingPool getIndexPool(IndexMetadata indexMetadata) {
        Settings indexSettings = indexMetadata.getSettings();
        if (IndexModuleSettings.Type.REMOTE_SNAPSHOT.match(indexSettings.get(IndexStoreSettings.INDEX_STORE_TYPE_SETTING.getKey()))) {
            return REMOTE_CAPABLE;
        }
        return LOCAL_ONLY;
    }
}

