/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import io.skylite.ResourceNotFoundException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.admin.cluster.shards.routing.weighted.delete.ClusterDeleteWeightedRoutingRequest;
import io.skylite.core.action.admin.cluster.shards.routing.weighted.delete.ClusterDeleteWeightedRoutingResponse;
import io.skylite.core.action.admin.cluster.shards.routing.weighted.put.ClusterPutWeightedRoutingRequest;
import io.skylite.core.cluster.decommission.DecommissionAttribute;
import io.skylite.core.cluster.decommission.DecommissionAttributeMetadata;
import io.skylite.core.cluster.decommission.DecommissionStatus;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.WeightedRoutingMetadata;
import io.skylite.core.cluster.routing.WeightedRouting;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDeciderSettings;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateResponse;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.common.Priority;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.routing.UnsupportedWeightedRoutingStateException;

public class WeightedRoutingService {
    private static final Logger logger = LogManager.getLogger(WeightedRoutingService.class);
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private volatile List<String> awarenessAttributes;
    private volatile Map<String, List<String>> forcedAwarenessAttributes;
    private static final Double DECOMMISSIONED_AWARENESS_VALUE_WEIGHT = 0.0;

    @Inject
    public WeightedRoutingService(ClusterService clusterService, ThreadPool threadPool, Settings settings, ClusterSettings clusterSettings) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.awarenessAttributes = (List)AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
        this.setForcedAwarenessAttributes((Settings)AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING, this::setForcedAwarenessAttributes);
    }

    public void registerWeightedRoutingMetadata(final ClusterPutWeightedRoutingRequest request, final ActionListener<ClusterStateUpdateResponse> listener) {
        final WeightedRouting newWeightedRouting = new WeightedRouting(request.getWeightedRouting());
        final long requestVersion = request.getVersion();
        this.clusterService.submitStateUpdateTask("update_weighted_routing", (ClusterStateTaskConfig)new ClusterStateUpdateTask(Priority.URGENT){

            public ClusterState execute(ClusterState currentState) {
                WeightedRoutingService.this.ensureWeightsSetForAllDiscoveredAndForcedAwarenessValues(currentState, request);
                WeightedRoutingService.this.ensureDecommissionedAttributeHasZeroWeight(currentState, request);
                Metadata metadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentState.metadata());
                WeightedRoutingMetadata weightedRoutingMetadata = (WeightedRoutingMetadata)metadata.custom("weighted_shard_routing");
                WeightedRoutingService.this.ensureNoVersionConflict(requestVersion, weightedRoutingMetadata);
                if (weightedRoutingMetadata == null) {
                    logger.info("add weighted routing weights in metadata [{}]", (Object)newWeightedRouting);
                    weightedRoutingMetadata = new WeightedRoutingMetadata(newWeightedRouting, requestVersion + 1L);
                } else if (!newWeightedRouting.equals((Object)weightedRoutingMetadata.getWeightedRouting())) {
                    logger.info("updated weighted routing weights [{}] in metadata", (Object)newWeightedRouting);
                    weightedRoutingMetadata = new WeightedRoutingMetadata(newWeightedRouting, requestVersion + 1L);
                } else {
                    logger.info("weights are same, not updating weighted routing weights [{}] in metadata", (Object)newWeightedRouting);
                    return currentState;
                }
                mdBuilder.putCustom("weighted_shard_routing", (Metadata.Custom)weightedRoutingMetadata);
                logger.info("building cluster state with weighted routing weights [{}]", (Object)newWeightedRouting);
                return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
            }

            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to update cluster state for weighted routing weights [{}]", (Object)e));
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                logger.debug("cluster weighted routing weights metadata change is processed by all the nodes");
                listener.onResponse((Object)new ClusterStateUpdateResponse(true));
            }
        });
    }

    public void deleteWeightedRoutingMetadata(ClusterDeleteWeightedRoutingRequest request, final ActionListener<ClusterDeleteWeightedRoutingResponse> listener) {
        final long requestVersion = request.getVersion();
        final String awarenessAttribute = request.getAwarenessAttribute();
        this.clusterService.submitStateUpdateTask("delete_weighted_routing", (ClusterStateTaskConfig)new ClusterStateUpdateTask(Priority.URGENT){

            public ClusterState execute(ClusterState currentState) {
                logger.info("Deleting weighted routing metadata from the cluster state");
                Metadata metadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentState.metadata());
                WeightedRoutingMetadata weightedRoutingMetadata = (WeightedRoutingMetadata)metadata.custom("weighted_shard_routing");
                WeightedRoutingService.this.ensureNoVersionConflict(requestVersion, weightedRoutingMetadata);
                if (!(weightedRoutingMetadata != null && awarenessAttribute == null || weightedRoutingMetadata != null && weightedRoutingMetadata.getWeightedRouting().attributeName().equals(awarenessAttribute))) {
                    throw new ResourceNotFoundException(String.format(Locale.ROOT, "weighted routing metadata does not have weights set for awareness attribute %s", awarenessAttribute), new Object[0]);
                }
                weightedRoutingMetadata = new WeightedRoutingMetadata(new WeightedRouting(), weightedRoutingMetadata.getVersion() + 1L);
                mdBuilder.putCustom("weighted_shard_routing", (Metadata.Custom)weightedRoutingMetadata);
                logger.info("building cluster state with weighted routing weights deleted");
                return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
            }

            public void onFailure(String source, Exception e) {
                logger.error("failed to remove weighted routing metadata from cluster state", (Throwable)e);
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                logger.debug("cluster weighted routing metadata change is processed by all the nodes");
                listener.onResponse((Object)new ClusterDeleteWeightedRoutingResponse(true));
            }
        });
    }

    List<String> getAwarenessAttributes() {
        return this.awarenessAttributes;
    }

    private void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
    }

    private void setForcedAwarenessAttributes(Settings forceSettings) {
        HashMap<String, List<String>> forcedAwarenessAttributes = new HashMap<String, List<String>>();
        Map forceGroups = forceSettings.getAsGroups();
        for (Map.Entry entry : forceGroups.entrySet()) {
            List aValues = ((Settings)entry.getValue()).getAsList("values");
            if (aValues.size() <= 0) continue;
            forcedAwarenessAttributes.put((String)entry.getKey(), aValues);
        }
        this.forcedAwarenessAttributes = forcedAwarenessAttributes;
    }

    public void verifyAwarenessAttribute(String attributeName) {
        if (!this.getAwarenessAttributes().contains(attributeName)) {
            ActionRequestValidationException validationException = null;
            validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "invalid awareness attribute %s requested for weighted routing", attributeName), validationException);
            throw validationException;
        }
    }

    private void ensureWeightsSetForAllDiscoveredAndForcedAwarenessValues(ClusterState state, ClusterPutWeightedRoutingRequest request) {
        String attributeName = request.getWeightedRouting().attributeName();
        Set nodesPerAttribute = state.getRoutingNodes().nodesPerAttributesCounts(attributeName);
        HashSet<String> discoveredAwarenessValues = new HashSet<String>();
        for (String stringObjectCursor : nodesPerAttribute) {
            if (stringObjectCursor == null) continue;
            discoveredAwarenessValues.add(stringObjectCursor);
        }
        HashSet<String> allAwarenessValues = this.forcedAwarenessAttributes.get(attributeName) == null ? new HashSet<String>() : new HashSet(this.forcedAwarenessAttributes.get(attributeName));
        allAwarenessValues.addAll(discoveredAwarenessValues);
        AtomicInteger countWithZeroWeight = new AtomicInteger();
        allAwarenessValues.forEach(awarenessValue -> {
            if (!request.getWeightedRouting().weights().containsKey(awarenessValue)) {
                throw new UnsupportedWeightedRoutingStateException("weight for [" + awarenessValue + "] is not set and it is part of forced awareness value or a routing node has this attribute.", new Object[0]);
            }
            if ((Double)request.getWeightedRouting().weights().get(awarenessValue) == 0.0) {
                countWithZeroWeight.addAndGet(1);
            }
        });
        if (countWithZeroWeight.get() > allAwarenessValues.size() / 2) {
            throw ValidateActions.addValidationError((String)String.format(Locale.ROOT, "There are too many discovered attribute values [%s] given zero weight [%d]. Maximum expected number of routing weights having zero weight is [%d]", request.getWeightedRouting().weights().toString(), countWithZeroWeight.get(), allAwarenessValues.size() / 2), null);
        }
    }

    private void ensureDecommissionedAttributeHasZeroWeight(ClusterState state, ClusterPutWeightedRoutingRequest request) {
        DecommissionAttributeMetadata decommissionAttributeMetadata = state.metadata().decommissionAttributeMetadata();
        if (decommissionAttributeMetadata == null || decommissionAttributeMetadata.status().equals((Object)DecommissionStatus.FAILED)) {
            return;
        }
        DecommissionAttribute decommissionAttribute = decommissionAttributeMetadata.decommissionAttribute();
        WeightedRouting weightedRouting = request.getWeightedRouting();
        if (!weightedRouting.attributeName().equals(decommissionAttribute.attributeName())) {
            throw new UnsupportedWeightedRoutingStateException("decommission action ongoing for attribute [{}], cannot update weight for [{}]", decommissionAttribute.attributeName(), weightedRouting.attributeName());
        }
        if (!weightedRouting.weights().containsKey(decommissionAttribute.attributeValue())) {
            throw new UnsupportedWeightedRoutingStateException("weight for [{}] is not specified. Please specify its weight to [{}] as it is under decommission action", decommissionAttribute.attributeValue(), DECOMMISSIONED_AWARENESS_VALUE_WEIGHT);
        }
        if (!Objects.equals(weightedRouting.weights().get(decommissionAttribute.attributeValue()), DECOMMISSIONED_AWARENESS_VALUE_WEIGHT)) {
            throw new UnsupportedWeightedRoutingStateException("weight for [{}] must be set to [{}] as it is under decommission action", decommissionAttribute.attributeValue(), DECOMMISSIONED_AWARENESS_VALUE_WEIGHT);
        }
    }

    private void ensureNoVersionConflict(long requestedVersion, WeightedRoutingMetadata weightedRoutingMetadata) {
        if (weightedRoutingMetadata == null && requestedVersion != -1L || weightedRoutingMetadata != null && requestedVersion != weightedRoutingMetadata.getVersion()) {
            throw new UnsupportedWeightedRoutingStateException(String.format(Locale.ROOT, "requested version is %s but cluster weighted routing metadata is at a different version %s ", requestedVersion, weightedRoutingMetadata != null ? weightedRoutingMetadata.getVersion() : -1L), new Object[0]);
        }
    }
}

