/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import io.skylite.common.action.ActionListener;
import io.skylite.common.util.set.Sets;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.GroupedActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.ClusterInfo;
import io.skylite.core.cluster.DiskUsage;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.routing.RerouteService;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.RoutingNodes;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.Priority;
import io.skylite.core.common.Strings;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.routing.allocation.DiskThresholdSettings;
import org.opensearch.cluster.routing.allocation.decider.DiskThresholdDecider;

public class DiskThresholdMonitor {
    private static final Logger logger = LogManager.getLogger(DiskThresholdMonitor.class);
    private final DiskThresholdSettings diskThresholdSettings;
    private final Client client;
    private final Supplier<ClusterState> clusterStateSupplier;
    private final LongSupplier currentTimeMillisSupplier;
    private final RerouteService rerouteService;
    private final AtomicLong lastRunTimeMillis = new AtomicLong(Long.MIN_VALUE);
    private final AtomicBoolean checkInProgress = new AtomicBoolean();
    private final Set<String> nodesOverLowThreshold = Sets.newConcurrentHashSet();
    private final Set<String> nodesOverHighThreshold = Sets.newConcurrentHashSet();
    private final Set<String> nodesOverHighThresholdAndRelocating = Sets.newConcurrentHashSet();

    public DiskThresholdMonitor(Settings settings, Supplier<ClusterState> clusterStateSupplier, ClusterSettings clusterSettings, Client client, LongSupplier currentTimeMillisSupplier, RerouteService rerouteService) {
        this.clusterStateSupplier = clusterStateSupplier;
        this.currentTimeMillisSupplier = currentTimeMillisSupplier;
        this.rerouteService = rerouteService;
        this.diskThresholdSettings = new DiskThresholdSettings(settings, clusterSettings);
        this.client = client;
    }

    private void checkFinished() {
        boolean checkFinished = this.checkInProgress.compareAndSet(true, false);
        assert (checkFinished);
        logger.trace("checkFinished");
    }

    public void onNewInfo(ClusterInfo info) {
        if (!this.checkInProgress.compareAndSet(false, true)) {
            logger.info("skipping monitor as a check is already in progress");
            return;
        }
        Map usages = info.getNodeLeastAvailableDiskUsages();
        if (usages == null) {
            logger.trace("skipping monitor as no disk usage information is available");
            this.checkFinished();
            return;
        }
        logger.trace("processing new cluster info");
        boolean reroute = false;
        String explanation = "";
        long currentTimeMillis = this.currentTimeMillisSupplier.getAsLong();
        Set<String> nodes = usages.keySet();
        DiskThresholdMonitor.cleanUpRemovedNodes(nodes, this.nodesOverLowThreshold);
        DiskThresholdMonitor.cleanUpRemovedNodes(nodes, this.nodesOverHighThreshold);
        DiskThresholdMonitor.cleanUpRemovedNodes(nodes, this.nodesOverHighThresholdAndRelocating);
        ClusterState state = this.clusterStateSupplier.get();
        HashSet<String> indicesToMarkReadOnly = new HashSet<String>();
        RoutingNodes routingNodes = state.getRoutingNodes();
        HashSet<String> indicesNotToAutoRelease = new HashSet<String>();
        this.markNodesMissingUsageIneligibleForRelease(routingNodes, usages, indicesNotToAutoRelease);
        ArrayList<DiskUsage> usagesOverHighThreshold = new ArrayList<DiskUsage>();
        for (Map.Entry entry : usages.entrySet()) {
            String indexName;
            String node = (String)entry.getKey();
            DiskUsage usage = (DiskUsage)entry.getValue();
            RoutingNode routingNode = routingNodes.node(node);
            if (usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdFloodStage().getBytes() || usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdFloodStage()) {
                this.nodesOverLowThreshold.add(node);
                this.nodesOverHighThreshold.add(node);
                this.nodesOverHighThresholdAndRelocating.remove(node);
                if (routingNode != null) {
                    for (ShardRouting routing : routingNode) {
                        indexName = routing.index().getName();
                        indicesToMarkReadOnly.add(indexName);
                        indicesNotToAutoRelease.add(indexName);
                    }
                }
                logger.warn("flood stage disk watermark [{}] exceeded on {}, all indices on this node will be marked read-only", (Object)this.diskThresholdSettings.describeFloodStageThreshold(), (Object)usage);
                continue;
            }
            if ((usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes() || usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdHigh()) && routingNode != null) {
                for (ShardRouting routing : routingNode) {
                    indexName = routing.index().getName();
                    indicesNotToAutoRelease.add(indexName);
                }
            }
            long reservedSpace = info.getReservedSpace(usage.getNodeId(), usage.getPath()).getTotal();
            DiskUsage usageWithReservedSpace = new DiskUsage(usage.getNodeId(), usage.getNodeName(), usage.getPath(), usage.getTotalBytes(), Math.max(0L, usage.getFreeBytes() - reservedSpace));
            if (usageWithReservedSpace.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes() || usageWithReservedSpace.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdHigh()) {
                this.nodesOverLowThreshold.add(node);
                this.nodesOverHighThreshold.add(node);
                if (this.lastRunTimeMillis.get() <= currentTimeMillis - this.diskThresholdSettings.getRerouteInterval().millis()) {
                    reroute = true;
                    explanation = "high disk watermark exceeded on one or more nodes";
                    usagesOverHighThreshold.add(usage);
                    continue;
                }
                logger.debug("high disk watermark exceeded on {} but an automatic reroute has occurred in the last [{}], skipping reroute", (Object)node, (Object)this.diskThresholdSettings.getRerouteInterval());
                continue;
            }
            if (usageWithReservedSpace.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdLow().getBytes() || usageWithReservedSpace.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdLow()) {
                this.nodesOverHighThresholdAndRelocating.remove(node);
                boolean wasUnderLowThreshold = this.nodesOverLowThreshold.add(node);
                boolean wasOverHighThreshold = this.nodesOverHighThreshold.remove(node);
                assert (!(wasUnderLowThreshold && wasOverHighThreshold));
                if (wasUnderLowThreshold) {
                    logger.info("low disk watermark [{}] exceeded on {}, replicas will not be assigned to this node", (Object)this.diskThresholdSettings.describeLowThreshold(), (Object)usage);
                    continue;
                }
                if (!wasOverHighThreshold) continue;
                logger.info("high disk watermark [{}] no longer exceeded on {}, but low disk watermark [{}] is still exceeded", (Object)this.diskThresholdSettings.describeHighThreshold(), (Object)usage, (Object)this.diskThresholdSettings.describeLowThreshold());
                continue;
            }
            this.nodesOverHighThresholdAndRelocating.remove(node);
            if (!this.nodesOverLowThreshold.contains(node)) continue;
            if (this.lastRunTimeMillis.get() <= currentTimeMillis - this.diskThresholdSettings.getRerouteInterval().millis()) {
                reroute = true;
                explanation = "one or more nodes has gone under the high or low watermark";
                this.nodesOverLowThreshold.remove(node);
                this.nodesOverHighThreshold.remove(node);
                logger.info("low disk watermark [{}] no longer exceeded on {}", (Object)this.diskThresholdSettings.describeLowThreshold(), (Object)usage);
                continue;
            }
            logger.debug("{} has gone below a disk threshold, but an automatic reroute has occurred in the last [{}], skipping reroute", (Object)node, (Object)this.diskThresholdSettings.getRerouteInterval());
        }
        GroupedActionListener listener = new GroupedActionListener(ActionListenerHelper.wrap(this::checkFinished), 4);
        if (reroute) {
            logger.debug("rerouting shards: [{}]", (Object)explanation);
            this.rerouteService.reroute("disk threshold monitor", Priority.HIGH, ActionListenerHelper.wrap(arg_0 -> this.lambda$onNewInfo$0(usagesOverHighThreshold, info, (ActionListener)listener, arg_0), arg_0 -> this.lambda$onNewInfo$1((ActionListener)listener, arg_0)));
        } else {
            logger.trace("no reroute required");
            listener.onResponse(null);
        }
        Set<String> indicesToAutoRelease = StreamSupport.stream(Spliterators.spliterator(state.routingTable().indicesRouting().entrySet(), 0), false).map(c -> (String)c.getKey()).filter(index -> !indicesNotToAutoRelease.contains(index)).filter(index -> state.getBlocks().hasIndexBlock(index, IndexMetadata.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK)).collect(Collectors.toSet());
        if (!indicesToAutoRelease.isEmpty()) {
            this.updateIndicesReadOnly(indicesToAutoRelease, (ActionListener<Void>)listener, false);
        } else {
            logger.trace("no auto-release required");
            listener.onResponse(null);
        }
        indicesToMarkReadOnly.removeIf(index -> state.getBlocks().indexBlocked(ClusterBlockLevel.WRITE, index));
        logger.trace("marking indices as read-only: [{}]", indicesToMarkReadOnly);
        if (!indicesToMarkReadOnly.isEmpty()) {
            this.updateIndicesReadOnly(indicesToMarkReadOnly, (ActionListener<Void>)listener, true);
        } else {
            listener.onResponse(null);
        }
        if (!state.getBlocks().hasGlobalBlockWithId(Metadata.CLUSTER_CREATE_INDEX_BLOCK.id()) && nodes.size() > 0 && this.nodesOverHighThreshold.size() == nodes.size()) {
            logger.warn("Putting index create block on cluster as all nodes are breaching high disk watermark. Number of nodes above high watermark: {}.", (Object)this.nodesOverHighThreshold.size());
            this.setIndexCreateBlock((ActionListener<Void>)listener, true);
        } else if (state.getBlocks().hasGlobalBlockWithId(Metadata.CLUSTER_CREATE_INDEX_BLOCK.id()) && this.diskThresholdSettings.isCreateIndexBlockAutoReleaseEnabled() && this.nodesOverHighThreshold.size() < nodes.size()) {
            logger.warn("Removing index create block on cluster as all nodes are no longer breaching high disk watermark. Number of nodes above high watermark: {}. Total numbers of nodes: {}.", (Object)this.nodesOverHighThreshold.size(), (Object)nodes.size());
            this.setIndexCreateBlock((ActionListener<Void>)listener, false);
        } else {
            listener.onResponse(null);
        }
    }

    long sizeOfRelocatingShards(RoutingNode routingNode, DiskUsage diskUsage, ClusterInfo info, ClusterState reroutedClusterState) {
        return DiskThresholdDecider.sizeOfRelocatingShards(routingNode, true, diskUsage.getPath(), info, reroutedClusterState.metadata(), reroutedClusterState.routingTable());
    }

    private void markNodesMissingUsageIneligibleForRelease(RoutingNodes routingNodes, Map<String, DiskUsage> usages, Set<String> indicesToMarkIneligibleForAutoRelease) {
        for (RoutingNode routingNode : routingNodes) {
            if (usages.containsKey(routingNode.nodeId())) continue;
            for (ShardRouting routing : routingNode) {
                String indexName = routing.index().getName();
                indicesToMarkIneligibleForAutoRelease.add(indexName);
            }
        }
    }

    private void setLastRunTimeMillis() {
        this.lastRunTimeMillis.getAndUpdate(l -> Math.max(l, this.currentTimeMillisSupplier.getAsLong()));
    }

    protected void setIndexCreateBlock(ActionListener<Void> listener, boolean indexCreateBlock) {
        ActionListener wrappedListener = ActionListenerHelper.wrap(r -> {
            this.setLastRunTimeMillis();
            listener.onResponse(r);
        }, e -> {
            logger.debug("setting index create block failed", (Throwable)e);
            this.setLastRunTimeMillis();
            listener.onFailure(e);
        });
        Settings indexCreateBlockSetting = indexCreateBlock ? Settings.builder().put(Metadata.SETTING_CREATE_INDEX_BLOCK_SETTING.getKey(), Boolean.TRUE.toString()).build() : Settings.builder().putNull(Metadata.SETTING_CREATE_INDEX_BLOCK_SETTING.getKey()).build();
        this.client.admin().cluster().prepareUpdateSettings().setPersistentSettings(indexCreateBlockSetting).execute(ActionListenerHelper.map((ActionListener)wrappedListener, r -> null));
    }

    protected void updateIndicesReadOnly(Set<String> indicesToUpdate, ActionListener<Void> listener, boolean readOnly) {
        ActionListener wrappedListener = ActionListenerHelper.wrap(r -> {
            this.setLastRunTimeMillis();
            listener.onResponse(r);
        }, e -> {
            logger.debug((Message)new ParameterizedMessage("setting indices [{}] read-only failed", (Object)readOnly), (Throwable)e);
            this.setLastRunTimeMillis();
            listener.onFailure(e);
        });
        Settings readOnlySettings = readOnly ? Settings.builder().put(IndexMetadata.SETTING_READ_ONLY_ALLOW_DELETE, Boolean.TRUE.toString()).build() : Settings.builder().putNull(IndexMetadata.SETTING_READ_ONLY_ALLOW_DELETE).build();
        this.client.admin().indices().prepareUpdateSettings(indicesToUpdate.toArray(Strings.EMPTY_ARRAY)).setSettings(readOnlySettings).execute(ActionListenerHelper.map((ActionListener)wrappedListener, r -> null));
    }

    private static void cleanUpRemovedNodes(Set<String> nodesToKeep, Set<String> nodesToCleanUp) {
        for (String node : nodesToCleanUp) {
            if (nodesToKeep.contains(node)) continue;
            nodesToCleanUp.remove(node);
        }
    }

    private /* synthetic */ void lambda$onNewInfo$1(ActionListener listener, Exception e) {
        logger.debug("reroute failed", (Throwable)e);
        this.setLastRunTimeMillis();
        listener.onFailure(e);
    }

    private /* synthetic */ void lambda$onNewInfo$0(List usagesOverHighThreshold, ClusterInfo info, ActionListener listener, ClusterState reroutedClusterState) throws Exception {
        for (DiskUsage diskUsage : usagesOverHighThreshold) {
            DiskUsage usageIncludingRelocations;
            long relocatingShardsSize;
            RoutingNode routingNode = reroutedClusterState.getRoutingNodes().node(diskUsage.getNodeId());
            if (routingNode != null) {
                relocatingShardsSize = this.sizeOfRelocatingShards(routingNode, diskUsage, info, reroutedClusterState);
                usageIncludingRelocations = new DiskUsage(diskUsage.getNodeId(), diskUsage.getNodeName(), diskUsage.getPath(), diskUsage.getTotalBytes(), diskUsage.getFreeBytes() - relocatingShardsSize);
            } else {
                usageIncludingRelocations = diskUsage;
                relocatingShardsSize = 0L;
            }
            if (usageIncludingRelocations.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes() || usageIncludingRelocations.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdHigh()) {
                this.nodesOverHighThresholdAndRelocating.remove(diskUsage.getNodeId());
                logger.warn("high disk watermark [{}] exceeded on {}, shards will be relocated away from this node; currently relocating away shards totalling [{}] bytes; the node is expected to continue to exceed the high disk watermark when these relocations are complete", (Object)this.diskThresholdSettings.describeHighThreshold(), (Object)diskUsage, (Object)(-relocatingShardsSize));
                continue;
            }
            if (this.nodesOverHighThresholdAndRelocating.add(diskUsage.getNodeId())) {
                logger.info("high disk watermark [{}] exceeded on {}, shards will be relocated away from this node; currently relocating away shards totalling [{}] bytes; the node is expected to be below the high disk watermark when these relocations are complete", (Object)this.diskThresholdSettings.describeHighThreshold(), (Object)diskUsage, (Object)(-relocatingShardsSize));
                continue;
            }
            logger.debug("high disk watermark [{}] exceeded on {}, shards will be relocated away from this node; currently relocating away shards totalling [{}] bytes", (Object)this.diskThresholdSettings.describeHighThreshold(), (Object)diskUsage, (Object)(-relocatingShardsSize));
        }
        this.setLastRunTimeMillis();
        listener.onResponse(null);
    }
}

