/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.command;

import io.skylite.core.ParseField;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.RoutingNodes;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.UnassignedInfo;
import io.skylite.core.cluster.routing.allocation.AllocationCommand;
import io.skylite.core.cluster.routing.allocation.RerouteExplanation;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.shard.ShardNotFoundException;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.opensearch.cluster.routing.allocation.command.BasePrimaryAllocationCommand;

public class AllocateEmptyPrimaryAllocationCommand
extends BasePrimaryAllocationCommand {
    public static final String NAME = "allocate_empty_primary";
    public static final ParseField COMMAND_NAME_FIELD = new ParseField("allocate_empty_primary", new String[0]);
    private static final ObjectParser<Builder, Void> EMPTY_PRIMARY_PARSER = BasePrimaryAllocationCommand.createAllocatePrimaryParser("allocate_empty_primary");

    public AllocateEmptyPrimaryAllocationCommand(String index, int shardId, String node, boolean acceptDataLoss) {
        super(index, shardId, node, acceptDataLoss);
    }

    public AllocateEmptyPrimaryAllocationCommand(StreamInput in) throws IOException {
        super(in);
    }

    public String name() {
        return NAME;
    }

    public Optional<String> getMessage() {
        return Optional.of("allocated an empty primary for [" + this.index + "][" + this.shardId + "] on node [" + this.node + "] from user command");
    }

    public static AllocateEmptyPrimaryAllocationCommand fromXContent(XContentParser parser) throws IOException {
        return new Builder().parse(parser).build();
    }

    public RerouteExplanation execute(RoutingAllocation allocation, boolean explain) {
        DiscoveryNode discoNode;
        try {
            discoNode = allocation.nodes().resolveNode(this.node);
        }
        catch (IllegalArgumentException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, e);
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNode routingNode = routingNodes.node(discoNode.getId());
        if (routingNode == null) {
            return this.explainOrThrowMissingRoutingNode(allocation, explain, discoNode);
        }
        try {
            allocation.routingTable().shardRoutingTable(this.index, this.shardId).primaryShard();
        }
        catch (IndexNotFoundException | ShardNotFoundException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, (RuntimeException)e);
        }
        ShardRouting shardRouting = null;
        for (ShardRouting shard : allocation.routingNodes().unassigned()) {
            if (!shard.getIndexName().equals(this.index) || shard.getId() != this.shardId || !shard.primary()) continue;
            shardRouting = shard;
            break;
        }
        if (shardRouting == null) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "primary [" + this.index + "][" + this.shardId + "] is already assigned");
        }
        if (shardRouting.recoverySource().getType() != RecoverySource.Type.EMPTY_STORE && !this.acceptDataLoss) {
            String dataLossWarning = "allocating an empty primary for [" + this.index + "][" + this.shardId + "] can result in data loss. Please confirm by setting the accept_data_loss parameter to true";
            return this.explainOrThrowRejectedCommand(explain, allocation, dataLossWarning);
        }
        UnassignedInfo unassignedInfoToUpdate = null;
        if (shardRouting.unassignedInfo().getReason() != UnassignedInfo.Reason.FORCED_EMPTY_PRIMARY) {
            String unassignedInfoMessage = "force empty allocation from previous reason " + String.valueOf(shardRouting.unassignedInfo().getReason()) + ", " + shardRouting.unassignedInfo().getMessage();
            unassignedInfoToUpdate = new UnassignedInfo(UnassignedInfo.Reason.FORCED_EMPTY_PRIMARY, unassignedInfoMessage, shardRouting.unassignedInfo().getFailure(), 0, System.nanoTime(), System.currentTimeMillis(), false, shardRouting.unassignedInfo().getLastAllocationStatus(), Collections.emptySet());
        }
        this.initializeUnassignedShard(allocation, routingNodes, routingNode, shardRouting, unassignedInfoToUpdate, (RecoverySource)RecoverySource.EmptyStoreRecoverySource.INSTANCE);
        return new RerouteExplanation((AllocationCommand)this, allocation.decision(Decision.YES, this.name() + " (allocation command)", "ignore deciders", new Object[0]));
    }

    public static class Builder
    extends BasePrimaryAllocationCommand.Builder<AllocateEmptyPrimaryAllocationCommand> {
        public Builder parse(XContentParser parser) throws IOException {
            return (Builder)EMPTY_PRIMARY_PARSER.parse(parser, (Object)this, null);
        }

        @Override
        public AllocateEmptyPrimaryAllocationCommand build() {
            this.validate();
            return new AllocateEmptyPrimaryAllocationCommand(this.index, this.shard, this.node, this.acceptDataLoss);
        }
    }
}

