/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.command;

import io.skylite.core.ParseField;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.RoutingNodes;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.AllocationCommand;
import io.skylite.core.cluster.routing.allocation.RerouteExplanation;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.shard.ShardNotFoundException;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Optional;
import org.opensearch.cluster.routing.allocation.command.BasePrimaryAllocationCommand;

public class AllocateStalePrimaryAllocationCommand
extends BasePrimaryAllocationCommand {
    public static final String NAME = "allocate_stale_primary";
    public static final ParseField COMMAND_NAME_FIELD = new ParseField("allocate_stale_primary", new String[0]);
    private static final ObjectParser<Builder, Void> STALE_PRIMARY_PARSER = BasePrimaryAllocationCommand.createAllocatePrimaryParser("allocate_stale_primary");

    public AllocateStalePrimaryAllocationCommand(String index, int shardId, String node, boolean acceptDataLoss) {
        super(index, shardId, node, acceptDataLoss);
    }

    public AllocateStalePrimaryAllocationCommand(StreamInput in) throws IOException {
        super(in);
    }

    public String name() {
        return NAME;
    }

    public Optional<String> getMessage() {
        return Optional.of("allocated a stale primary for [" + this.index + "][" + this.shardId + "] on node [" + this.node + "] from user command");
    }

    public static AllocateStalePrimaryAllocationCommand fromXContent(XContentParser parser) throws IOException {
        return new Builder().parse(parser).build();
    }

    public RerouteExplanation execute(RoutingAllocation allocation, boolean explain) {
        DiscoveryNode discoNode;
        try {
            discoNode = allocation.nodes().resolveNode(this.node);
        }
        catch (IllegalArgumentException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, e);
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNode routingNode = routingNodes.node(discoNode.getId());
        if (routingNode == null) {
            return this.explainOrThrowMissingRoutingNode(allocation, explain, discoNode);
        }
        try {
            allocation.routingTable().shardRoutingTable(this.index, this.shardId).primaryShard();
        }
        catch (IndexNotFoundException | ShardNotFoundException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, (RuntimeException)e);
        }
        ShardRouting shardRouting = null;
        for (ShardRouting shard : allocation.routingNodes().unassigned()) {
            if (!shard.getIndexName().equals(this.index) || shard.getId() != this.shardId || !shard.primary()) continue;
            shardRouting = shard;
            break;
        }
        if (shardRouting == null) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "primary [" + this.index + "][" + this.shardId + "] is already assigned");
        }
        if (!this.acceptDataLoss) {
            String dataLossWarning = "allocating an empty primary for [" + this.index + "][" + this.shardId + "] can result in data loss. Please confirm by setting the accept_data_loss parameter to true";
            return this.explainOrThrowRejectedCommand(explain, allocation, dataLossWarning);
        }
        if (shardRouting.recoverySource().getType() != RecoverySource.Type.EXISTING_STORE) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "trying to allocate an existing primary shard [" + this.index + "][" + this.shardId + "], while no such shard has ever been active");
        }
        this.initializeUnassignedShard(allocation, routingNodes, routingNode, shardRouting, null, (RecoverySource)RecoverySource.ExistingStoreRecoverySource.FORCE_STALE_PRIMARY_INSTANCE);
        return new RerouteExplanation((AllocationCommand)this, allocation.decision(Decision.YES, this.name() + " (allocation command)", "ignore deciders", new Object[0]));
    }

    public static class Builder
    extends BasePrimaryAllocationCommand.Builder<AllocateStalePrimaryAllocationCommand> {
        public Builder parse(XContentParser parser) throws IOException {
            return (Builder)STALE_PRIMARY_PARSER.parse(parser, (Object)this, null);
        }

        @Override
        public AllocateStalePrimaryAllocationCommand build() {
            this.validate();
            return new AllocateStalePrimaryAllocationCommand(this.index, this.shard, this.node, this.acceptDataLoss);
        }
    }
}

