/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDeciderSettings;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConcurrentRebalanceAllocationDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(ConcurrentRebalanceAllocationDecider.class);
    public static final String NAME = "concurrent_rebalance";
    private volatile int clusterConcurrentRebalance;

    public ConcurrentRebalanceAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.clusterConcurrentRebalance = (Integer)AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING.get(settings);
        logger.debug("using [cluster_concurrent_rebalance] with [{}]", (Object)this.clusterConcurrentRebalance);
        clusterSettings.addSettingsUpdateConsumer(AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING, this::setClusterConcurrentRebalance);
    }

    private void setClusterConcurrentRebalance(int concurrentRebalance) {
        this.clusterConcurrentRebalance = concurrentRebalance;
    }

    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return this.canRebalance(allocation);
    }

    public Decision canRebalance(RoutingAllocation allocation) {
        if (this.clusterConcurrentRebalance == -1) {
            return allocation.decision(Decision.YES, NAME, "unlimited concurrent rebalances are allowed", new Object[0]);
        }
        int relocatingShards = allocation.routingNodes().getRelocatingShardCount();
        if (relocatingShards >= this.clusterConcurrentRebalance) {
            return allocation.decision(Decision.THROTTLE, NAME, "reached the limit of concurrently rebalancing shards [%d], cluster setting [%s=%d]", new Object[]{relocatingShards, AllocationDeciderSettings.CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING.getKey(), this.clusterConcurrentRebalance});
        }
        return allocation.decision(Decision.YES, NAME, "below threshold [%d] for concurrent rebalances, current rebalance shard count [%d]", new Object[]{this.clusterConcurrentRebalance, relocatingShards});
    }
}

