/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.UnassignedInfo;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Collections;
import java.util.List;

public class MaxRetryAllocationDecider
extends AllocationDecider {
    public static final Setting<Integer> SETTING_ALLOCATION_MAX_RETRY = Setting.intSetting((String)"index.allocation.max_retries", (int)5, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.NotCopyableOnResize});
    public static final String NAME = "max_retry";

    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        Decision decision;
        UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
        if (unassignedInfo != null && unassignedInfo.getNumFailedAllocations() > 0) {
            IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
            int maxRetry = (Integer)SETTING_ALLOCATION_MAX_RETRY.get(indexMetadata.getSettings());
            decision = unassignedInfo.getNumFailedAllocations() >= maxRetry ? allocation.decision(Decision.NO, NAME, "shard has exceeded the maximum number of retries [%d] on failed allocation attempts - manually call [/_cluster/reroute?retry_failed=true] to retry, [%s]", new Object[]{maxRetry, unassignedInfo.toString()}) : allocation.decision(Decision.YES, NAME, "shard has failed allocating [%d] times but [%d] retries are allowed", new Object[]{unassignedInfo.getNumFailedAllocations(), maxRetry});
        } else {
            decision = allocation.decision(Decision.YES, NAME, "shard has no previous failures", new Object[0]);
        }
        return decision;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + String.valueOf(shardRouting);
        return this.canAllocate(shardRouting, node, allocation);
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(SETTING_ALLOCATION_MAX_RETRY);
        }
    }
}

