/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.RoutingNodes;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.indices.replication.common.ReplicationType;
import io.skylite.core.settings.Settings;
import java.util.List;
import java.util.stream.Collectors;

public class NodeVersionAllocationDecider
extends AllocationDecider {
    public static final String NAME = "node_version";
    private final ReplicationType replicationType;

    public NodeVersionAllocationDecider(Settings settings) {
        this.replicationType = (ReplicationType)ReplicationType.INDEX_REPLICATION_TYPE_SETTING.get(settings);
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            if (this.replicationType == ReplicationType.SEGMENT) {
                List replicas = allocation.routingNodes().assignedShards(shardRouting.shardId()).stream().filter(shr -> !shr.primary() && shr.active()).collect(Collectors.toList());
                for (ShardRouting replica : replicas) {
                    RoutingNode replicaNode = allocation.routingNodes().node(replica.currentNodeId());
                    if (!node.node().getVersion().after(replicaNode.node().getVersion())) continue;
                    return allocation.decision(Decision.NO, NAME, "When segment replication is enabled, cannot relocate primary shard to a node with version [%s] if it has a replica on older version [%s]", new Object[]{node.node().getVersion(), replicaNode.node().getVersion()});
                }
            }
            if (shardRouting.currentNodeId() == null) {
                if (shardRouting.recoverySource() != null && shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) {
                    return this.isVersionCompatible((RecoverySource.SnapshotRecoverySource)shardRouting.recoverySource(), node, allocation);
                }
                return allocation.decision(Decision.YES, NAME, "the primary shard is new or already existed on the node", new Object[0]);
            }
            return this.isVersionCompatibleRelocatePrimary(allocation.routingNodes(), shardRouting.currentNodeId(), node, allocation);
        }
        ShardRouting primary = allocation.routingNodes().activePrimary(shardRouting.shardId());
        if (primary != null) {
            return this.isVersionCompatibleAllocatingReplica(allocation.routingNodes(), primary.currentNodeId(), node, allocation);
        }
        return allocation.decision(Decision.YES, NAME, "no active primary shard yet", new Object[0]);
    }

    private Decision isVersionCompatibleRelocatePrimary(RoutingNodes routingNodes, String sourceNodeId, RoutingNode target, RoutingAllocation allocation) {
        RoutingNode source = routingNodes.node(sourceNodeId);
        if (target.node().getVersion().onOrAfter(source.node().getVersion())) {
            return allocation.decision(Decision.YES, NAME, "can relocate primary shard from a node with version [%s] to a node with equal-or-newer version [%s]", new Object[]{source.node().getVersion(), target.node().getVersion()});
        }
        return allocation.decision(Decision.NO, NAME, "cannot relocate primary shard from a node with version [%s] to a node with older version [%s]", new Object[]{source.node().getVersion(), target.node().getVersion()});
    }

    private Decision isVersionCompatibleAllocatingReplica(RoutingNodes routingNodes, String sourceNodeId, RoutingNode target, RoutingAllocation allocation) {
        RoutingNode source = routingNodes.node(sourceNodeId);
        if (target.node().getVersion().onOrAfter(source.node().getVersion())) {
            return allocation.decision(Decision.YES, NAME, "can allocate replica shard to a node with version [%s] since this is equal-or-newer than the primary version [%s]", new Object[]{target.node().getVersion(), source.node().getVersion()});
        }
        return allocation.decision(Decision.NO, NAME, "cannot allocate replica shard to a node with version [%s] since this is older than the primary version [%s]", new Object[]{target.node().getVersion(), source.node().getVersion()});
    }

    private Decision isVersionCompatible(RecoverySource.SnapshotRecoverySource recoverySource, RoutingNode target, RoutingAllocation allocation) {
        if (target.node().getVersion().onOrAfter(recoverySource.version())) {
            return allocation.decision(Decision.YES, NAME, "node version [%s] is the same or newer than snapshot version [%s]", new Object[]{target.node().getVersion(), recoverySource.version()});
        }
        return allocation.decision(Decision.NO, NAME, "node version [%s] is older than the snapshot version [%s]", new Object[]{target.node().getVersion(), recoverySource.version()});
    }
}

