/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.UnassignedInfo;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.index.Index;
import io.skylite.core.index.shard.ShardId;

public class ResizeAllocationDecider
extends AllocationDecider {
    public static final String NAME = "resize";

    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, null, allocation);
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
        if (unassignedInfo != null && shardRouting.recoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) {
            IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
            Index resizeSourceIndex = indexMetadata.getResizeSourceIndex();
            assert (resizeSourceIndex != null);
            if (allocation.metadata().index(resizeSourceIndex) == null) {
                return allocation.decision(Decision.NO, NAME, "resize source index [%s] doesn't exists", new Object[]{resizeSourceIndex.toString()});
            }
            IndexMetadata sourceIndexMetadata = allocation.metadata().getIndexSafe(resizeSourceIndex);
            if (indexMetadata.getNumberOfShards() < sourceIndexMetadata.getNumberOfShards()) {
                return Decision.ALWAYS;
            }
            ShardId shardId = indexMetadata.getNumberOfShards() == sourceIndexMetadata.getNumberOfShards() ? IndexMetadata.selectCloneShard((int)shardRouting.id(), (IndexMetadata)sourceIndexMetadata, (int)indexMetadata.getNumberOfShards()) : IndexMetadata.selectSplitShard((int)shardRouting.id(), (IndexMetadata)sourceIndexMetadata, (int)indexMetadata.getNumberOfShards());
            ShardRouting sourceShardRouting = allocation.routingNodes().activePrimary(shardId);
            if (sourceShardRouting == null) {
                return allocation.decision(Decision.NO, NAME, "source primary shard [%s] is not active", new Object[]{shardId});
            }
            if (node != null) {
                if (sourceShardRouting.currentNodeId().equals(node.nodeId())) {
                    return allocation.decision(Decision.YES, NAME, "source primary is allocated on this node", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "source primary is allocated on another node", new Object[0]);
            }
            return allocation.decision(Decision.YES, NAME, "source primary is active", new Object[0]);
        }
        return super.canAllocate(shardRouting, node, allocation);
    }

    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + String.valueOf(shardRouting);
        return this.canAllocate(shardRouting, node, allocation);
    }
}

