/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.AllocationDecider;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;

public class ShardsLimitAllocationDecider
extends AllocationDecider {
    public static final String NAME = "shards_limit";
    private volatile int clusterShardLimit;
    public static final Setting<Integer> INDEX_TOTAL_SHARDS_PER_NODE_SETTING = Setting.intSetting((String)"index.routing.allocation.total_shards_per_node", (int)-1, (int)-1, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    public static final Setting<Integer> CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING = Setting.intSetting((String)"cluster.routing.allocation.total_shards_per_node", (int)-1, (int)-1, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final Settings settings;

    public ShardsLimitAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.settings = settings;
        this.clusterShardLimit = (Integer)CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING, this::setClusterShardLimit);
    }

    private void setClusterShardLimit(int clusterShardLimit) {
        this.clusterShardLimit = clusterShardLimit;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.doDecide(shardRouting, node, allocation, (count, limit) -> count >= limit);
    }

    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.doDecide(shardRouting, node, allocation, (count, limit) -> count > limit);
    }

    private Decision doDecide(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, BiPredicate<Integer, Integer> decider) {
        int indexShardCount;
        IndexMetadata indexMd = allocation.metadata().getIndexSafe(shardRouting.index());
        int indexShardLimit = (Integer)INDEX_TOTAL_SHARDS_PER_NODE_SETTING.get(indexMd.getSettings(), this.settings);
        int clusterShardLimit = this.clusterShardLimit;
        if (indexShardLimit <= 0 && clusterShardLimit <= 0) {
            return allocation.decision(Decision.YES, NAME, "total shard limits are disabled: [index: %d, cluster: %d] <= 0", new Object[]{indexShardLimit, clusterShardLimit});
        }
        int nodeShardCount = node.numberOfOwningShards();
        if (clusterShardLimit > 0 && decider.test(nodeShardCount, clusterShardLimit)) {
            return allocation.decision(Decision.NO, NAME, "too many shards [%d] allocated to this node, cluster setting [%s=%d]", new Object[]{nodeShardCount, CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING.getKey(), clusterShardLimit});
        }
        if (indexShardLimit > 0 && decider.test(indexShardCount = node.numberOfOwningShardsForIndex(shardRouting.index()), indexShardLimit)) {
            return allocation.decision(Decision.NO, NAME, "too many shards [%d] allocated to this node for index [%s], index setting [%s=%d]", new Object[]{indexShardCount, shardRouting.getIndexName(), INDEX_TOTAL_SHARDS_PER_NODE_SETTING.getKey(), indexShardLimit});
        }
        return allocation.decision(Decision.YES, NAME, "the shard count [%d] for this node is under the index limit [%d] and cluster level node limit [%d]", new Object[]{nodeShardCount, indexShardLimit, clusterShardLimit});
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING, INDEX_TOTAL_SHARDS_PER_NODE_SETTING);
        }
    }
}

