/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.geo;

import io.skylite.SkyliteException;
import io.skylite.SkyliteParseException;
import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryCollection;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.geometry.Line;
import io.skylite.common.geometry.LinearRing;
import io.skylite.common.geometry.MultiLine;
import io.skylite.common.geometry.MultiPoint;
import io.skylite.common.geometry.MultiPolygon;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.Rectangle;
import io.skylite.common.geometry.ShapeType;
import io.skylite.common.geometry.utils.GeometryValidator;
import io.skylite.core.ParseField;
import io.skylite.core.common.unit.DistanceUnit;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentSubParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensearch.common.geo.parsers.ShapeParser;

public final class GeoJson {
    private static final ParseField FIELD_TYPE = new ParseField("type", new String[0]);
    private static final ParseField FIELD_COORDINATES = new ParseField("coordinates", new String[0]);
    private static final ParseField FIELD_GEOMETRIES = new ParseField("geometries", new String[0]);
    private static final ParseField FIELD_ORIENTATION = new ParseField("orientation", new String[0]);
    private static final ParseField FIELD_RADIUS = new ParseField("radius", new String[0]);
    private static final ParseField FIELD_SEMI_MAJOR_AXIS = new ParseField("semiMajorAxis", new String[0]);
    private static final ParseField FIELD_SEMI_MINOR_AXIS = new ParseField("semiMinorAxis", new String[0]);
    private static final ParseField FIELD_ORIENTATION_DEGREES = new ParseField("orientationDegrees", new String[0]);
    private final boolean rightOrientation;
    private final boolean coerce;
    private final GeometryValidator validator;
    private static final ConstructingObjectParser<Geometry, GeoJson> PARSER = new ConstructingObjectParser("geojson", true, (a, c) -> {
        String type = (String)a[0];
        CoordinateNode coordinates = (CoordinateNode)a[1];
        List geometries = (List)a[2];
        Boolean orientation = GeoJson.orientationFromString((String)a[3]);
        DistanceUnit.Distance radius = (DistanceUnit.Distance)a[4];
        DistanceUnit.Distance semiMajorAxis = (DistanceUnit.Distance)a[5];
        DistanceUnit.Distance semiMinorAxis = (DistanceUnit.Distance)a[6];
        Double orientationDegrees = (Double)a[7];
        return GeoJson.createGeometry(type, geometries, coordinates, orientation, c.rightOrientation, c.coerce, radius, semiMajorAxis, semiMinorAxis, orientationDegrees);
    });

    public GeoJson(boolean rightOrientation, boolean coerce, GeometryValidator validator) {
        this.rightOrientation = rightOrientation;
        this.coerce = coerce;
        this.validator = validator;
    }

    public Geometry fromXContent(XContentParser parser) throws IOException {
        try (XContentSubParser subParser = new XContentSubParser(parser);){
            Geometry geometry = (Geometry)PARSER.apply((XContentParser)subParser, (Object)this);
            this.validator.validate(geometry);
            Geometry geometry2 = geometry;
            return geometry2;
        }
    }

    public static XContentBuilder toXContent(Geometry geometry, final XContentBuilder builder, final ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD_TYPE.getPreferredName(), GeoJson.getGeoJsonName(geometry));
        geometry.visit((GeometryVisitor)new GeometryVisitor<XContentBuilder, IOException>(){

            public XContentBuilder visit(Circle circle) throws IOException {
                builder.field(FIELD_RADIUS.getPreferredName(), DistanceUnit.METERS.toString(circle.getRadiusMeters()));
                builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
                return this.coordinatesToXContent(circle.getY(), circle.getX(), circle.getZ());
            }

            public XContentBuilder visit(Ellipse ellipse) throws IOException {
                builder.field(FIELD_SEMI_MAJOR_AXIS.getPreferredName(), DistanceUnit.METERS.toString(ellipse.getSemiMajorAxisMeters()));
                builder.field(FIELD_SEMI_MINOR_AXIS.getPreferredName(), DistanceUnit.METERS.toString(ellipse.getSemiMinorAxisMeters()));
                builder.field(FIELD_ORIENTATION_DEGREES.getPreferredName(), ellipse.getOrientationDegrees());
                builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
                return this.coordinatesToXContent(ellipse.getY(), ellipse.getX(), ellipse.getZ());
            }

            public XContentBuilder visit(GeometryCollection<?> collection) throws IOException {
                builder.startArray(FIELD_GEOMETRIES.getPreferredName());
                for (Geometry g : collection) {
                    GeoJson.toXContent(g, builder, params);
                }
                return builder.endArray();
            }

            public XContentBuilder visit(Line line) throws IOException {
                builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
                return this.coordinatesToXContent(line);
            }

            public XContentBuilder visit(LinearRing ring) {
                throw new UnsupportedOperationException("linearRing cannot be serialized using GeoJson");
            }

            public XContentBuilder visit(MultiLine multiLine) throws IOException {
                builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
                builder.startArray();
                for (int i = 0; i < multiLine.size(); ++i) {
                    this.coordinatesToXContent((Line)multiLine.get(i));
                }
                return builder.endArray();
            }

            public XContentBuilder visit(MultiPoint multiPoint) throws IOException {
                builder.startArray(ShapeParser.FIELD_COORDINATES.getPreferredName());
                for (int i = 0; i < multiPoint.size(); ++i) {
                    Point p = (Point)multiPoint.get(i);
                    builder.startArray().value(p.getX()).value(p.getY());
                    if (p.hasZ()) {
                        builder.value(p.getZ());
                    }
                    builder.endArray();
                }
                return builder.endArray();
            }

            public XContentBuilder visit(MultiPolygon multiPolygon) throws IOException {
                builder.startArray(ShapeParser.FIELD_COORDINATES.getPreferredName());
                for (int i = 0; i < multiPolygon.size(); ++i) {
                    builder.startArray();
                    this.coordinatesToXContent((Polygon)multiPolygon.get(i));
                    builder.endArray();
                }
                return builder.endArray();
            }

            public XContentBuilder visit(Point point) throws IOException {
                builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
                return this.coordinatesToXContent(point.getY(), point.getX(), point.getZ());
            }

            public XContentBuilder visit(Polygon polygon) throws IOException {
                builder.startArray(ShapeParser.FIELD_COORDINATES.getPreferredName());
                this.coordinatesToXContent((Line)polygon.getPolygon());
                for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                    this.coordinatesToXContent((Line)polygon.getHole(i));
                }
                return builder.endArray();
            }

            public XContentBuilder visit(Rectangle rectangle) throws IOException {
                builder.startArray(ShapeParser.FIELD_COORDINATES.getPreferredName());
                this.coordinatesToXContent(rectangle.getMaxY(), rectangle.getMinX(), rectangle.getMinZ());
                this.coordinatesToXContent(rectangle.getMinY(), rectangle.getMaxX(), rectangle.getMaxZ());
                return builder.endArray();
            }

            private XContentBuilder coordinatesToXContent(double lat, double lon, double alt) throws IOException {
                builder.startArray().value(lon).value(lat);
                if (!Double.isNaN(alt)) {
                    builder.value(alt);
                }
                return builder.endArray();
            }

            private XContentBuilder coordinatesToXContent(Line line) throws IOException {
                builder.startArray();
                for (int i = 0; i < line.length(); ++i) {
                    builder.startArray().value(line.getX(i)).value(line.getY(i));
                    if (line.hasZ()) {
                        builder.value(line.getZ(i));
                    }
                    builder.endArray();
                }
                return builder.endArray();
            }

            private XContentBuilder coordinatesToXContent(Polygon polygon) throws IOException {
                this.coordinatesToXContent((Line)polygon.getPolygon());
                for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                    this.coordinatesToXContent((Line)polygon.getHole(i));
                }
                return builder;
            }
        });
        return builder.endObject();
    }

    public static Map<String, Object> toMap(Geometry geometry) {
        final HashMap<String, Object> root = new HashMap<String, Object>();
        root.put(FIELD_TYPE.getPreferredName(), GeoJson.getGeoJsonName(geometry));
        geometry.visit((GeometryVisitor)new GeometryVisitor<Void, RuntimeException>(){

            public Void visit(Circle circle) {
                root.put(FIELD_RADIUS.getPreferredName(), DistanceUnit.METERS.toString(circle.getRadiusMeters()));
                root.put(ShapeParser.FIELD_COORDINATES.getPreferredName(), this.coordinatesToList(circle.getY(), circle.getX(), circle.getZ()));
                return null;
            }

            public Void visit(Ellipse ellipse) {
                root.put(FIELD_SEMI_MAJOR_AXIS.getPreferredName(), DistanceUnit.METERS.toString(ellipse.getSemiMajorAxisMeters()));
                root.put(FIELD_SEMI_MINOR_AXIS.getPreferredName(), DistanceUnit.METERS.toString(ellipse.getSemiMinorAxisMeters()));
                root.put(FIELD_ORIENTATION_DEGREES.getPreferredName(), ellipse.getOrientationDegrees());
                root.put(ShapeParser.FIELD_COORDINATES.getPreferredName(), this.coordinatesToList(ellipse.getY(), ellipse.getX(), ellipse.getZ()));
                return null;
            }

            public Void visit(GeometryCollection<?> collection) {
                ArrayList<Map<String, Object>> geometries = new ArrayList<Map<String, Object>>(collection.size());
                for (Geometry g : collection) {
                    geometries.add(GeoJson.toMap(g));
                }
                root.put(FIELD_GEOMETRIES.getPreferredName(), geometries);
                return null;
            }

            public Void visit(Line line) {
                root.put(ShapeParser.FIELD_COORDINATES.getPreferredName(), this.coordinatesToList(line));
                return null;
            }

            public Void visit(LinearRing ring) {
                throw new UnsupportedOperationException("linearRing cannot be serialized using GeoJson");
            }

            public Void visit(MultiLine multiLine) {
                ArrayList<List<Object>> lines = new ArrayList<List<Object>>(multiLine.size());
                for (int i = 0; i < multiLine.size(); ++i) {
                    lines.add(this.coordinatesToList((Line)multiLine.get(i)));
                }
                root.put(ShapeParser.FIELD_COORDINATES.getPreferredName(), lines);
                return null;
            }

            public Void visit(MultiPoint multiPoint) {
                ArrayList points = new ArrayList(multiPoint.size());
                for (int i = 0; i < multiPoint.size(); ++i) {
                    Point p = (Point)multiPoint.get(i);
                    ArrayList<Double> point = new ArrayList<Double>();
                    point.add(p.getX());
                    point.add(p.getY());
                    if (p.hasZ()) {
                        point.add(p.getZ());
                    }
                    points.add(point);
                }
                root.put(ShapeParser.FIELD_COORDINATES.getPreferredName(), points);
                return null;
            }

            public Void visit(MultiPolygon multiPolygon) {
                ArrayList<List<Object>> polygons = new ArrayList<List<Object>>();
                for (int i = 0; i < multiPolygon.size(); ++i) {
                    polygons.add(this.coordinatesToList((Polygon)multiPolygon.get(i)));
                }
                root.put(ShapeParser.FIELD_COORDINATES.getPreferredName(), polygons);
                return null;
            }

            public Void visit(Point point) {
                root.put(ShapeParser.FIELD_COORDINATES.getPreferredName(), this.coordinatesToList(point.getY(), point.getX(), point.getZ()));
                return null;
            }

            public Void visit(Polygon polygon) {
                ArrayList<List<Object>> coords = new ArrayList<List<Object>>(polygon.getNumberOfHoles() + 1);
                coords.add(this.coordinatesToList((Line)polygon.getPolygon()));
                for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                    coords.add(this.coordinatesToList((Line)polygon.getHole(i)));
                }
                root.put(ShapeParser.FIELD_COORDINATES.getPreferredName(), coords);
                return null;
            }

            public Void visit(Rectangle rectangle) {
                ArrayList<List<Object>> coords = new ArrayList<List<Object>>(2);
                coords.add(this.coordinatesToList(rectangle.getMaxY(), rectangle.getMinX(), rectangle.getMinZ()));
                coords.add(this.coordinatesToList(rectangle.getMinY(), rectangle.getMaxX(), rectangle.getMaxZ()));
                root.put(ShapeParser.FIELD_COORDINATES.getPreferredName(), coords);
                return null;
            }

            private List<Object> coordinatesToList(double lat, double lon, double alt) {
                ArrayList<Object> coords = new ArrayList<Object>(3);
                coords.add(lon);
                coords.add(lat);
                if (!Double.isNaN(alt)) {
                    coords.add(alt);
                }
                return coords;
            }

            private List<Object> coordinatesToList(Line line) {
                ArrayList<Object> lines = new ArrayList<Object>(line.length());
                for (int i = 0; i < line.length(); ++i) {
                    ArrayList<Double> coords = new ArrayList<Double>(3);
                    coords.add(line.getX(i));
                    coords.add(line.getY(i));
                    if (line.hasZ()) {
                        coords.add(line.getZ(i));
                    }
                    lines.add(coords);
                }
                return lines;
            }

            private List<Object> coordinatesToList(Polygon polygon) {
                ArrayList<Object> coords = new ArrayList<Object>(polygon.getNumberOfHoles() + 1);
                coords.add(this.coordinatesToList((Line)polygon.getPolygon()));
                for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                    coords.add(this.coordinatesToList((Line)polygon.getHole(i)));
                }
                return coords;
            }
        });
        return root;
    }

    private static Geometry createGeometry(String type, List<Geometry> geometries, CoordinateNode coordinates, Boolean orientation, boolean defaultOrientation, boolean coerce, DistanceUnit.Distance radius, DistanceUnit.Distance semiMajorAxis, DistanceUnit.Distance semiMinorAxis, Double orientationDegrees) {
        ShapeType shapeType = "bbox".equalsIgnoreCase(type) ? ShapeType.ENVELOPE : ShapeType.forName((String)type);
        if (shapeType == ShapeType.GEOMETRYCOLLECTION) {
            if (geometries == null) {
                throw new SkyliteParseException("geometries not included", new Object[0]);
            }
            if (coordinates != null) {
                throw new SkyliteParseException("parameter coordinates is not supported for type " + type, new Object[0]);
            }
            GeoJson.verifyNulls(type, null, orientation, radius, semiMajorAxis, semiMinorAxis, orientationDegrees);
            return new GeometryCollection(geometries);
        }
        if (coordinates == null) {
            throw new SkyliteParseException("coordinates not included", new Object[0]);
        }
        switch (shapeType) {
            case CIRCLE: {
                if (radius == null) {
                    throw new SkyliteParseException("radius is not specified", new Object[0]);
                }
                GeoJson.verifyNulls(type, geometries, orientation, null, semiMajorAxis, semiMinorAxis, orientationDegrees);
                Point point = coordinates.asPoint();
                return new Circle(point.getX(), point.getY(), point.getZ(), radius.convert((DistanceUnit)DistanceUnit.METERS).value);
            }
            case ELLIPSE: {
                if (semiMajorAxis == null) {
                    throw new SkyliteParseException("semiMajorAxis is not specified", new Object[0]);
                }
                if (semiMinorAxis == null) {
                    throw new SkyliteParseException("semiMinorAxis is not specified", new Object[0]);
                }
                if (orientationDegrees == null) {
                    throw new SkyliteParseException("orientationDegrees is not specified", new Object[0]);
                }
                GeoJson.verifyNulls(type, geometries, orientation, radius, null, null, null);
                Point point = coordinates.asPoint();
                return new Ellipse(point.getX(), point.getY(), point.getZ(), semiMajorAxis.convert((DistanceUnit)DistanceUnit.METERS).value, semiMinorAxis.convert((DistanceUnit)DistanceUnit.METERS).value, orientationDegrees.doubleValue());
            }
            case POINT: {
                GeoJson.verifyNulls(type, geometries, orientation, radius, semiMajorAxis, semiMinorAxis, orientationDegrees);
                return coordinates.asPoint();
            }
            case MULTIPOINT: {
                GeoJson.verifyNulls(type, geometries, orientation, radius, semiMajorAxis, semiMinorAxis, orientationDegrees);
                return coordinates.asMultiPoint();
            }
            case LINESTRING: {
                GeoJson.verifyNulls(type, geometries, orientation, radius, semiMajorAxis, semiMinorAxis, orientationDegrees);
                return coordinates.asLineString(coerce);
            }
            case MULTILINESTRING: {
                GeoJson.verifyNulls(type, geometries, orientation, radius, semiMajorAxis, semiMinorAxis, orientationDegrees);
                return coordinates.asMultiLineString(coerce);
            }
            case POLYGON: {
                GeoJson.verifyNulls(type, geometries, null, radius, semiMajorAxis, semiMinorAxis, orientationDegrees);
                return coordinates.asPolygon(orientation != null ? orientation : defaultOrientation, coerce);
            }
            case MULTIPOLYGON: {
                GeoJson.verifyNulls(type, geometries, null, radius, semiMajorAxis, semiMinorAxis, orientationDegrees);
                return coordinates.asMultiPolygon(orientation != null ? orientation : defaultOrientation, coerce);
            }
            case ENVELOPE: {
                GeoJson.verifyNulls(type, geometries, orientation, radius, semiMajorAxis, semiMinorAxis, orientationDegrees);
                return coordinates.asRectangle();
            }
        }
        throw new SkyliteParseException("unsupported shape type " + type, new Object[0]);
    }

    private static void verifyNulls(String type, List<Geometry> geometries, Boolean orientation, DistanceUnit.Distance radius, DistanceUnit.Distance semiMajorAxis, DistanceUnit.Distance semiMinorAxis, Double orientationDegrees) {
        if (geometries != null) {
            throw new SkyliteParseException("parameter geometries is not supported for type " + type, new Object[0]);
        }
        if (orientation != null) {
            throw new SkyliteParseException("parameter orientation is not supported for type " + type, new Object[0]);
        }
        if (radius != null) {
            throw new SkyliteParseException("parameter radius is not supported for type " + type, new Object[0]);
        }
        if (semiMajorAxis != null) {
            throw new SkyliteParseException("parameter semiMajorAxis is not supported for type " + type, new Object[0]);
        }
        if (semiMinorAxis != null) {
            throw new SkyliteParseException("parameter semiMinorAxis is not supported for type " + type, new Object[0]);
        }
        if (orientationDegrees != null) {
            throw new SkyliteParseException("parameter orientationDegrees is not supported for type " + type, new Object[0]);
        }
    }

    private static CoordinateNode parseCoordinates(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_ARRAY && token != XContentParser.Token.END_ARRAY && token != XContentParser.Token.VALUE_NULL) {
            return new CoordinateNode(GeoJson.parseCoordinate(parser));
        }
        if (token == XContentParser.Token.VALUE_NULL) {
            throw new IllegalArgumentException("coordinates cannot contain NULL values)");
        }
        ArrayList<CoordinateNode> nodes = new ArrayList<CoordinateNode>();
        while (token != XContentParser.Token.END_ARRAY) {
            CoordinateNode node = GeoJson.parseCoordinates(parser);
            if (!nodes.isEmpty() && ((CoordinateNode)nodes.get(0)).numDimensions() != node.numDimensions()) {
                throw new SkyliteParseException("Exception parsing coordinates: number of dimensions do not match", new Object[0]);
            }
            nodes.add(node);
            token = parser.nextToken();
        }
        return new CoordinateNode(nodes);
    }

    private static Point parseCoordinate(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.VALUE_NUMBER) {
            throw new SkyliteParseException("geo coordinates must be numbers", new Object[0]);
        }
        double lon = parser.doubleValue();
        if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
            throw new SkyliteParseException("geo coordinates must be numbers", new Object[0]);
        }
        double lat = parser.doubleValue();
        XContentParser.Token token = parser.nextToken();
        double alt = Double.NaN;
        if (token == XContentParser.Token.VALUE_NUMBER) {
            alt = parser.doubleValue();
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
            throw new SkyliteParseException("geo coordinates greater than 3 dimensions are not supported", new Object[0]);
        }
        return new Point(lon, lat, alt);
    }

    private static Boolean orientationFromString(String orientation) {
        if (orientation == null) {
            return null;
        }
        switch (orientation = orientation.toLowerCase(Locale.ROOT)) {
            case "right": 
            case "counterclockwise": 
            case "ccw": {
                return true;
            }
            case "left": 
            case "clockwise": 
            case "cw": {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown orientation [" + orientation + "]");
    }

    public static String getGeoJsonName(Geometry geometry) {
        return (String)geometry.visit((GeometryVisitor)new GeometryVisitor<String, RuntimeException>(){

            public String visit(Circle circle) {
                return "Circle";
            }

            public String visit(Ellipse ellipse) {
                return "Ellipse";
            }

            public String visit(GeometryCollection<?> collection) {
                return "GeometryCollection";
            }

            public String visit(Line line) {
                return "LineString";
            }

            public String visit(LinearRing ring) {
                throw new UnsupportedOperationException("line ring cannot be serialized using GeoJson");
            }

            public String visit(MultiLine multiLine) {
                return "MultiLineString";
            }

            public String visit(MultiPoint multiPoint) {
                return "MultiPoint";
            }

            public String visit(MultiPolygon multiPolygon) {
                return "MultiPolygon";
            }

            public String visit(Point point) {
                return "Point";
            }

            public String visit(Polygon polygon) {
                return "Polygon";
            }

            public String visit(Rectangle rectangle) {
                return "Envelope";
            }
        });
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_TYPE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> GeoJson.parseCoordinates(p), FIELD_COORDINATES, ObjectParser.ValueType.VALUE_ARRAY);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), PARSER, FIELD_GEOMETRIES);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD_ORIENTATION);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> DistanceUnit.Distance.parseDistance((String)p.text()), FIELD_RADIUS, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> DistanceUnit.Distance.parseDistance((String)p.text()), FIELD_SEMI_MAJOR_AXIS, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> DistanceUnit.Distance.parseDistance((String)p.text()), FIELD_SEMI_MINOR_AXIS, ObjectParser.ValueType.STRING);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), FIELD_ORIENTATION_DEGREES);
    }

    private static class CoordinateNode
    implements ToXContentObject {
        public final Point coordinate;
        public final List<CoordinateNode> children;

        CoordinateNode(Point coordinate) {
            this.coordinate = coordinate;
            this.children = null;
        }

        CoordinateNode(List<CoordinateNode> children) {
            this.children = children;
            this.coordinate = null;
        }

        public boolean isEmpty() {
            return this.coordinate == null && (this.children == null || this.children.isEmpty());
        }

        protected int numDimensions() {
            if (this.isEmpty()) {
                throw new SkyliteException("attempting to get number of dimensions on an empty coordinate node", new Object[0]);
            }
            if (this.coordinate != null) {
                return this.coordinate.hasZ() ? 3 : 2;
            }
            return this.children.get(0).numDimensions();
        }

        public Point asPoint() {
            if (this.children != null) {
                throw new SkyliteException("expected a single points but got a list", new Object[0]);
            }
            return this.coordinate;
        }

        public MultiPoint asMultiPoint() {
            if (this.coordinate != null) {
                throw new SkyliteException("expected a list of points but got a point", new Object[0]);
            }
            ArrayList<Point> points = new ArrayList<Point>();
            for (CoordinateNode node : this.children) {
                points.add(node.asPoint());
            }
            return new MultiPoint(points);
        }

        private double[][] asLineComponents(boolean orientation, boolean coerce, boolean close) {
            int resultSize;
            boolean needsClosing;
            if (this.coordinate != null) {
                throw new SkyliteException("expected a list of points but got a point", new Object[0]);
            }
            if (this.children.size() < 2) {
                throw new SkyliteException("not enough points to build a line", new Object[0]);
            }
            if (close && coerce && !this.children.get(0).asPoint().equals((Object)this.children.get(this.children.size() - 1).asPoint())) {
                needsClosing = true;
                resultSize = this.children.size() + 1;
            } else {
                needsClosing = false;
                resultSize = this.children.size();
            }
            double[] lats = new double[resultSize];
            double[] lons = new double[resultSize];
            double[] alts = this.numDimensions() == 3 ? new double[resultSize] : null;
            int i = orientation ? 0 : lats.length - 1;
            for (CoordinateNode node : this.children) {
                Point point = node.asPoint();
                lats[i] = point.getY();
                lons[i] = point.getX();
                if (alts != null) {
                    alts[i] = point.getZ();
                }
                i = orientation ? i + 1 : i - 1;
            }
            if (needsClosing) {
                lats[resultSize - 1] = lats[0];
                lons[resultSize - 1] = lons[0];
                if (alts != null) {
                    alts[resultSize - 1] = alts[0];
                }
            }
            double[][] components = new double[][]{lats, lons, alts};
            return components;
        }

        public Line asLineString(boolean coerce) {
            double[][] components = this.asLineComponents(true, coerce, false);
            return new Line(components[1], components[0], components[2]);
        }

        public LinearRing asLinearRing(boolean orientation, boolean coerce) {
            double[][] components = this.asLineComponents(orientation, coerce, true);
            return new LinearRing(components[1], components[0], components[2]);
        }

        public MultiLine asMultiLineString(boolean coerce) {
            if (this.coordinate != null) {
                throw new SkyliteException("expected a list of points but got a point", new Object[0]);
            }
            ArrayList<Line> lines = new ArrayList<Line>();
            for (CoordinateNode node : this.children) {
                lines.add(node.asLineString(coerce));
            }
            return new MultiLine(lines);
        }

        public Polygon asPolygon(boolean orientation, boolean coerce) {
            if (this.coordinate != null) {
                throw new SkyliteException("expected a list of points but got a point", new Object[0]);
            }
            ArrayList<LinearRing> lines = new ArrayList<LinearRing>();
            for (CoordinateNode node : this.children) {
                lines.add(node.asLinearRing(orientation, coerce));
            }
            if (lines.size() == 1) {
                return new Polygon((LinearRing)lines.get(0));
            }
            LinearRing shell = (LinearRing)lines.remove(0);
            return new Polygon(shell, lines);
        }

        public MultiPolygon asMultiPolygon(boolean orientation, boolean coerce) {
            if (this.coordinate != null) {
                throw new SkyliteException("expected a list of points but got a point", new Object[0]);
            }
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            for (CoordinateNode node : this.children) {
                polygons.add(node.asPolygon(orientation, coerce));
            }
            return new MultiPolygon(polygons);
        }

        public Rectangle asRectangle() {
            if (this.children.size() != 2) {
                throw new SkyliteParseException("invalid number of points [{}] provided for geo_shape [{}] when expecting an array of 2 coordinates", new Object[]{this.children.size(), ShapeType.ENVELOPE});
            }
            Point uL = this.children.get((int)0).coordinate;
            Point lR = this.children.get((int)1).coordinate;
            return new Rectangle(uL.getX(), lR.getX(), uL.getY(), lR.getY());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.children == null) {
                builder.startArray().value(this.coordinate.getX()).value(this.coordinate.getY()).endArray();
            } else {
                builder.startArray();
                for (CoordinateNode child : this.children) {
                    child.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder;
        }
    }
}

