/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.geo;

import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.utils.WellKnownText;
import io.skylite.core.geo.GeometryFormat;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.text.ParseException;

public class WKTGeometryFormat
implements GeometryFormat<Geometry> {
    public static final String NAME = "wkt";
    private final WellKnownText wellKnownTextParser;

    public WKTGeometryFormat(WellKnownText wellKnownTextParser) {
        this.wellKnownTextParser = wellKnownTextParser;
    }

    public String name() {
        return NAME;
    }

    public Geometry fromXContent(XContentParser parser) throws IOException, ParseException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.wellKnownTextParser.fromWKT(parser.text());
    }

    public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (geometry != null) {
            return builder.value(this.wellKnownTextParser.toWKT(geometry));
        }
        return builder.nullValue();
    }

    public String toXContentAsObject(Geometry geometry) {
        return this.wellKnownTextParser.toWKT(geometry);
    }
}

