/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.search.function;

import io.skylite.SkyliteException;
import io.skylite.common.Nullable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.fielddata.FieldData;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.index.fielddata.LeafNumericFieldData;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.lucene.search.function.CombineFunction;
import io.skylite.core.lucene.search.function.Functions;
import io.skylite.core.lucene.search.function.LeafScoreFunction;
import io.skylite.core.lucene.search.function.ScoreFunction;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;

public class FieldValueFactorFunction
extends ScoreFunction {
    private final String field;
    private final float boostFactor;
    private final Modifier modifier;
    private final String functionName;
    private final Double missing;
    private final IndexNumericFieldData indexFieldData;

    public FieldValueFactorFunction(String field, float boostFactor, Modifier modifierType, Double missing, IndexNumericFieldData indexFieldData) {
        this(field, boostFactor, modifierType, missing, indexFieldData, null);
    }

    public FieldValueFactorFunction(String field, float boostFactor, Modifier modifierType, Double missing, IndexNumericFieldData indexFieldData, @Nullable String functionName) {
        super(CombineFunction.MULTIPLY);
        this.field = field;
        this.boostFactor = boostFactor;
        this.modifier = modifierType;
        this.indexFieldData = indexFieldData;
        this.missing = missing;
        this.functionName = functionName;
    }

    public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) {
        final SortedNumericDoubleValues values = this.indexFieldData == null ? FieldData.emptySortedNumericDoubles() : ((LeafNumericFieldData)this.indexFieldData.load(ctx)).getDoubleValues();
        return new LeafScoreFunction(){

            public double score(int docId, float subQueryScore) throws IOException {
                double value;
                if (values.advanceExact(docId)) {
                    value = values.nextValue();
                } else if (FieldValueFactorFunction.this.missing != null) {
                    value = FieldValueFactorFunction.this.missing;
                } else {
                    throw new SkyliteException("Missing value for field [" + FieldValueFactorFunction.this.field + "]", new Object[0]);
                }
                double val = value * (double)FieldValueFactorFunction.this.boostFactor;
                double result = FieldValueFactorFunction.this.modifier.apply(val);
                if (result < 0.0) {
                    String message = "field value function must not produce negative scores, but got: [" + result + "] for field value: [" + value + "]";
                    if (FieldValueFactorFunction.this.modifier == Modifier.LN) {
                        message = message + "; consider using ln1p or ln2p instead of ln to avoid negative scores";
                    } else if (FieldValueFactorFunction.this.modifier == Modifier.LOG) {
                        message = message + "; consider using log1p or log2p instead of log to avoid negative scores";
                    }
                    throw new IllegalArgumentException(message);
                }
                return result;
            }

            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                String modifierStr = FieldValueFactorFunction.this.modifier != null ? FieldValueFactorFunction.this.modifier.toString() : "";
                String defaultStr = FieldValueFactorFunction.this.missing != null ? "?:" + FieldValueFactorFunction.this.missing : "";
                double score = this.score(docId, subQueryScore.getValue().floatValue());
                return Explanation.match((Number)Float.valueOf((float)score), (String)String.format(Locale.ROOT, "field value function" + Functions.nameOrEmptyFunc((String)FieldValueFactorFunction.this.functionName) + ": %s(doc['%s'].value%s * factor=%s)", modifierStr, FieldValueFactorFunction.this.field, defaultStr, Float.valueOf(FieldValueFactorFunction.this.boostFactor)), (Explanation[])new Explanation[0]);
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    protected boolean doEquals(ScoreFunction other) {
        FieldValueFactorFunction fieldValueFactorFunction = (FieldValueFactorFunction)other;
        return this.boostFactor == fieldValueFactorFunction.boostFactor && Objects.equals(this.field, fieldValueFactorFunction.field) && Objects.equals((Object)this.modifier, (Object)fieldValueFactorFunction.modifier);
    }

    protected int doHashCode() {
        return Objects.hash(new Object[]{Float.valueOf(this.boostFactor), this.field, this.modifier});
    }

    public static enum Modifier implements Writeable
    {
        NONE{

            @Override
            public double apply(double n) {
                return n;
            }
        }
        ,
        LOG{

            @Override
            public double apply(double n) {
                return Math.log10(n);
            }
        }
        ,
        LOG1P{

            @Override
            public double apply(double n) {
                return Math.log10(n + 1.0);
            }
        }
        ,
        LOG2P{

            @Override
            public double apply(double n) {
                return Math.log10(n + 2.0);
            }
        }
        ,
        LN{

            @Override
            public double apply(double n) {
                return Math.log(n);
            }
        }
        ,
        LN1P{

            @Override
            public double apply(double n) {
                return Math.log1p(n);
            }
        }
        ,
        LN2P{

            @Override
            public double apply(double n) {
                return Math.log1p(n + 1.0);
            }
        }
        ,
        SQUARE{

            @Override
            public double apply(double n) {
                return Math.pow(n, 2.0);
            }
        }
        ,
        SQRT{

            @Override
            public double apply(double n) {
                return Math.sqrt(n);
            }
        }
        ,
        RECIPROCAL{

            @Override
            public double apply(double n) {
                return 1.0 / n;
            }
        };


        public abstract double apply(double var1);

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public static Modifier readFromStream(StreamInput in) throws IOException {
            return (Modifier)in.readEnum(Modifier.class);
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static Modifier fromString(String modifier) {
            return Modifier.valueOf(modifier.toUpperCase(Locale.ROOT));
        }
    }
}

