/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery;

import io.skylite.Version;
import io.skylite.common.Randomness;
import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.NotifyOnceListener;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.transport.ConnectTransportException;
import io.skylite.core.transport.ConnectionProfile;
import io.skylite.core.transport.TransportConnection;
import io.skylite.core.transport.TransportService;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.discovery.PeerFinder;

public class HandshakingTransportAddressConnector
implements PeerFinder.TransportAddressConnector {
    private static final Logger logger = LogManager.getLogger(HandshakingTransportAddressConnector.class);
    public static final Setting<TimeValue> PROBE_CONNECT_TIMEOUT_SETTING = Setting.timeSetting((String)"discovery.probe.connect_timeout", (TimeValue)TimeValue.timeValueMillis((long)3000L), (TimeValue)TimeValue.timeValueMillis((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> PROBE_HANDSHAKE_TIMEOUT_SETTING = Setting.timeSetting((String)"discovery.probe.handshake_timeout", (TimeValue)TimeValue.timeValueMillis((long)1000L), (TimeValue)TimeValue.timeValueMillis((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final TransportService transportService;
    private final TimeValue probeConnectTimeout;
    private final TimeValue probeHandshakeTimeout;

    public HandshakingTransportAddressConnector(Settings settings, TransportService transportService) {
        this.transportService = transportService;
        this.probeConnectTimeout = (TimeValue)PROBE_CONNECT_TIMEOUT_SETTING.get(settings);
        this.probeHandshakeTimeout = (TimeValue)PROBE_HANDSHAKE_TIMEOUT_SETTING.get(settings);
    }

    @Override
    public void connectToRemoteMasterNode(final TransportAddress transportAddress, final ActionListener<DiscoveryNode> listener) {
        this.transportService.getThreadPool().generic().execute((Runnable)new AbstractRunnable(){
            private final AbstractRunnable thisConnectionAttempt = this;

            public void doRun() {
                DiscoveryNode targetNode = new DiscoveryNode("", transportAddress.toString(), UUIDs.randomBase64UUID((Random)Randomness.get()), transportAddress.address().getHostString(), transportAddress.getAddress(), transportAddress, Collections.emptyMap(), Collections.emptySet(), Version.CURRENT.minimumWireCompatibilityVersion());
                logger.trace("[{}] opening probe connection", (Object)this.thisConnectionAttempt);
                HandshakingTransportAddressConnector.this.transportService.openConnection(targetNode, ConnectionProfile.buildSingleChannelProfile((TransportRequestOptions.Type)TransportRequestOptions.Type.REG, (TimeValue)HandshakingTransportAddressConnector.this.probeConnectTimeout, (TimeValue)HandshakingTransportAddressConnector.this.probeHandshakeTimeout, (TimeValue)TimeValue.MINUS_ONE, null), (ActionListener)new ActionListener<TransportConnection>(){

                    public void onResponse(final TransportConnection connection) {
                        logger.trace("[{}] opened probe connection", (Object)thisConnectionAttempt);
                        HandshakingTransportAddressConnector.this.transportService.handshake(connection, HandshakingTransportAddressConnector.this.probeHandshakeTimeout.millis(), (ActionListener)new NotifyOnceListener<DiscoveryNode>(){

                            protected void innerOnResponse(final DiscoveryNode remoteNode) {
                                try {
                                    logger.trace("[{}] handshake successful: {}", (Object)thisConnectionAttempt, (Object)remoteNode);
                                    IOUtils.closeWhileHandlingException((Closeable)connection);
                                    if (remoteNode.equals((Object)HandshakingTransportAddressConnector.this.transportService.getLocalNode())) {
                                        listener.onFailure((Exception)new ConnectTransportException(remoteNode, "local node found"));
                                    } else if (!remoteNode.isClusterManagerNode()) {
                                        listener.onFailure((Exception)new ConnectTransportException(remoteNode, "non-cluster-manager-eligible node found"));
                                    } else {
                                        HandshakingTransportAddressConnector.this.transportService.connectToNode(remoteNode, (ActionListener)new ActionListener<Void>(){

                                            public void onResponse(Void ignored) {
                                                logger.trace("[{}] completed full connection with [{}]", (Object)thisConnectionAttempt, (Object)remoteNode);
                                                listener.onResponse((Object)remoteNode);
                                            }

                                            public void onFailure(Exception e) {
                                                logger.warn((Message)new ParameterizedMessage("[{}] completed handshake with [{}] but followup connection failed", (Object)thisConnectionAttempt, (Object)remoteNode), (Throwable)e);
                                                listener.onFailure(e);
                                            }
                                        });
                                    }
                                }
                                catch (Exception e) {
                                    listener.onFailure(e);
                                }
                            }

                            protected void innerOnFailure(Exception e) {
                                logger.warn((Message)new ParameterizedMessage("handshake failed for [{}]", (Object)thisConnectionAttempt), (Throwable)e);
                                IOUtils.closeWhileHandlingException((Closeable)connection);
                                listener.onFailure(e);
                            }
                        });
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public String toString() {
                return "connectToRemoteMasterNode[" + String.valueOf(transportAddress) + "]";
            }
        });
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(PROBE_CONNECT_TIMEOUT_SETTING, PROBE_HANDSHAKE_TIMEOUT_SETTING);
        }
    }
}

