/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery;

import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class PeersRequest
extends TransportRequest {
    private final DiscoveryNode sourceNode;
    private final List<DiscoveryNode> knownPeers;

    public PeersRequest(DiscoveryNode sourceNode, List<DiscoveryNode> knownPeers) {
        assert (!knownPeers.contains(sourceNode)) : "local node is not a peer";
        this.sourceNode = sourceNode;
        this.knownPeers = knownPeers;
    }

    public PeersRequest(StreamInput in) throws IOException {
        super(in);
        this.sourceNode = new DiscoveryNode(in);
        this.knownPeers = in.readList(DiscoveryNode::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.sourceNode.writeTo(out);
        out.writeList(this.knownPeers);
    }

    public List<DiscoveryNode> getKnownPeers() {
        return this.knownPeers;
    }

    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public String toString() {
        return "PeersRequest{sourceNode=" + String.valueOf(this.sourceNode) + ", knownPeers=" + String.valueOf(this.knownPeers) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PeersRequest that = (PeersRequest)((Object)o);
        return Objects.equals(this.sourceNode, that.sourceNode) && Objects.equals(this.knownPeers, that.knownPeers);
    }

    public int hashCode() {
        return Objects.hash(this.sourceNode, this.knownPeers);
    }
}

