/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery;

import io.skylite.common.SetOnce;
import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.common.util.CancellableThreads;
import io.skylite.core.discovery.SeedHostsProvider;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.discovery.PeerFinder;

public class SeedHostsResolver
extends AbstractLifecycleComponent
implements PeerFinder.ConfiguredHostsResolver,
SeedHostsProvider.HostsResolver {
    public static final Setting<Integer> DISCOVERY_SEED_RESOLVER_MAX_CONCURRENT_RESOLVERS_SETTING = Setting.intSetting((String)"discovery.seed_resolver.max_concurrent_resolvers", (int)10, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> DISCOVERY_SEED_RESOLVER_TIMEOUT_SETTING = Setting.positiveTimeSetting((String)"discovery.seed_resolver.timeout", (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(SeedHostsResolver.class);
    private final Settings settings;
    private final AtomicBoolean resolveInProgress = new AtomicBoolean();
    private final TransportService transportService;
    private final SeedHostsProvider hostsProvider;
    private final SetOnce<ExecutorService> executorService = new SetOnce();
    private final TimeValue resolveTimeout;
    private final String nodeName;
    private final int concurrentConnects;
    private final CancellableThreads cancellableThreads = new CancellableThreads();

    public SeedHostsResolver(String nodeName, Settings settings, TransportService transportService, SeedHostsProvider seedProvider) {
        this.settings = settings;
        this.nodeName = nodeName;
        this.transportService = transportService;
        this.hostsProvider = seedProvider;
        this.resolveTimeout = SeedHostsResolver.getResolveTimeout(settings);
        this.concurrentConnects = SeedHostsResolver.getMaxConcurrentResolvers(settings);
    }

    public static int getMaxConcurrentResolvers(Settings settings) {
        return (Integer)DISCOVERY_SEED_RESOLVER_MAX_CONCURRENT_RESOLVERS_SETTING.get(settings);
    }

    public static TimeValue getResolveTimeout(Settings settings) {
        return (TimeValue)DISCOVERY_SEED_RESOLVER_TIMEOUT_SETTING.get(settings);
    }

    public List<TransportAddress> resolveHosts(List<String> hosts) {
        Objects.requireNonNull(hosts);
        if (this.resolveTimeout.nanos() < 0L) {
            throw new IllegalArgumentException("resolve timeout must be non-negative but was [" + String.valueOf(this.resolveTimeout) + "]");
        }
        List callables = hosts.stream().map(hn -> () -> this.transportService.addressesFromString(hn)).collect(Collectors.toList());
        SetOnce futures = new SetOnce();
        long startTimeNanos = this.transportService.getThreadPool().relativeTimeInNanos();
        try {
            this.cancellableThreads.execute(() -> futures.set(((ExecutorService)this.executorService.get()).invokeAll(callables, this.resolveTimeout.nanos(), TimeUnit.NANOSECONDS)));
        }
        catch (CancellableThreads.ExecutionCancelledException e) {
            return Collections.emptyList();
        }
        TimeValue duration = TimeValue.timeValueNanos((long)(this.transportService.getThreadPool().relativeTimeInNanos() - startTimeNanos));
        ArrayList<TransportAddress> transportAddresses = new ArrayList<TransportAddress>();
        HashSet<TransportAddress> localAddresses = new HashSet<TransportAddress>();
        localAddresses.add(this.transportService.boundAddress().publishAddress());
        localAddresses.addAll(Arrays.asList(this.transportService.boundAddress().boundAddresses()));
        Iterator<String> it = hosts.iterator();
        for (Future future : (List)futures.get()) {
            assert (future.isDone());
            String hostname = it.next();
            if (!future.isCancelled()) {
                try {
                    TransportAddress[] addresses = (TransportAddress[])future.get();
                    logger.trace("resolved host [{}] to {}", (Object)hostname, (Object)addresses);
                    for (int addressId = 0; addressId < addresses.length; ++addressId) {
                        TransportAddress address = addresses[addressId];
                        if (localAddresses.contains(address)) continue;
                        transportAddresses.add(address);
                    }
                    continue;
                }
                catch (ExecutionException e) {
                    assert (e.getCause() != null);
                    String message = "failed to resolve host [" + hostname + "]";
                    logger.warn(message, e.getCause());
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            logger.warn("timed out after [{}] resolving host [{}]", (Object)this.resolveTimeout, (Object)hostname);
        }
        return Collections.unmodifiableList(transportAddresses);
    }

    protected void doStart() {
        logger.debug("using max_concurrent_resolvers [{}], resolver timeout [{}]", (Object)this.concurrentConnects, (Object)this.resolveTimeout);
        ThreadFactory threadFactory = SkyliteExecutors.daemonThreadFactory((Settings)this.settings, (String)"[unicast_configured_hosts_resolver]");
        this.executorService.set((Object)SkyliteExecutors.newScaling((String)(this.nodeName + "/unicast_configured_hosts_resolver"), (int)0, (int)this.concurrentConnects, (long)60L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)threadFactory, (ThreadContext)this.transportService.getThreadPool().getThreadContext()));
    }

    protected void doStop() {
        this.cancellableThreads.cancel("stopping SeedHostsResolver");
        ThreadPool.terminate((ExecutorService)((ExecutorService)this.executorService.get()), (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    protected void doClose() {
    }

    @Override
    public void resolveConfiguredHosts(final Consumer<List<TransportAddress>> consumer) {
        if (!this.lifecycle.started()) {
            logger.debug("resolveConfiguredHosts: lifecycle is {}, not proceeding", (Object)this.lifecycle);
            return;
        }
        if (this.resolveInProgress.compareAndSet(false, true)) {
            this.transportService.getThreadPool().generic().execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    logger.debug("failure when resolving unicast hosts list", (Throwable)e);
                }

                public void doRun() {
                    if (!SeedHostsResolver.this.lifecycle.started()) {
                        logger.debug("resolveConfiguredHosts.doRun: lifecycle is {}, not proceeding", (Object)SeedHostsResolver.this.lifecycle);
                        return;
                    }
                    List providedAddresses = SeedHostsResolver.this.hostsProvider.getSeedAddresses((SeedHostsProvider.HostsResolver)SeedHostsResolver.this);
                    consumer.accept(providedAddresses);
                }

                public void onAfter() {
                    SeedHostsResolver.this.resolveInProgress.set(false);
                }

                public String toString() {
                    return "SeedHostsResolver resolving unicast hosts list";
                }
            });
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(DISCOVERY_SEED_RESOLVER_MAX_CONCURRENT_RESOLVERS_SETTING, DISCOVERY_SEED_RESOLVER_TIMEOUT_SETTING);
        }
    }
}

