/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import io.skylite.common.Nullable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.extensions.proto.ExtensionIdentityProto;
import org.opensearch.extensions.proto.ExtensionRequestProto;

public class ExtensionRequest
extends TransportRequest {
    private static final Logger logger = LogManager.getLogger(ExtensionRequest.class);
    private final ExtensionRequestProto.ExtensionRequest request;

    public ExtensionRequest(ExtensionRequestProto.RequestType requestType) {
        this(requestType, null);
    }

    public ExtensionRequest(ExtensionRequestProto.RequestType requestType, @Nullable String uniqueId) {
        ExtensionRequestProto.ExtensionRequest.Builder builder = ExtensionRequestProto.ExtensionRequest.newBuilder();
        if (uniqueId != null) {
            builder.setIdentity(ExtensionIdentityProto.ExtensionIdentity.newBuilder().setUniqueId(uniqueId).build());
        }
        this.request = builder.setRequestType(requestType).build();
    }

    public ExtensionRequest(StreamInput in) throws IOException {
        super(in);
        this.request = ExtensionRequestProto.ExtensionRequest.parseFrom(in.readByteArray());
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByteArray(this.request.toByteArray());
    }

    public ExtensionRequestProto.RequestType getRequestType() {
        return this.request.getRequestType();
    }

    public String getUniqueId() {
        return this.request.getIdentity().getUniqueId();
    }

    public String toString() {
        return "ExtensionRequest{" + this.request.toString() + "}";
    }

    public ExtensionIdentityProto.ExtensionIdentity getExtensionIdentity() {
        return this.request.getIdentity();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ExtensionRequest that = (ExtensionRequest)((Object)o);
        return Objects.equals((Object)this.request.getRequestType(), (Object)that.request.getRequestType()) && Objects.equals(this.request.getIdentity().getUniqueId(), that.request.getIdentity().getUniqueId());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.request.getRequestType(), this.request.getIdentity().getUniqueId()});
    }
}

