/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.action;

import io.skylite.core.action.ActionResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.opensearch.extensions.action.ExtensionActionResponse;

public class RemoteExtensionActionResponse
extends ActionResponse {
    private boolean success;
    private ExtensionActionResponse response;

    public RemoteExtensionActionResponse(boolean success, byte[] responseBytes) {
        this.success = success;
        this.response = new ExtensionActionResponse(responseBytes);
    }

    public RemoteExtensionActionResponse(ExtensionActionResponse response) {
        byte[] combinedBytes = response.getResponseBytes();
        this.success = combinedBytes[0] != 0;
        byte[] responseBytes = new byte[combinedBytes.length - 1];
        System.arraycopy(combinedBytes, 1, responseBytes, 0, responseBytes.length);
        this.response = new ExtensionActionResponse(responseBytes);
    }

    public RemoteExtensionActionResponse(StreamInput in) throws IOException {
        this.success = in.readBoolean();
        this.response = new ExtensionActionResponse(in);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public byte[] getResponseBytes() {
        return this.response.getResponseBytes();
    }

    public void setResponseBytes(byte[] responseBytes) {
        this.response = new ExtensionActionResponse(responseBytes);
    }

    public StreamInput getResponseBytesAsStream() {
        return StreamInput.wrap((byte[])this.response.getResponseBytes());
    }

    public String getResponseBytesAsString() {
        return new String(this.response.getResponseBytes(), StandardCharsets.UTF_8);
    }

    public void setResponseBytesAsString(String response) {
        this.response = new ExtensionActionResponse(response.getBytes(StandardCharsets.UTF_8));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.success);
        this.response.writeTo(out);
    }
}

