/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.rest;

import io.lucenia.action.ActionModule;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.http.HttpRequest;
import io.skylite.core.identity.IdentityService;
import io.skylite.core.identity.Subject;
import io.skylite.core.identity.tokens.OnBehalfOfClaims;
import io.skylite.core.identity.tokens.TokenManager;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.MediaType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.extensions.DiscoveryExtensionNode;
import org.opensearch.extensions.rest.ExtensionRestRequest;
import org.opensearch.extensions.rest.RegisterRestActionsRequest;
import org.opensearch.extensions.rest.RestExecuteOnExtensionResponse;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.NamedRoute;

public class RestSendToExtensionAction
extends BaseRestHandler {
    private static final String SEND_TO_EXTENSION_ACTION = "send_to_extension_action";
    private static final Logger logger = LogManager.getLogger(RestSendToExtensionAction.class);
    private final List<RestHandler.Route> routes;
    private final List<RestHandler.DeprecatedRoute> deprecatedRoutes;
    private final String pathPrefix;
    private final DiscoveryExtensionNode discoveryExtensionNode;
    private final TransportService transportService;
    private final IdentityService identityService;
    private static final Set<String> allowList = Set.of("Content-Type");
    private static final Set<String> denyList = Set.of("Authorization", "Proxy-Authorization");

    public RestSendToExtensionAction(RegisterRestActionsRequest restActionsRequest, DiscoveryExtensionNode discoveryExtensionNode, TransportService transportService, ActionModule.DynamicActionRegistry dynamicActionRegistry, IdentityService identityService) {
        String path;
        RestRequest.Method method;
        this.pathPrefix = "/_extensions/_" + restActionsRequest.getUniqueId();
        ArrayList<NamedRoute> restActionsAsRoutes = new ArrayList<NamedRoute>();
        for (String restAction : restActionsRequest.getRestActions()) {
            String name;
            HashSet<String> actionNames = new HashSet<String>();
            String[] parts = restAction.split(" ");
            if (parts.length < 3) {
                throw new IllegalArgumentException("REST action must contain at least a REST method, a route and a unique name");
            }
            try {
                method = RestRequest.Method.valueOf((String)parts[0].trim());
                path = this.pathPrefix + parts[1].trim();
                name = parts[2].trim();
                if (parts.length > 3) {
                    String[] actions;
                    for (String action : actions = parts[3].split(",")) {
                        String trimmed = action.trim();
                        if (trimmed.isEmpty()) continue;
                        actionNames.add(trimmed);
                    }
                }
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                throw new IllegalArgumentException(restAction + " does not begin with a valid REST method");
            }
            logger.info("Registering: " + String.valueOf(method) + " " + path + " " + name);
            NamedRoute nr = new NamedRoute.Builder().method(method).path(path).uniqueName(name).legacyActionNames(actionNames).build();
            restActionsAsRoutes.add(nr);
            dynamicActionRegistry.registerDynamicRoute(nr, this);
        }
        this.routes = Collections.unmodifiableList(restActionsAsRoutes);
        ArrayList<RestHandler.DeprecatedRoute> restActionsAsDeprecatedRoutes = new ArrayList<RestHandler.DeprecatedRoute>();
        List<String> deprecatedActions = restActionsRequest.getDeprecatedRestActions();
        for (int i = 0; i < deprecatedActions.size() - 1; i += 2) {
            String restAction = deprecatedActions.get(i);
            String message = deprecatedActions.get(i + 1);
            int delim = restAction.indexOf(32);
            try {
                method = RestRequest.Method.valueOf((String)restAction.substring(0, delim));
                path = this.pathPrefix + restAction.substring(delim).trim();
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                throw new IllegalArgumentException(restAction + " does not begin with a valid REST method");
            }
            logger.info("Registering: " + String.valueOf(method) + " " + path + " with deprecation message " + message);
            restActionsAsDeprecatedRoutes.add(new RestHandler.DeprecatedRoute(method, path, message));
        }
        this.deprecatedRoutes = Collections.unmodifiableList(restActionsAsDeprecatedRoutes);
        this.discoveryExtensionNode = discoveryExtensionNode;
        this.transportService = transportService;
        this.identityService = identityService;
    }

    @Override
    public String getName() {
        return this.discoveryExtensionNode.getId() + ":send_to_extension_action";
    }

    public List<RestHandler.Route> routes() {
        return this.routes;
    }

    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return this.deprecatedRoutes;
    }

    public Map<String, List<String>> filterHeaders(Map<String, List<String>> headers, Set<String> allowList, Set<String> denyList) {
        Map<String, List<String>> filteredHeaders = headers.entrySet().stream().filter(e -> !denyList.contains(e.getKey())).filter(e -> allowList.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return filteredHeaders;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        HttpRequest httpRequest = request.getHttpRequest();
        String path = request.path();
        RestRequest.Method method = request.method();
        String uri = httpRequest.uri();
        Map params = request.params();
        Map headers = request.getHeaders();
        MediaType contentType = request.getMediaType();
        BytesReference content = request.content();
        HttpRequest.HttpVersion httpVersion = httpRequest.protocolVersion();
        if (path.startsWith(this.pathPrefix)) {
            path = path.substring(this.pathPrefix.length());
        }
        String message = "Forwarding the request " + String.valueOf(method) + " " + path + " to " + String.valueOf((Object)this.discoveryExtensionNode);
        logger.info(message);
        final RestExecuteOnExtensionResponse restExecuteOnExtensionResponse = new RestExecuteOnExtensionResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", message.getBytes(StandardCharsets.UTF_8), Collections.emptyMap(), Collections.emptyList(), false);
        final CompletableFuture inProgressFuture = new CompletableFuture();
        TransportResponseHandler<RestExecuteOnExtensionResponse> restExecuteOnExtensionResponseHandler = new TransportResponseHandler<RestExecuteOnExtensionResponse>(){

            public RestExecuteOnExtensionResponse read(StreamInput in) throws IOException {
                return new RestExecuteOnExtensionResponse(in);
            }

            public void handleResponse(RestExecuteOnExtensionResponse response) {
                logger.info("Received response from extension: {}", (Object)response.getStatus());
                restExecuteOnExtensionResponse.setStatus(response.getStatus());
                restExecuteOnExtensionResponse.setContentType(response.getContentType());
                restExecuteOnExtensionResponse.setContent(response.getContent());
                restExecuteOnExtensionResponse.setHeaders(response.getHeaders());
                response.getConsumedParams().stream().forEach(p -> request.param(p));
                if (response.isContentConsumed()) {
                    request.content();
                }
                inProgressFuture.complete(response);
            }

            public void handleException(TransportException exp) {
                logger.debug("REST request failed", (Throwable)exp);
                request.params().keySet().stream().forEach(p -> request.param(p));
                request.content();
                inProgressFuture.completeExceptionally((Throwable)exp);
            }

            public String executor() {
                return "generic";
            }
        };
        try {
            Map<String, List<String>> filteredHeaders = this.filterHeaders(headers, allowList, denyList);
            TokenManager tokenManager = this.identityService.getTokenManager();
            Subject subject = this.identityService.getSubject();
            OnBehalfOfClaims claims = new OnBehalfOfClaims(this.discoveryExtensionNode.getId(), subject.getPrincipal().getName());
            this.transportService.sendRequest((DiscoveryNode)this.discoveryExtensionNode, "internal:extensions/restexecuteonextensiontaction", (TransportRequest)new ExtensionRestRequest(method, uri, path, params, filteredHeaders, contentType, content, tokenManager.issueOnBehalfOfToken(subject, claims).asAuthHeaderValue(), httpVersion), (TransportResponseHandler)restExecuteOnExtensionResponseHandler);
            inProgressFuture.orTimeout(10L, TimeUnit.SECONDS).join();
        }
        catch (CompletionException e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof TimeoutException) {
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, "No response from extension to request."));
            }
            if (e2.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e2.getCause();
            }
            if (e2.getCause() instanceof Error) {
                throw (Error)e2.getCause();
            }
            throw new RuntimeException(e2.getCause());
        }
        catch (Exception ex) {
            logger.info("Failed to send REST Actions to extension " + this.discoveryExtensionNode.getName(), (Throwable)ex);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, ex.getMessage()));
        }
        BytesRestResponse restResponse = new BytesRestResponse(restExecuteOnExtensionResponse.getStatus(), restExecuteOnExtensionResponse.getContentType(), restExecuteOnExtensionResponse.getContent());
        restExecuteOnExtensionResponse.getHeaders().entrySet().stream().forEach(e -> ((List)e.getValue()).stream().forEach(v -> restResponse.addHeader((String)e.getKey(), (String)v)));
        return channel -> channel.sendResponse((RestResponse)restResponse);
    }
}

