/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.RoutingNodes;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.AllocateUnassignedDecision;
import io.skylite.core.cluster.routing.allocation.AllocationDecision;
import io.skylite.core.cluster.routing.allocation.NodeAllocationResult;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.UnassignedAllocationHandler;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseGatewayShardAllocator {
    protected final Logger logger = LogManager.getLogger(this.getClass());

    public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, UnassignedAllocationHandler unassignedAllocationHandler) {
        AllocateUnassignedDecision allocateUnassignedDecision = this.makeAllocationDecision(shardRouting, allocation, this.logger);
        this.executeDecision(shardRouting, allocateUnassignedDecision, allocation, unassignedAllocationHandler);
    }

    public void allocateUnassignedBatch(List<ShardRouting> shardRoutings, RoutingAllocation allocation) {
        HashMap<ShardRouting, AllocateUnassignedDecision> decisionMap = this.makeAllocationDecision(shardRoutings, allocation, this.logger);
        assert (shardRoutings.size() == decisionMap.size()) : "make allocation decision didn't return allocation decision for some shards";
        RoutingNodes.UnassignedShards.UnassignedIterator iterator = allocation.routingNodes().unassigned().iterator();
        while (iterator.hasNext()) {
            ShardRouting shard = iterator.next();
            try {
                if (decisionMap.isEmpty()) break;
                if (!decisionMap.containsKey(shard)) continue;
                this.executeDecision(shard, decisionMap.remove(shard), allocation, (UnassignedAllocationHandler)iterator);
            }
            catch (Exception e) {
                this.logger.error("Failed to execute decision for shard {} while initializing {}", (Object)shard, (Object)e);
                throw e;
            }
        }
    }

    private void executeDecision(ShardRouting shardRouting, AllocateUnassignedDecision allocateUnassignedDecision, RoutingAllocation allocation, UnassignedAllocationHandler unassignedAllocationHandler) {
        if (!allocateUnassignedDecision.isDecisionTaken()) {
            return;
        }
        if (allocateUnassignedDecision.getAllocationDecision() == AllocationDecision.YES) {
            unassignedAllocationHandler.initialize(allocateUnassignedDecision.getTargetNode().getId(), allocateUnassignedDecision.getAllocationId(), this.getExpectedShardSize(shardRouting, allocation), allocation.changes());
        } else {
            unassignedAllocationHandler.removeAndIgnore(allocateUnassignedDecision.getAllocationStatus(), allocation.changes());
        }
    }

    public void allocateUnassignedBatch(String batchId, RoutingAllocation allocation) {
    }

    protected long getExpectedShardSize(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            if (shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) {
                return allocation.snapshotShardSizeInfo().getShardSize(shardRouting, -1L);
            }
            return -1L;
        }
        return allocation.clusterInfo().getShardSize(shardRouting, -1L);
    }

    public abstract AllocateUnassignedDecision makeAllocationDecision(ShardRouting var1, RoutingAllocation var2, Logger var3);

    public HashMap<ShardRouting, AllocateUnassignedDecision> makeAllocationDecision(List<ShardRouting> unassignedShardBatch, RoutingAllocation allocation, Logger logger) {
        return (HashMap)unassignedShardBatch.stream().collect(Collectors.toMap(unassignedShard -> unassignedShard, unassignedShard -> this.makeAllocationDecision((ShardRouting)unassignedShard, allocation, logger)));
    }

    protected static List<NodeAllocationResult> buildDecisionsForAllNodes(ShardRouting shard, RoutingAllocation allocation) {
        ArrayList<NodeAllocationResult> results = new ArrayList<NodeAllocationResult>();
        for (RoutingNode node : allocation.routingNodes()) {
            Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
            results.add(new NodeAllocationResult(node.node(), null, decision));
        }
        return results;
    }
}

