/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.UnassignedInfo;
import io.skylite.core.cluster.routing.allocation.AllocateUnassignedDecision;
import io.skylite.core.cluster.routing.allocation.NodeAllocationResult;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.env.ShardLockObtainFailedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.gateway.BaseGatewayShardAllocator;
import org.opensearch.gateway.TransportNodesGatewayStartedShardHelper;
import org.opensearch.gateway.TransportNodesListGatewayStartedShards;

public abstract class PrimaryShardAllocator
extends BaseGatewayShardAllocator {
    private static final Comparator<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> NO_STORE_EXCEPTION_FIRST_COMPARATOR = Comparator.comparing(state -> state.storeException() == null).reversed();
    private static final Comparator<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> PRIMARY_FIRST_COMPARATOR = Comparator.comparing(TransportNodesGatewayStartedShardHelper.GatewayStartedShard::primary).reversed();
    private static final Comparator<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> HIGHEST_REPLICATION_CHECKPOINT_FIRST_COMPARATOR = Comparator.comparing(TransportNodesGatewayStartedShardHelper.GatewayStartedShard::replicationCheckpoint, Comparator.nullsLast(Comparator.naturalOrder()));

    protected static boolean isResponsibleFor(ShardRouting shard) {
        return shard.primary() && shard.unassigned() && (shard.recoverySource().getType() == RecoverySource.Type.EXISTING_STORE || shard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT);
    }

    protected AllocateUnassignedDecision getInEligibleShardDecision(ShardRouting unassignedShard, RoutingAllocation allocation) {
        if (!PrimaryShardAllocator.isResponsibleFor(unassignedShard)) {
            return AllocateUnassignedDecision.NOT_TAKEN;
        }
        boolean explain = allocation.debugDecision();
        if (unassignedShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && allocation.snapshotShardSizeInfo().getShardSize(unassignedShard) == null) {
            List<NodeAllocationResult> nodeDecisions = null;
            if (explain) {
                nodeDecisions = PrimaryShardAllocator.buildDecisionsForAllNodes(unassignedShard, allocation);
            }
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, nodeDecisions);
        }
        return null;
    }

    @Override
    public AllocateUnassignedDecision makeAllocationDecision(ShardRouting unassignedShard, RoutingAllocation allocation, Logger logger) {
        AllocateUnassignedDecision decision = this.getInEligibleShardDecision(unassignedShard, allocation);
        if (decision != null) {
            return decision;
        }
        AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState = this.fetchData(unassignedShard, allocation);
        List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> nodeShardStates = PrimaryShardAllocator.adaptToNodeStartedShardList(shardState);
        return this.getAllocationDecision(unassignedShard, allocation, nodeShardStates, logger);
    }

    private static List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> adaptToNodeStartedShardList(AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardsState) {
        if (!shardsState.hasData()) {
            return null;
        }
        ArrayList<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> nodeShardStates = new ArrayList<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard>();
        shardsState.getData().forEach((node, nodeGatewayStartedShard) -> nodeShardStates.add(new TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard(nodeGatewayStartedShard.getGatewayShardStarted().allocationId(), nodeGatewayStartedShard.getGatewayShardStarted().primary(), nodeGatewayStartedShard.getGatewayShardStarted().replicationCheckpoint(), nodeGatewayStartedShard.getGatewayShardStarted().storeException(), (DiscoveryNode)node)));
        return nodeShardStates;
    }

    protected AllocateUnassignedDecision getAllocationDecision(ShardRouting unassignedShard, RoutingAllocation allocation, List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> shardState, Logger logger) {
        boolean snapshotRestore;
        boolean explain = allocation.debugDecision();
        if (shardState == null) {
            allocation.setHasPendingAsyncFetch();
            List<NodeAllocationResult> nodeDecisions = null;
            if (explain) {
                nodeDecisions = PrimaryShardAllocator.buildDecisionsForAllNodes(unassignedShard, allocation);
            }
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, nodeDecisions);
        }
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(unassignedShard.index());
        Set inSyncAllocationIds = indexMetadata.inSyncAllocationIds(unassignedShard.id());
        boolean bl = snapshotRestore = unassignedShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT;
        assert (!inSyncAllocationIds.isEmpty());
        NodeShardsResult nodeShardsResult = PrimaryShardAllocator.buildNodeShardsResult(unassignedShard, snapshotRestore, allocation.getIgnoreNodes(unassignedShard.shardId()), inSyncAllocationIds, shardState, logger);
        boolean enoughAllocationsFound = nodeShardsResult.orderedAllocationCandidates.size() > 0;
        logger.debug("[{}][{}]: found {} allocation candidates of {} based on allocation ids: [{}]", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)nodeShardsResult.orderedAllocationCandidates.size(), (Object)unassignedShard, (Object)inSyncAllocationIds);
        if (!enoughAllocationsFound) {
            if (snapshotRestore) {
                logger.debug("[{}][{}]: missing local data, will restore from [{}]", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard.recoverySource());
                return AllocateUnassignedDecision.NOT_TAKEN;
            }
            logger.debug("[{}][{}]: not allocating, number_of_allocated_shards_found [{}]", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)nodeShardsResult.allocationsFound);
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, explain ? PrimaryShardAllocator.buildNodeDecisions(null, shardState, inSyncAllocationIds) : null);
        }
        NodesToAllocate nodesToAllocate = PrimaryShardAllocator.buildNodesToAllocate(allocation, nodeShardsResult.orderedAllocationCandidates, unassignedShard, false);
        DiscoveryNode node = null;
        String allocationId = null;
        boolean throttled = false;
        if (!nodesToAllocate.yesNodeShards.isEmpty()) {
            decidedNode = nodesToAllocate.yesNodeShards.get(0);
            logger.debug("[{}][{}]: allocating [{}] to [{}] on primary allocation", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)decidedNode.nodeShardState.getNode());
            node = decidedNode.nodeShardState.getNode();
            allocationId = decidedNode.nodeShardState.allocationId();
        } else if (nodesToAllocate.throttleNodeShards.isEmpty() && !nodesToAllocate.noNodeShards.isEmpty()) {
            nodesToAllocate = PrimaryShardAllocator.buildNodesToAllocate(allocation, nodeShardsResult.orderedAllocationCandidates, unassignedShard, true);
            if (!nodesToAllocate.yesNodeShards.isEmpty()) {
                decidedNode = nodesToAllocate.yesNodeShards.get(0);
                TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard nodeShardState = decidedNode.nodeShardState;
                logger.debug("[{}][{}]: allocating [{}] to [{}] on forced primary allocation", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)nodeShardState.getNode());
                node = nodeShardState.getNode();
                allocationId = nodeShardState.allocationId();
            } else if (!nodesToAllocate.throttleNodeShards.isEmpty()) {
                logger.debug("[{}][{}]: throttling allocation [{}] to [{}] on forced primary allocation", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, nodesToAllocate.throttleNodeShards);
                throttled = true;
            } else {
                logger.debug("[{}][{}]: forced primary allocation denied [{}]", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard);
            }
        } else {
            logger.debug("[{}][{}]: throttling allocation [{}] to [{}] on primary allocation", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, nodesToAllocate.throttleNodeShards);
            throttled = true;
        }
        List<NodeAllocationResult> nodeResults = null;
        if (explain) {
            nodeResults = PrimaryShardAllocator.buildNodeDecisions(nodesToAllocate, shardState, inSyncAllocationIds);
        }
        if (allocation.hasPendingAsyncFetch()) {
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, nodeResults);
        }
        if (node != null) {
            return AllocateUnassignedDecision.yes((DiscoveryNode)node, (String)allocationId, nodeResults, (boolean)false);
        }
        if (throttled) {
            return AllocateUnassignedDecision.throttle(nodeResults);
        }
        return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.DECIDERS_NO, nodeResults, (boolean)true);
    }

    private static List<NodeAllocationResult> buildNodeDecisions(NodesToAllocate nodesToAllocate, List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> fetchedShardData, Set<String> inSyncAllocationIds) {
        ArrayList<NodeAllocationResult> nodeResults = new ArrayList<NodeAllocationResult>();
        Collection<Object> ineligibleShards = new ArrayList();
        if (nodesToAllocate != null) {
            HashSet discoNodes = new HashSet();
            nodeResults.addAll(Stream.of(nodesToAllocate.yesNodeShards, nodesToAllocate.throttleNodeShards, nodesToAllocate.noNodeShards).flatMap(Collection::stream).map(dnode -> {
                discoNodes.add(dnode.nodeShardState.getNode());
                return new NodeAllocationResult(dnode.nodeShardState.getNode(), PrimaryShardAllocator.shardStoreInfo(dnode.nodeShardState, inSyncAllocationIds), dnode.decision);
            }).collect(Collectors.toList()));
            ineligibleShards = fetchedShardData.stream().filter(shardData -> !discoNodes.contains(shardData.getNode())).collect(Collectors.toList());
        } else {
            ineligibleShards = fetchedShardData;
        }
        nodeResults.addAll(ineligibleShards.stream().map(shardData -> new NodeAllocationResult(shardData.getNode(), PrimaryShardAllocator.shardStoreInfo(shardData, inSyncAllocationIds), null)).collect(Collectors.toList()));
        return nodeResults;
    }

    private static NodeAllocationResult.ShardStoreInfo shardStoreInfo(TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard nodeShardState, Set<String> inSyncAllocationIds) {
        Exception storeErr = nodeShardState.storeException();
        boolean inSync = nodeShardState.allocationId() != null && inSyncAllocationIds.contains(nodeShardState.allocationId());
        return new NodeAllocationResult.ShardStoreInfo(nodeShardState.allocationId(), inSync, storeErr);
    }

    protected static NodeShardsResult buildNodeShardsResult(ShardRouting shard, boolean matchAnyShard, Set<String> ignoreNodes, Set<String> inSyncAllocationIds, List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> shardState, Logger logger) {
        ArrayList<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> nodeShardStates = new ArrayList<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard>();
        int numberOfAllocationsFound = 0;
        for (TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard nodeShardState : shardState) {
            DiscoveryNode node = nodeShardState.getNode();
            String allocationId = nodeShardState.allocationId();
            if (ignoreNodes.contains(node.getId())) continue;
            if (nodeShardState.storeException() == null) {
                if (allocationId == null) {
                    logger.trace("[{}] on node [{}] has no shard state information", (Object)shard, (Object)nodeShardState.getNode());
                } else {
                    logger.trace("[{}] on node [{}] has allocation id [{}]", (Object)shard, (Object)nodeShardState.getNode(), (Object)allocationId);
                }
            } else {
                String finalAllocationId = allocationId;
                if (nodeShardState.storeException() instanceof ShardLockObtainFailedException) {
                    logger.trace(() -> new ParameterizedMessage("[{}] on node [{}] has allocation id [{}] but the store can not be opened as it's locked, treating as valid shard", new Object[]{shard, nodeShardState.getNode(), finalAllocationId}), (Throwable)nodeShardState.storeException());
                } else {
                    logger.trace(() -> new ParameterizedMessage("[{}] on node [{}] has allocation id [{}] but the store can not be opened, treating as no allocation id", new Object[]{shard, nodeShardState.getNode(), finalAllocationId}), (Throwable)nodeShardState.storeException());
                    allocationId = null;
                }
            }
            if (allocationId == null) continue;
            assert (nodeShardState.storeException() == null || nodeShardState.storeException() instanceof ShardLockObtainFailedException) : "only allow store that can be opened or that throws a ShardLockObtainFailedException while being opened but got a store throwing " + String.valueOf(nodeShardState.storeException());
            ++numberOfAllocationsFound;
            if (!matchAnyShard && !inSyncAllocationIds.contains(nodeShardState.allocationId())) continue;
            nodeShardStates.add(nodeShardState);
        }
        nodeShardStates.sort(PrimaryShardAllocator.createActiveShardComparator(matchAnyShard, inSyncAllocationIds));
        if (logger.isTraceEnabled()) {
            logger.trace("{} candidates for allocation: {}", (Object)shard, (Object)nodeShardStates.stream().map(s -> s.getNode().getName()).collect(Collectors.joining(", ")));
        }
        return new NodeShardsResult(nodeShardStates, numberOfAllocationsFound);
    }

    private static Comparator<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> createActiveShardComparator(boolean matchAnyShard, Set<String> inSyncAllocationIds) {
        Comparator<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> comparator;
        if (matchAnyShard) {
            Comparator<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> matchingAllocationsFirst = Comparator.comparing(state -> inSyncAllocationIds.contains(state.allocationId())).reversed();
            comparator = matchingAllocationsFirst.thenComparing(NO_STORE_EXCEPTION_FIRST_COMPARATOR).thenComparing(PRIMARY_FIRST_COMPARATOR).thenComparing(HIGHEST_REPLICATION_CHECKPOINT_FIRST_COMPARATOR);
        } else {
            comparator = NO_STORE_EXCEPTION_FIRST_COMPARATOR.thenComparing(PRIMARY_FIRST_COMPARATOR).thenComparing(HIGHEST_REPLICATION_CHECKPOINT_FIRST_COMPARATOR);
        }
        return comparator;
    }

    private static NodesToAllocate buildNodesToAllocate(RoutingAllocation allocation, List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> nodeShardStates, ShardRouting shardRouting, boolean forceAllocate) {
        ArrayList<DecidedNode> yesNodeShards = new ArrayList<DecidedNode>();
        ArrayList<DecidedNode> throttledNodeShards = new ArrayList<DecidedNode>();
        ArrayList<DecidedNode> noNodeShards = new ArrayList<DecidedNode>();
        for (TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard nodeShardState : nodeShardStates) {
            RoutingNode node = allocation.routingNodes().node(nodeShardState.getNode().getId());
            if (node == null) continue;
            Decision decision = forceAllocate ? allocation.deciders().canForceAllocatePrimary(shardRouting, node, allocation) : allocation.deciders().canAllocate(shardRouting, node, allocation);
            DecidedNode decidedNode = new DecidedNode(nodeShardState, decision);
            if (decision.type() == Decision.Type.THROTTLE) {
                throttledNodeShards.add(decidedNode);
                continue;
            }
            if (decision.type() == Decision.Type.NO) {
                noNodeShards.add(decidedNode);
                continue;
            }
            yesNodeShards.add(decidedNode);
        }
        return new NodesToAllocate(Collections.unmodifiableList(yesNodeShards), Collections.unmodifiableList(throttledNodeShards), Collections.unmodifiableList(noNodeShards));
    }

    protected abstract AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(ShardRouting var1, RoutingAllocation var2);

    static class NodeShardsResult {
        final List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> orderedAllocationCandidates;
        final int allocationsFound;

        NodeShardsResult(List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> orderedAllocationCandidates, int allocationsFound) {
            this.orderedAllocationCandidates = orderedAllocationCandidates;
            this.allocationsFound = allocationsFound;
        }
    }

    protected static class NodesToAllocate {
        final List<DecidedNode> yesNodeShards;
        final List<DecidedNode> throttleNodeShards;
        final List<DecidedNode> noNodeShards;

        NodesToAllocate(List<DecidedNode> yesNodeShards, List<DecidedNode> throttleNodeShards, List<DecidedNode> noNodeShards) {
            this.yesNodeShards = yesNodeShards;
            this.throttleNodeShards = throttleNodeShards;
            this.noNodeShards = noNodeShards;
        }
    }

    private static class DecidedNode {
        final TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard nodeShardState;
        final Decision decision;

        private DecidedNode(TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard nodeShardState, Decision decision) {
            this.nodeShardState = nodeShardState;
            this.decision = decision;
        }
    }
}

