/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import io.skylite.common.collect.Tuple;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.UnassignedInfo;
import io.skylite.core.cluster.routing.allocation.AllocateUnassignedDecision;
import io.skylite.core.cluster.routing.allocation.NodeAllocationResult;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.index.shard.ShardId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.gateway.ReplicaShardAllocator;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadata;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadataBatch;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadataHelper;

public abstract class ReplicaShardBatchAllocator
extends ReplicaShardAllocator {
    public void processExistingRecoveries(RoutingAllocation allocation, List<List<ShardRouting>> shardBatches) {
        ArrayList<Runnable> shardCancellationActions = new ArrayList<Runnable>();
        for (List<ShardRouting> shardBatch : shardBatches) {
            ArrayList<ShardRouting> eligibleShards = new ArrayList<ShardRouting>();
            ArrayList<ShardRouting> ineligibleShards = new ArrayList<ShardRouting>();
            for (ShardRouting shard : shardBatch) {
                if (shard == null || shard.primary() || this.shouldSkipFetchForRecovery(shard)) continue;
                eligibleShards.add(shard);
            }
            AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadataBatch> shardState = this.fetchData(eligibleShards, ineligibleShards, allocation);
            if (!shardState.hasData()) {
                this.logger.trace("{}: fetching new stores for initializing shard batch", eligibleShards);
                continue;
            }
            for (ShardRouting shard : eligibleShards) {
                Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> nodeShardStores;
                Runnable cancellationAction = this.cancelExistingRecoveryForBetterMatch(shard, allocation, nodeShardStores = this.convertToNodeStoreFilesMetadataMap(shard, shardState));
                if (cancellationAction == null) continue;
                shardCancellationActions.add(cancellationAction);
            }
        }
        for (Runnable action : shardCancellationActions) {
            action.run();
        }
    }

    protected abstract AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadataBatch> fetchData(List<ShardRouting> var1, List<ShardRouting> var2, RoutingAllocation var3);

    @Override
    protected AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> fetchData(ShardRouting shard, RoutingAllocation allocation) {
        this.logger.error("fetchData for single shard called via batch allocator");
        throw new IllegalStateException("ReplicaShardBatchAllocator should only be used for a batch of shards");
    }

    @Override
    public AllocateUnassignedDecision makeAllocationDecision(ShardRouting unassignedShard, RoutingAllocation allocation, Logger logger) {
        return this.makeAllocationDecision(Collections.singletonList(unassignedShard), allocation, logger).get(unassignedShard);
    }

    @Override
    public HashMap<ShardRouting, AllocateUnassignedDecision> makeAllocationDecision(List<ShardRouting> shards, RoutingAllocation allocation, Logger logger) {
        HashMap<ShardRouting, AllocateUnassignedDecision> shardAllocationDecisions = new HashMap<ShardRouting, AllocateUnassignedDecision>();
        boolean explain = allocation.debugDecision();
        ArrayList<ShardRouting> eligibleShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> ineligibleShards = new ArrayList<ShardRouting>();
        HashMap<ShardRouting, Tuple<Decision, Map<String, NodeAllocationResult>>> nodeAllocationDecisions = new HashMap<ShardRouting, Tuple<Decision, Map<String, NodeAllocationResult>>>();
        for (ShardRouting shard : shards) {
            if (!ReplicaShardBatchAllocator.isResponsibleFor(shard)) {
                ineligibleShards.add(shard);
                shardAllocationDecisions.put(shard, AllocateUnassignedDecision.NOT_TAKEN);
                continue;
            }
            Tuple<Decision, Map<String, NodeAllocationResult>> result = ReplicaShardBatchAllocator.canBeAllocatedToAtLeastOneNode(shard, allocation);
            Decision allocationDecision = (Decision)result.v1();
            if (!(allocationDecision.type() == Decision.Type.YES || explain && this.hasInitiatedFetching(shard))) {
                logger.trace("{}: ignoring allocation, can't be allocated on any node", (Object)shard);
                shardAllocationDecisions.put(shard, AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.fromDecision((Decision.Type)allocationDecision.type()), (List)(result.v2() != null ? new ArrayList(((Map)result.v2()).values()) : null)));
                continue;
            }
            nodeAllocationDecisions.put(shard, result);
            eligibleShards.add(shard);
        }
        if (eligibleShards.isEmpty()) {
            return shardAllocationDecisions;
        }
        AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadataBatch> shardsState = this.fetchData(eligibleShards, ineligibleShards, allocation);
        for (ShardRouting unassignedShard : eligibleShards) {
            Tuple result = (Tuple)nodeAllocationDecisions.get(unassignedShard);
            shardAllocationDecisions.put(unassignedShard, this.getAllocationDecision(unassignedShard, allocation, this.convertToNodeStoreFilesMetadataMap(unassignedShard, shardsState), (Tuple<Decision, Map<String, NodeAllocationResult>>)result, logger));
        }
        return shardAllocationDecisions;
    }

    private Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> convertToNodeStoreFilesMetadataMap(ShardRouting unassignedShard, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadataBatch> data) {
        if (!data.hasData()) {
            return null;
        }
        HashMap<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> map = new HashMap<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata>();
        data.getData().forEach((discoveryNode, value) -> {
            Map<ShardId, TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadata> batch = value.getNodeStoreFilesMetadataBatch();
            TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadata metadata = batch.get(unassignedShard.shardId());
            if (metadata != null) {
                map.put((DiscoveryNode)discoveryNode, metadata.storeFilesMetadata());
            }
        });
        return map;
    }
}

