/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionFuture;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.support.PlainActionFuture;
import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.action.support.nodes.BaseNodesRequest;
import io.skylite.core.action.support.nodes.BaseNodesResponse;
import io.skylite.core.cluster.ClusterName;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import org.opensearch.gateway.GatewayMetaState;

public class TransportNodesListGatewayMetaState
extends TransportNodesAction<Request, NodesGatewayMetaState, NodeRequest, NodeGatewayMetaState> {
    public static final String ACTION_NAME = "internal:gateway/local/meta_state";
    public static final ActionType<NodesGatewayMetaState> TYPE = new ActionType("internal:gateway/local/meta_state", NodesGatewayMetaState::new);
    private final GatewayMetaState metaState;

    @Inject
    public TransportNodesListGatewayMetaState(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, GatewayMetaState metaState) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "generic", NodeGatewayMetaState.class);
        this.metaState = metaState;
    }

    public ActionFuture<NodesGatewayMetaState> list(String[] nodesIds, @Nullable TimeValue timeout) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        this.execute((ActionRequest)((Request)new Request(nodesIds).timeout(timeout)), (ActionListener)future);
        return future;
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest();
    }

    @Override
    protected NodeGatewayMetaState newNodeResponse(StreamInput in) throws IOException {
        return new NodeGatewayMetaState(in);
    }

    @Override
    protected NodesGatewayMetaState newResponse(Request request, List<NodeGatewayMetaState> responses, List<FailedNodeException> failures) {
        return new NodesGatewayMetaState(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeGatewayMetaState nodeOperation(NodeRequest request) {
        return new NodeGatewayMetaState(this.clusterService.localNode(), this.metaState.getMetadata());
    }

    public static class NodeGatewayMetaState
    extends BaseNodeResponse {
        private Metadata metadata;

        public NodeGatewayMetaState(StreamInput in) throws IOException {
            super(in);
            if (in.readBoolean()) {
                this.metadata = Metadata.readFrom((StreamInput)in);
            }
        }

        public NodeGatewayMetaState(DiscoveryNode node, Metadata metadata) {
            super(node);
            this.metadata = metadata;
        }

        public Metadata metadata() {
            return this.metadata;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.metadata == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.metadata.writeTo(out);
            }
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public Request(String ... nodesIds) {
            super(nodesIds);
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        NodeRequest() {
        }

        NodeRequest(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static class NodesGatewayMetaState
    extends BaseNodesResponse<NodeGatewayMetaState> {
        public NodesGatewayMetaState(StreamInput in) throws IOException {
            super(in);
        }

        public NodesGatewayMetaState(ClusterName clusterName, List<NodeGatewayMetaState> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeGatewayMetaState> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeGatewayMetaState::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeGatewayMetaState> nodes) throws IOException {
            out.writeList(nodes);
        }
    }
}

